<HTML>
<HEAD>
<TITLE>SRC Modula-3: geometry/src/Point.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>geometry/src/Point.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="Point.i3">Point</A></implements></module>;

IMPORT <A HREF="../../word/src/Word.i3">Word</A>, <A HREF="Axis.i3">Axis</A>;

PROCEDURE <A NAME="FromCoords"><procedure>FromCoords</procedure></A> (h, v: INTEGER): T RAISES {} =
  VAR p: T;
  BEGIN
    p.h := h;
    p.v := v;
    RETURN p;
  END FromCoords;

PROCEDURE <A NAME="FromAxes"><procedure>FromAxes</procedure></A> (axis: Axis.T; n, m: INTEGER): T RAISES {} =
  VAR p: T;
  BEGIN
    CASE axis OF
    | Axis.T.Hor =&gt; p.h := n; p.v := m;
    | Axis.T.Ver =&gt; p.h := m; p.v := n;
    END;
    RETURN p;
  END FromAxes;

PROCEDURE <A NAME="DistSquare"><procedure>DistSquare</procedure></A> (READONLY p, q: T): INTEGER RAISES {} =
  VAR dh, dv: INTEGER;
  BEGIN
    dh := p.h - q.h;
    dv := p.v - q.v;
    RETURN dh * dh + dv * dv;
  END DistSquare;

PROCEDURE <A NAME="Minus"><procedure>Minus</procedure></A> (READONLY p: T): T RAISES {} =
  VAR q: T;
  BEGIN
    q.h :=  -p.h;
    q.v :=  -p.v;
    RETURN q;
  END Minus;

PROCEDURE <A NAME="Add"><procedure>Add</procedure></A> (READONLY p, q: T): T RAISES {} =
  VAR r: T;
  BEGIN
    r.h := p.h + q.h;
    r.v := p.v + q.v;
    RETURN r;
  END Add;

PROCEDURE <A NAME="Sub"><procedure>Sub</procedure></A> (READONLY p, q: T): T RAISES {} =
  VAR r: T;
  BEGIN
    r.h := p.h - q.h;
    r.v := p.v - q.v;
    RETURN r;
  END Sub;

PROCEDURE <A NAME="Mul"><procedure>Mul</procedure></A> (READONLY p: T; n: INTEGER): T RAISES {} =
  VAR q: T;
  BEGIN
    q.h := p.h * n;
    q.v := p.v * n;
    RETURN q;
  END Mul;

PROCEDURE <A NAME="Div"><procedure>Div</procedure></A> (READONLY p: T; n: INTEGER): T RAISES {} =
  VAR q: T;
  BEGIN
    q.h := p.h DIV n;
    q.v := p.v DIV n;
    RETURN q;
  END Div;

PROCEDURE <A NAME="Mod"><procedure>Mod</procedure></A> (READONLY p: T; n: INTEGER): T RAISES {} =
  VAR q: T;
  BEGIN
    q.h := p.h MOD n;
    IF q.h &lt; 0 THEN q.h := q.h + n END;
    q.v := p.v MOD n;
    IF q.v &lt; 0 THEN q.v := q.v + n END;
    RETURN q;
  END Mod;

PROCEDURE <A NAME="Scale"><procedure>Scale</procedure></A> (READONLY p: T; num, den: INTEGER): T RAISES {} =
  VAR q: T;
  BEGIN
    q.h := (p.h * num) DIV den;
    q.v := (p.v * num) DIV den;
    RETURN q;
  END Scale;

PROCEDURE <A NAME="Min"><procedure>Min</procedure></A> (READONLY p, q: T): T RAISES {} =
  VAR r: T;
  BEGIN
    r.h := MIN (p.h, q.h);
    r.v := MIN (p.v, q.v);
    RETURN r;
  END Min;

PROCEDURE <A NAME="Max"><procedure>Max</procedure></A> (READONLY p, q: T): T RAISES {} =
  VAR r: T;
  BEGIN
    r.h := MAX (p.h, q.h);
    r.v := MAX (p.v, q.v);
    RETURN r;
  END Max;

PROCEDURE <A NAME="Move"><procedure>Move</procedure></A> (READONLY p, dp: T): T RAISES {} =
  VAR r: T;
  BEGIN
    r.h := p.h + dp.h;
    r.v := p.v + dp.v;
    RETURN r;
  END Move;

PROCEDURE <A NAME="MoveH"><procedure>MoveH</procedure></A> (READONLY p: T; dh: INTEGER): T RAISES {} =
  VAR r: T;
  BEGIN
    r.h := p.h + dh;
    r.v := p.v;
    RETURN r;
  END MoveH;

PROCEDURE <A NAME="MoveV"><procedure>MoveV</procedure></A> (READONLY p: T; dv: INTEGER): T RAISES {} =
  VAR r: T;
  BEGIN
    r.h := p.h;
    r.v := p.v + dv;
    RETURN r;
  END MoveV;

PROCEDURE <A NAME="MoveHV"><procedure>MoveHV</procedure></A> (READONLY p: T; dh, dv: INTEGER): T RAISES {} =
  VAR r: T;
  BEGIN
    r.h := p.h + dh;
    r.v := p.v + dv;
    RETURN r;
  END MoveHV;

PROCEDURE <A NAME="Transpose"><procedure>Transpose</procedure></A>(READONLY p: T; ax := Axis.T.Ver): T =
  BEGIN
    IF ax = Axis.T.Hor THEN RETURN p ELSE RETURN T{p.v,p.h} END
  END Transpose;

PROCEDURE <A NAME="Equal"><procedure>Equal</procedure></A> (READONLY p, q: T): BOOLEAN RAISES {} =
  BEGIN
    RETURN (p.h = q.h) AND (p.v = q.v);
  END Equal;

PROCEDURE <A NAME="Less"><procedure>Less</procedure></A> (READONLY p, q: T): BOOLEAN RAISES {} =
  BEGIN
    RETURN (p.h &lt; q.h) AND (p.v &lt; q.v);
  END Less;

PROCEDURE <A NAME="LessEq"><procedure>LessEq</procedure></A> (READONLY p, q: T): BOOLEAN RAISES {} =
  BEGIN
    RETURN (p.h &lt;= q.h) AND (p.v &lt;= q.v);
  END LessEq;

PROCEDURE <A NAME="Compare"><procedure>Compare</procedure></A> (READONLY a, b: T): [-1..1] =
  BEGIN
    IF (a.h &lt; b.h) THEN
      RETURN  -1;
    ELSIF (a.h &gt; b.h) THEN
      RETURN  +1;
    ELSIF (a.v = b.v) THEN
      RETURN 0;
    ELSIF (a.v &lt; b.v) THEN
      RETURN  -1;
    ELSE
      RETURN  +1;
    END;
  END Compare;

PROCEDURE <A NAME="Hash"><procedure>Hash</procedure></A> (READONLY a: T): INTEGER =
  BEGIN
    RETURN Word.Xor (a.h, a.v);
  END Hash;

BEGIN
END Point.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
