<HTML>
<HEAD>
<TITLE>SRC Modula-3: geometry/src/PolyRegion.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>geometry/src/PolyRegion.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;

INTERFACE <interface><A HREF="PolyRegion.m3">PolyRegion</A></interface>;

IMPORT <A HREF="Rect.i3">Rect</A>, <A HREF="Region.i3">Region</A>, <A HREF="Point.i3">Point</A>;
</PRE> A PolyRegion.T represents a set of points as a list of Region.T's. 
   If n rectangles are joined together into a PolyRegion.T with the
   JoinRect procedure below, the PolyRegion will contain about lg n
   Regions, and the total cost of the join is likely to be
   about n (lg n)^2 instead of n^2, assuming the rectangles don't
   overlap too badly. 
   <P>
   The procedures modify the data structure pointed to by the private
   field of a PolyRegion; therefore, you must not assign PolyRegions.  

<P><PRE>TYPE
  T = RECORD r: Rect.T; p: Private END;
  (* pr.r is the bounding rectangle of the PolyRegion pr. *)
  <A HREF="PolyRegion.m3#Private">Private</A> &lt;: REFANY;

PROCEDURE <A HREF="PolyRegion.m3#JoinRect">JoinRect</A>(VAR pr: T; READONLY rect: Rect.T);
</PRE><BLOCKQUOTE><EM> pr := Union(pr, rect). </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="PolyRegion.m3#JoinRgn">JoinRgn</A>(VAR pr: T; READONLY rgn: Region.T);
</PRE><BLOCKQUOTE><EM> pr := Union(pr, rgn). </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="PolyRegion.m3#ToRegion">ToRegion</A>(READONLY pr: T): Region.T;
</PRE><BLOCKQUOTE><EM> Return pr as a region. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="PolyRegion.m3#OverlapRect">OverlapRect</A>(READONLY pr: T; READONLY rect: Rect.T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return whether pr and rect have a non-empty intersection. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="PolyRegion.m3#Complement">Complement</A>(READONLY pr: T; READONLY rgn: Region.T): Region.T;
</PRE><BLOCKQUOTE><EM> Return rgn-pr as a region. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="PolyRegion.m3#Meet">Meet</A>(READONLY pr: T; READONLY rgn: Region.T): Region.T;
</PRE><BLOCKQUOTE><EM> Return the intersection of pr and rgn as a region. </EM></BLOCKQUOTE><PRE>

CONST Empty = T{Rect.Empty, NIL};
</PRE> The following procedure belongs in Region 

<P><PRE>PROCEDURE <A HREF="PolyRegion.m3#Factor">Factor</A>(READONLY t: Region.T; READONLY r: Rect.T;
  READONLY delta: Point.T; VAR rl: REF ARRAY OF Rect.T): CARDINAL;
</PRE><BLOCKQUOTE><EM> Set rl to a list of disjoint rectangles which partition t meetrect
   r, modifying rl^ if possible.  Return the number of rectangles, n,
   in the partition; only the first n rectangles in rl^ are meaningful.
   The order of rl^ is such that if i&lt;j then rl[i] translated by delta
   doesn't intersect rl[j].  If the intersection is empty, 0 is returned. </EM></BLOCKQUOTE><PRE>

END PolyRegion.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
