<HTML>
<HEAD>
<TITLE>SRC Modula-3: geometry/src/Rect.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>geometry/src/Rect.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="Rect.i3">Rect</A></implements></module>;

IMPORT <A HREF="../../word/src/Word.i3">Word</A>, <A HREF="Point.i3">Point</A>, <A HREF="Axis.i3">Axis</A>, <A HREF="Interval.i3">Interval</A>;

PROCEDURE <A NAME="FromEdges"><procedure>FromEdges</procedure></A> (w, e, n, s: INTEGER): T RAISES {} =
  VAR r: T;
  BEGIN
    IF (w &gt;= e) OR (n &gt;= s) THEN RETURN Empty;  END;
    r.west := w;
    r.east := e;
    r.north := n;
    r.south := s;
    RETURN r;
  END FromEdges;

PROCEDURE <A NAME="FromAbsEdges"><procedure>FromAbsEdges</procedure></A> (w, e, n, s: INTEGER): T RAISES {} =
  VAR r: T;
  BEGIN
    IF (w = e) OR (n = s) THEN RETURN Empty;  END;
    IF (w &lt; e) THEN
      r.west := w;
      r.east := e;
    ELSE
      r.west := e;
      r.east := w;
    END;
    IF (n &lt; s) THEN
      r.north := n;
      r.south := s;
    ELSE
      r.north := s;
      r.south := n;
    END;
    RETURN r;
  END FromAbsEdges;

PROCEDURE <A NAME="FromPoint"><procedure>FromPoint</procedure></A> (READONLY p: Point.T): T RAISES {} =
  BEGIN
    RETURN FromEdges (p.h, p.h + 1, p.v, p.v + 1);
  END FromPoint;

PROCEDURE <A NAME="FromCorners"><procedure>FromCorners</procedure></A> (READONLY p, q: Point.T): T RAISES {} =
  BEGIN
    RETURN FromAbsEdges (p.h, q.h, p.v, q.v);
  END FromCorners;

PROCEDURE <A NAME="FromCorner"><procedure>FromCorner</procedure></A> (READONLY p: Point.T; hor, ver: CARDINAL): T RAISES {} =
  VAR r: T;
  BEGIN
    IF (hor = 0) OR (ver = 0) THEN RETURN Empty;  END;
    r.west := p.h;
    r.east := p.h + hor;
    r.north := p.v;
    r.south := p.v + ver;
    RETURN r;
  END FromCorner;

PROCEDURE <A NAME="FromSize"><procedure>FromSize</procedure></A> (hor, ver: CARDINAL): T RAISES {} =
  VAR r: T;
  BEGIN
    IF (hor = 0) OR (ver = 0) THEN RETURN Empty;  END;
    r.west := 0;
    r.east := hor;
    r.north := 0;
    r.south := ver;
    RETURN r;
  END FromSize;

PROCEDURE <A NAME="Center"><procedure>Center</procedure></A> (READONLY r: T; READONLY p: Point.T): T RAISES {} =
  VAR res: T; h, v: INTEGER;
  BEGIN
    IF r.west &gt;= r.east THEN RETURN Empty END;
    h := p.h - (r.west + r.east) DIV 2;
    v := p.v - (r.north + r.south) DIV 2;
    res.west := r.west + h;
    res.east := r.east + h;
    res.north := r.north + v;
    res.south := r.south + v;
    RETURN res
  END Center;

PROCEDURE <A NAME="FromIntervals"><procedure>FromIntervals</procedure></A> (READONLY hor, ver: Interval.T): T RAISES {} =
  VAR r: T;
  BEGIN
    IF (hor.lo = hor.hi) OR (ver.lo = ver.hi) THEN RETURN Empty;  END;
    r.west := hor.lo;
    r.east := hor.hi;
    r.north := ver.lo;
    r.south := ver.hi;
    RETURN r;
  END FromIntervals;

PROCEDURE <A NAME="FromAxes"><procedure>FromAxes</procedure></A> (axis: Axis.T; READONLY n, m: Interval.T): T RAISES {} =
  VAR r: T;
  BEGIN
    IF (n.lo = n.hi) OR (m.lo = m.hi) THEN RETURN Empty END;
    IF (axis = Axis.T.Hor) THEN
      r.west := n.lo;
      r.east := n.hi;
      r.north := m.lo;
      r.south := m.hi;
    ELSE
      r.west := m.lo;
      r.east := m.hi;
      r.north := n.lo;
      r.south := n.hi;
    END;
    RETURN r
  END FromAxes;

PROCEDURE <A NAME="NorthWest"><procedure>NorthWest</procedure></A> (READONLY r: T): Point.T RAISES {} =
  VAR p: Point.T;
  BEGIN
    p.h := r.west;
    p.v := r.north;
    RETURN p;
  END NorthWest;

PROCEDURE <A NAME="NorthEast"><procedure>NorthEast</procedure></A> (READONLY r: T): Point.T RAISES {} =
  VAR p: Point.T;
  BEGIN
    p.h := r.east;
    p.v := r.north;
    RETURN p;
  END NorthEast;

PROCEDURE <A NAME="SouthWest"><procedure>SouthWest</procedure></A> (READONLY r: T): Point.T RAISES {} =
  VAR p: Point.T;
  BEGIN
    p.h := r.west;
    p.v := r.south;
    RETURN p;
  END SouthWest;

PROCEDURE <A NAME="SouthEast"><procedure>SouthEast</procedure></A> (READONLY r: T): Point.T RAISES {} =
  VAR p: Point.T;
  BEGIN
    p.h := r.east;
    p.v := r.south;
    RETURN p;
  END SouthEast;

PROCEDURE <A NAME="GetVertex"><procedure>GetVertex</procedure></A> (v: Vertex; READONLY r: T): Point.T RAISES {} =
  BEGIN
    IF (r.west &gt;= r.east)(* OR (r.north&gt;=r.south) *)  THEN
      RETURN Point.Origin;
    END;
    CASE v OF
      | Vertex.NW =&gt; RETURN NorthWest (r);
      | Vertex.NE =&gt; RETURN NorthEast (r);
      | Vertex.SW =&gt; RETURN SouthWest (r);
      | Vertex.SE =&gt; RETURN SouthEast (r);
    END;
  END GetVertex;

PROCEDURE <A NAME="HorSize"><procedure>HorSize</procedure></A> (READONLY r: T): CARDINAL RAISES {} =
  BEGIN
    RETURN r.east - r.west;
  END HorSize;

PROCEDURE <A NAME="VerSize"><procedure>VerSize</procedure></A> (READONLY r: T): CARDINAL RAISES {} =
  BEGIN
    RETURN r.south - r.north
  END VerSize;

PROCEDURE <A NAME="Size"><procedure>Size</procedure></A> (a: Axis.T; READONLY r: T): CARDINAL RAISES {} =
  BEGIN
    CASE a OF
      | Axis.T.Hor =&gt; RETURN HorSize (r);
      | Axis.T.Ver =&gt; RETURN VerSize (r);
    END;
  END Size;

PROCEDURE <A NAME="DiagSizeSquare"><procedure>DiagSizeSquare</procedure></A> (READONLY r: T): CARDINAL RAISES {} =
  VAR hor, ver: INTEGER;
  BEGIN
    hor := HorSize (r);
    ver := VerSize (r);
    RETURN hor * hor + ver * ver;
  END DiagSizeSquare;

PROCEDURE <A NAME="Middle"><procedure>Middle</procedure></A> (READONLY r: T): Point.T RAISES {} =
  BEGIN
    RETURN Point.T{(r.west+r.east) DIV 2, (r.north+r.south) DIV 2}
  END Middle;

PROCEDURE <A NAME="PickEdge"><procedure>PickEdge</procedure></A> (READONLY r: T; READONLY p: Point.T): Edge RAISES {} =
  VAR mid, se, q: Point.T; a, b: INTEGER;
  BEGIN
    mid := Middle (r);
    se := Point.Sub (SouthEast (r), mid);
    q := Point.Sub (p, mid);
    a := se.v * q.h;
    b := se.h * q.v;
    IF a &gt;= b THEN
      IF -a &gt;= b THEN RETURN Edge.N ELSE RETURN Edge.E END;
    ELSE
      IF -a &gt;= b THEN RETURN Edge.W ELSE RETURN Edge.S END;
    END;
  END PickEdge;

PROCEDURE <A NAME="PickVertex"><procedure>PickVertex</procedure></A> (READONLY r: T; READONLY p: Point.T): Vertex RAISES {} =
  VAR q: Point.T;
  BEGIN
    q := Point.Sub (p, Middle (r));
    IF q.h &gt; 0 THEN
      IF q.v &gt; 0 THEN RETURN Vertex.SE ELSE RETURN Vertex.NE END;
    ELSE
      IF q.v &gt; 0 THEN RETURN Vertex.SW ELSE RETURN Vertex.NW END;
    END;
  END PickVertex;

PROCEDURE <A NAME="Project"><procedure>Project</procedure></A> (READONLY r: T; READONLY p: Point.T): Point.T RAISES {} =
  VAR res: Point.T;
  BEGIN
    &lt;* ASSERT r.east &gt; r.west *&gt;
    res.h := MAX (MIN (p.h, r.east - 1), r.west);
    res.v := MAX (MIN (p.v, r.south - 1), r.north);
    RETURN res
  END Project;

PROCEDURE <A NAME="Add"><procedure>Add</procedure></A> (READONLY r: T; READONLY p: Point.T): T RAISES {} =
  VAR s: T;
  BEGIN
    IF r.west &gt;= r.east THEN RETURN Empty END;
    s.west := r.west + p.h;
    s.east := r.east + p.h;
    s.north := r.north + p.v;
    s.south := r.south + p.v;
    RETURN s;
  END Add;

PROCEDURE <A NAME="Sub"><procedure>Sub</procedure></A> (READONLY r: T; READONLY p: Point.T): T RAISES {} =
  VAR s: T;
  BEGIN
    IF r.west &gt;= r.east THEN RETURN Empty END;
    s.west := r.west - p.h;
    s.east := r.east - p.h;
    s.north := r.north - p.v;
    s.south := r.south - p.v;
    RETURN s;
  END Sub;

PROCEDURE <A NAME="Move"><procedure>Move</procedure></A> (READONLY r: T; READONLY p: Point.T): T RAISES {} =
  VAR s: T;
  BEGIN
    IF r.west &gt;= r.east THEN RETURN Empty END;
    s.west := r.west + p.h;
    s.east := r.east + p.h;
    s.north := r.north + p.v;
    s.south := r.south + p.v;
    RETURN s;
  END Move;

PROCEDURE <A NAME="MoveH"><procedure>MoveH</procedure></A> (READONLY r: T; h: INTEGER): T RAISES {} =
  VAR s: T;
  BEGIN
    IF r.west &gt;= r.east THEN RETURN Empty END;
    s.west := r.west + h;
    s.east := r.east + h;
    s.north := r.north;
    s.south := r.south;
    RETURN s;
  END MoveH;

PROCEDURE <A NAME="MoveV"><procedure>MoveV</procedure></A> (READONLY r: T; v: INTEGER): T RAISES {} =
  VAR s: T;
  BEGIN
    IF r.west &gt;= r.east THEN RETURN Empty END;
    s.west := r.west;
    s.east := r.east;
    s.north := r.north + v;
    s.south := r.south + v;
    RETURN s;
  END MoveV;

PROCEDURE <A NAME="MoveHV"><procedure>MoveHV</procedure></A> (READONLY r: T; h: INTEGER; v: INTEGER): T RAISES {} =
  VAR s: T;
  BEGIN
    IF r.west &gt;= r.east THEN RETURN Empty END;
    s.west := r.west + h;
    s.east := r.east + h;
    s.north := r.north + v;
    s.south := r.south + v;
    RETURN s;
  END MoveHV;

PROCEDURE <A NAME="Scale"><procedure>Scale</procedure></A> (READONLY r: T; num, den: INTEGER): T RAISES {} =
  VAR s: T;
  BEGIN
    IF r.west &gt;= r.east THEN RETURN Empty END;
    s.north := (r.north * num) DIV den;
    s.south := (r.south * num) DIV den;
    IF s.north &gt;= s.south THEN
      RETURN Empty
    ELSE
      s.west := (r.west * num) DIV den;
      s.east := (r.east * num) DIV den;
      IF s.west &gt;= s.east THEN RETURN Empty END;
      RETURN s
    END;
  END Scale;

PROCEDURE <A NAME="Inset"><procedure>Inset</procedure></A> (READONLY r: T; n: INTEGER): T RAISES {} =
  VAR s: T;
  BEGIN
    IF (r.west &gt;= r.east) OR (r.north &gt;= r.south) THEN RETURN Empty END;
    s.west := r.west + n;
    s.east := r.east - n;
    s.north := r.north + n;
    s.south := r.south - n;
    IF (s.west &gt;= s.east) OR (s.north &gt;= s.south) THEN RETURN Empty;  END;
    RETURN s;
  END Inset;

PROCEDURE <A NAME="Change"><procedure>Change</procedure></A> (READONLY r: T; dw, de, dn, ds: INTEGER): T RAISES {} =
  VAR s: T;
  BEGIN
    IF (r.west &gt;= r.east) OR (r.north &gt;= r.south) THEN RETURN Empty;  END;
    s.west := r.west + dw;
    s.east := r.east + de;
    s.north := r.north + dn;
    s.south := r.south + ds;
    IF (s.west &gt;= s.east) OR (s.north &gt;= s.south) THEN RETURN Empty;  END;
    RETURN s;
  END Change;

PROCEDURE <A NAME="MoveEdge"><procedure>MoveEdge</procedure></A> (READONLY r: T; e: Edge; dn: INTEGER): T RAISES {} =
  VAR s: T;
  BEGIN
    IF r.west &gt;= r.east THEN RETURN Empty END;
    s := r;
    CASE e OF
      | Edge.W =&gt; s.west := r.west + dn;
      | Edge.E =&gt; s.east := r.east + dn;
      | Edge.N =&gt; s.north := r.north + dn;
      | Edge.S =&gt; s.south := r.south + dn;
    END;
    IF (s.west &gt;= s.east) OR (s.north &gt;= s.south) THEN RETURN Empty;  END;
    RETURN s;
  END MoveEdge;

PROCEDURE <A NAME="MoveVertex"><procedure>MoveVertex</procedure></A> (READONLY r: T; v: Vertex; READONLY dp: Point.T): T
  RAISES {} =
  VAR s: T;
  BEGIN
    IF r.west &gt;= r.east THEN RETURN Empty END;
    s := r;
    CASE v OF
    | Vertex.NW =&gt; s.west := r.west + dp.h; s.north := r.north + dp.v;
    | Vertex.NE =&gt; s.east := r.east + dp.h; s.north := r.north + dp.v;
    | Vertex.SW =&gt; s.west := r.west + dp.h; s.south := r.south + dp.v;
    | Vertex.SE =&gt; s.east := r.east + dp.h; s.south := r.south + dp.v;
    END;
    IF (s.west &gt;= s.east) OR (s.north &gt;= s.south) THEN RETURN Empty;  END;
    RETURN s;
  END MoveVertex;

PROCEDURE <A NAME="Stretch"><procedure>Stretch</procedure></A> (READONLY r: T; axis: Axis.T; lo, hi: INTEGER): T RAISES {} =
  VAR res: T;
  BEGIN
    IF (r.west &gt;= r.east) OR lo &gt;= hi THEN RETURN Empty;  END;
    IF axis = Axis.T.Hor THEN
      res.north := r.north;
      res.south := r.south;
      res.west := lo;
      res.east := hi
    ELSE
      res.north := lo;
      res.south := hi;
      res.west := r.west;
      res.east := r.east
    END;
    RETURN res
  END Stretch;

PROCEDURE <A NAME="Join"><procedure>Join</procedure></A> (READONLY r, s: T): T RAISES {} =
  VAR t: T;
  BEGIN
    IF (r.west &gt;= r.east)(* OR (r.north&gt;=r.south) *)  THEN RETURN s;  END;
    IF (s.west &gt;= s.east)(* OR (s.north&gt;=s.south) *)  THEN RETURN r;  END;
    t.west := MIN (r.west, s.west);
    t.east := MAX (r.east, s.east);
    t.north := MIN (r.north, s.north);
    t.south := MAX (r.south, s.south);
    RETURN t;
  END Join;

PROCEDURE <A NAME="Meet"><procedure>Meet</procedure></A> (READONLY r, s: T): T RAISES {} =
  VAR t: T;
  BEGIN
    t.west := MAX (r.west, s.west);
    t.east := MIN (r.east, s.east);
    IF t.west &gt;= t.east THEN RETURN Empty END;
    t.north := MAX (r.north, s.north);
    t.south := MIN (r.south, s.south);
    IF t.north &gt;= t.south THEN RETURN Empty;  END;
    RETURN t;
  END Meet;

PROCEDURE <A NAME="Extend"><procedure>Extend</procedure></A> (READONLY r: T; READONLY p: Point.T): T RAISES {} =
  BEGIN
    RETURN Join (r, FromPoint (p));
  END Extend;

PROCEDURE <A NAME="Chop"><procedure>Chop</procedure></A>
  (hv: Axis.T; READONLY r: T; n: INTEGER; VAR s, t: T) RAISES {} =
  BEGIN
    IF (hv = Axis.T.Hor) THEN
      IF n &lt;= r.west THEN
        s := Empty;
        t := r
      ELSIF n &gt;= r.east THEN
        s := r;
        t := Empty
      ELSE
        s.north := r.north;
        s.south := r.south;
        t.north := r.north;
        t.south := r.south;
        s.west := r.west;
        s.east := n;
        t.west := n;
        t.east := r.east
      END
    ELSE
      IF n &lt;= r.north THEN
        s := Empty;
        t := r
      ELSIF n &gt;= r.south THEN
        s := r;
        t := Empty
      ELSE
        s.west := r.west;
        s.east := r.east;
        t.west := r.west;
        t.east := r.east;
        s.north := r.north;
        s.south := n;
        t.north := n;
        t.south := r.south
      END
    END
  END Chop;
</PRE> This is what it really means:
     PROCEDURE Factor(VAR IN r, by: T; VAR f: Partition; dh, dv: INTEGER)
     RAISES {}; VAR northIndex, westIndex: INTEGER; mid, temp: T; BEGIN IF dh &gt;
     0 THEN westIndex := 3 ELSE westIndex := 1 END; IF dv &gt; 0 THEN northIndex
     := 4 ELSE northIndex := 0 END; Chop(Axis.Ver, r, by.north, f[northIndex],
     temp); Chop(Axis.Ver, temp, by.south, mid, f[4 - northIndex]);
     Chop(Axis.Hor, mid, by.west, f[westIndex], temp); Chop(Axis.Hor, temp,
     by.east, f[2], f[4 - westIndex]); END Factor;
 

<P><PRE>PROCEDURE <A NAME="Factor"><procedure>Factor</procedure></A> (READONLY r, by: T;  VAR f: Partition;  dh, dv: INTEGER)
  RAISES {} =
  VAR ix, rw, re, rn, rs, bw, be, bn, bs: INTEGER; temp: T;
  BEGIN
    bw := by.west;
    be := by.east;
    bn := by.north;
    bs := by.south;
    rw := r.west;
    re := r.east;
    rn := r.north;
    rs := r.south;
    IF bw &gt;= be OR rw &gt;= re THEN
      f[0] := r;
      FOR z := 1 TO 4 DO f[z] := Empty END;
      RETURN
    END;
    IF dv &gt; 0 THEN ix := 4 ELSE ix := 0 END;
    IF rn &lt; bn THEN
      WITH z = f[ix] DO z.west := rw; z.east := re; z.north := rn END;
      IF bn &lt; rs THEN
        f[ix].south := bn;
        WITH z = temp DO z.west := rw; z.east := re; z.north := bn END;
        IF bs &lt; rs THEN
          temp.south := bs;
          WITH z = f[4 - ix] DO
            z.west := rw;
            z.east := re;
            z.north := bs;
            z.south := rs
          END
        ELSE
          temp.south := rs;
          f[4 - ix] := Empty
        END
      ELSE
        f[ix].south := rs;
        temp := Empty;
        f[4 - ix] := Empty
      END
    ELSE
      f[ix] := Empty;
      IF rn &lt; bs THEN
        WITH z = temp DO z.west := rw; z.east := re; z.north := rn END;
        IF bs &lt; rs THEN
          temp.south := bs;
          WITH z = f[4 - ix] DO
            z.west := rw;
            z.east := re;
            z.north := bs;
            z.south := rs
          END
        ELSE
          temp.south := rs;
          f[4 - ix] := Empty
        END
      ELSE
        temp := Empty;
        f[4 - ix] := r
      END
    END;
    rw := temp.west;
    re := temp.east;
    rn := temp.north;
    rs := temp.south;
    IF rw &gt;= re THEN
      FOR z := 1 TO 3 DO f[z] := Empty END;
      RETURN
    END;
    IF dh &gt; 0 THEN ix := 3 ELSE ix := 1 END;
    IF rw &lt; bw THEN
      WITH z = f[ix] DO z.north := rn; z.south := rs; z.west := rw END;
      IF bw &lt; re THEN
        f[ix].east := bw;
        WITH z = f[2] DO z.north := rn; z.south := rs; z.west := bw END;
        IF be &lt; re THEN
          f[2].east := be;
          WITH z = f[4 - ix] DO
            z.north := rn;
            z.south := rs;
            z.west := be;
            z.east := re
          END
        ELSE
          f[2].east := re;
          f[4 - ix] := Empty
        END
      ELSE
        f[ix].east := re;
        f[2] := Empty;
        f[4 - ix] := Empty
      END
    ELSE
      f[ix] := Empty;
      IF rw &lt; be THEN
        WITH z = f[2] DO z.north := rn; z.south := rs; z.west := rw END;
        IF be &lt; re THEN
          f[2].east := be;
          WITH z = f[4 - ix] DO
            z.north := rn;
            z.south := rs;
            z.west := be;
            z.east := re
          END
        ELSE
          f[2].east := re;
          f[4 - ix] := Empty
        END
      ELSE
        f[2] := Empty;
        f[4 - ix] := temp
      END
    END
  END Factor;

PROCEDURE <A NAME="Mod"><procedure>Mod</procedure></A> (READONLY p: Point.T; READONLY r: T): Point.T RAISES {} =
  VAR q: Point.T; hor, ver: Interval.T;
  BEGIN
    &lt;* ASSERT r.west &lt; r.east *&gt;
    hor.lo := r.west;
    hor.hi := r.east;
    ver.lo := r.north;
    ver.hi := r.south;
    q.h := Interval.Mod (p.h, hor);
    q.v := Interval.Mod (p.v, ver);
    RETURN q
  END Mod;

PROCEDURE <A NAME="Equal"><procedure>Equal</procedure></A> (READONLY r, s: T): BOOLEAN RAISES {} =
  BEGIN
    RETURN r = s
  END Equal;

PROCEDURE <A NAME="IsEmpty"><procedure>IsEmpty</procedure></A> (READONLY r: T): BOOLEAN RAISES {} =
  BEGIN RETURN (r.west &gt;= r.east) END IsEmpty;

PROCEDURE <A NAME="Member"><procedure>Member</procedure></A> (READONLY p: Point.T; READONLY r: T): BOOLEAN RAISES {} =
  BEGIN
    RETURN (r.west &lt;= p.h) AND (p.h &lt; r.east) AND (r.north &lt;= p.v)
    AND (p.v &lt; r.south);
  END Member;

PROCEDURE <A NAME="Overlap"><procedure>Overlap</procedure></A> (READONLY r, s: T): BOOLEAN RAISES {} =
  BEGIN
    RETURN (MAX (r.west, s.west) &lt; MIN (r.east, s.east))
    AND (MAX (r.north, s.north) &lt; MIN (r.south, s.south));
  END Overlap;

PROCEDURE <A NAME="Subset"><procedure>Subset</procedure></A> (READONLY r, s: T): BOOLEAN RAISES {} =
  BEGIN
    RETURN (r.west &gt;= r.east)
    OR ((r.west &gt;= s.west) AND (r.east &lt;= s.east) AND (r.north &gt;= s.north)
        AND (r.south &lt;= s.south));
  END Subset;

PROCEDURE <A NAME="Congruent"><procedure>Congruent</procedure></A>(READONLY r, s: T): BOOLEAN =
  BEGIN
    RETURN r.east - r.west = s.east - s.west
    AND  r.south - r.north = s.south - s.north
  END Congruent;

PROCEDURE <A NAME="Transpose"><procedure>Transpose</procedure></A>(READONLY r: T; ax := Axis.T.Ver): T =
  BEGIN
    IF ax = Axis.T.Hor THEN
      RETURN r
    ELSE
      RETURN T{r.north,r.south,r.west,r.east}
    END
  END Transpose;

PROCEDURE <A NAME="GlobToLoc"><procedure>GlobToLoc</procedure></A> (READONLY r: T; READONLY p: Point.T): Point.T RAISES {} =
  VAR q: Point.T;
  BEGIN
    q.h := p.h - r.west;
    q.v := p.v - r.north;
    RETURN q;
  END GlobToLoc;

PROCEDURE <A NAME="LocToGlob"><procedure>LocToGlob</procedure></A> (READONLY r: T; READONLY p: Point.T): Point.T RAISES {} =
  VAR q: Point.T;
  BEGIN
    q.h := p.h + r.west;
    q.v := p.v + r.north;
    RETURN q;
  END LocToGlob;

PROCEDURE <A NAME="Compare"><procedure>Compare</procedure></A> (READONLY a, b: T): INTEGER =
  BEGIN
    IF (a.west &lt; b.west) THEN RETURN  -1 END;
    IF (a.west &gt; b.west) THEN RETURN  +1 END;
    IF (a.east &lt; b.east) THEN RETURN  -1 END;
    IF (a.east &gt; b.east) THEN RETURN  +1 END;
    IF (a.north &lt; b.north) THEN RETURN  -1 END;
    IF (a.north &gt; b.north) THEN RETURN  +1 END;
    IF (a.south &lt; b.south) THEN RETURN  -1 END;
    IF (a.south &gt; b.south) THEN RETURN  +1 END;
    RETURN 0;
  END Compare;

PROCEDURE <A NAME="Hash"><procedure>Hash</procedure></A> (READONLY a: T): Word.T =
  BEGIN
    RETURN Word.Xor (Word.Xor (a.west, a.east), Word.Xor (a.north, a.south));
  END Hash;

BEGIN
END Rect.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
