<HTML>
<HEAD>
<TITLE>SRC Modula-3: geometry/src/Region.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>geometry/src/Region.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;*PRAGMA LL*&gt;
</PRE> A <CODE>Region.T</CODE> represents a set of integer lattice points.   

<P><PRE>INTERFACE <interface><A HREF="Region.m3">Region</A></interface>;

IMPORT <A HREF="Rect.i3">Rect</A>, <A HREF="Point.i3">Point</A>, <A HREF="Axis.i3">Axis</A>;

TYPE
  T = RECORD r: Rect.T; p: P := NIL END;

  <A HREF="RegionRep.i3#P">P</A> &lt;: REFANY;
</PRE> If <CODE>rg</CODE> is a region, then <CODE>rg.r</CODE> is the smallest rectangle 
   containing all points in <CODE>rg</CODE>, and <CODE>rg.p</CODE> is the private 
   representation of the region as a sorted array of disjoint 
   rectangles.  

<P><PRE>CONST
  Empty = T{Rect.Empty, NIL};
  Full = T{Rect.Full, NIL};

PROCEDURE <A HREF="Region.m3#FromRect">FromRect</A>(READONLY r: Rect.T): T;
</PRE><BLOCKQUOTE><EM> Return the region containing the same points as <CODE>r</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Region.m3#FromRects">FromRects</A>(READONLY ra: ARRAY OF Rect.T): T;
</PRE><BLOCKQUOTE><EM> Return the region containing all points in any rectangle of <CODE>ra</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Region.m3#ToRects">ToRects</A>(READONLY rg: T): REF ARRAY OF Rect.T;
</PRE><BLOCKQUOTE><EM> Returns a list of disjoint rectangles that partition <CODE>rg</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> The call <CODE>ToRects(Empty)</CODE> produces an array of length zero. 

<P><PRE>PROCEDURE <A HREF="Region.m3#FromPoint">FromPoint</A>(READONLY p: Point.T): T;
</PRE><BLOCKQUOTE><EM> Return the region containing exactly the point <CODE>p</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Region.m3#BoundingBox">BoundingBox</A>(READONLY rg: T): Rect.T;
</PRE><BLOCKQUOTE><EM> Return the smallest rectangle containing all the points of <CODE>rg</CODE>;
   this is equivalent to <CODE>rg.r</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Region.m3#Add">Add</A>(READONLY rg: T; READONLY p: Point.T): T;
</PRE><BLOCKQUOTE><EM> Return the translation of <CODE>rg</CODE> by <CODE>p</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> That is, <CODE>Add(rg, p)</CODE> contains <CODE>pt</CODE> if and only if <CODE>rg</CODE> contains
   <CODE>Point.Sub(pt, p)</CODE>.  
   
<P><PRE>PROCEDURE <A HREF="Region.m3#Sub">Sub</A>(READONLY rg: T; READONLY p: Point.T): T;
</PRE><BLOCKQUOTE><EM> Return <CODE>Add(rg, Point.Minus(p))</CODE>.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Region.m3#AddHV">AddHV</A>(READONLY rg: T; dh, dv: INTEGER): T;
</PRE><BLOCKQUOTE><EM> Return <CODE>Add(rg, Point.T{dh,dv})</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Region.m3#Inset">Inset</A>(READONLY rg: T; n: INTEGER): T;
</PRE><BLOCKQUOTE><EM> Return the region inset into <CODE>rg</CODE> by <CODE>n</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> That is, if <CODE>n</CODE> is non-negative, <CODE>Inset(rg, n)</CODE> contains a point
   <CODE>pt</CODE> if all points within distance <CODE>n</CODE> of <CODE>pt</CODE> are contained in <CODE>rg</CODE>.
   If <CODE>n</CODE> is non-positive, <CODE>Inset(rg, n)</CODE> contains a point <CODE>pt</CODE> if some
   point within distance <CODE>-n</CODE> of <CODE>pt</CODE> is in <CODE>rg</CODE>.  For the purposes
   of this definition, points <CODE>p</CODE> and <CODE>q</CODE> are ``within distance <CODE>n</CODE>''
   if both <CODE>ABS(p.h-q.h)</CODE> and <CODE>ABS(p.v-q.v)</CODE> are at most <CODE>n</CODE>.  (If <CODE>n</CODE>
   is zero, both definitions give <CODE>Inset(rg, n) = rg</CODE>.)  
    
<P><PRE>PROCEDURE <A HREF="Region.m3#PlaceAxis">PlaceAxis</A>(READONLY rg: T;
  n: INTEGER; hv: Axis.T): T;
</PRE><BLOCKQUOTE><EM> Return the retraction of <CODE>rg</CODE> by <CODE>n</CODE> along the <CODE>hv</CODE> axis. </EM></BLOCKQUOTE><PRE>
</PRE> That is, let <CODE>rect</CODE> equal <CODE>Rect.FromSize(1, ABS(n))</CODE> if <CODE>hv</CODE> is <CODE>Axis.T.Ver</CODE>
   or <CODE>rect.FromSize(1, ABS(n))</CODE> if <CODE>hv</CODE> is <CODE>Axis.T.Hor</CODE>.  If <CODE>n</CODE> is
   non-negative, then <CODE>PlaceAxis(rg, n, hv)</CODE> contains a point <CODE>pt</CODE> if
   the rectangle <CODE>Rect.Add(pt, rect)</CODE> is contained in <CODE>rg</CODE>.  If <CODE>n</CODE>
   is negative, then <CODE>PlaceAxis(rg, n, hv)</CODE> contains a point <CODE>pt</CODE> if
   <CODE>Rect.Add(pt, rect)</CODE> contains some point in <CODE>rg</CODE>.  

<P><PRE>PROCEDURE <A HREF="Region.m3#Place">Place</A>(READONLY rg: T; h, v: INTEGER): T;
</PRE><BLOCKQUOTE><EM> Return the retraction of <CODE>rg</CODE> by <CODE>h</CODE> along the horizontal
   axis and by <CODE>v</CODE> along the vertical axis. </EM></BLOCKQUOTE><PRE>
</PRE> More precisely, <CODE>Place(rg, h, v)</CODE> is defined by the expression
<P>
<PRE>
      PlaceAxis(PlaceAxis(rg, h, Axis.Hor), v, Axis.Ver) . 
</PRE>


<P><PRE>PROCEDURE <A HREF="Region.m3#Join">Join</A>(READONLY rg, rgP: T): T;
</PRE><BLOCKQUOTE><EM> Return the union of the points in <CODE>rg</CODE> and <CODE>rgP</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Region.m3#JoinRect">JoinRect</A>(READONLY r: Rect.T;
  READONLY rg: T): T;
</PRE><BLOCKQUOTE><EM> Return the union of the points in <CODE>r</CODE> and <CODE>rg</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Region.m3#JoinRegions">JoinRegions</A>(READONLY rg: REF ARRAY OF T): T;
</PRE><BLOCKQUOTE><EM> Return the union of all the regions in <CODE>rg</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Region.m3#Meet">Meet</A>(READONLY rg, rgP: T): T;
</PRE><BLOCKQUOTE><EM> Return the intersection of <CODE>rg</CODE> and <CODE>rgP</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Region.m3#MeetRect">MeetRect</A>(READONLY r: Rect.T;
  READONLY rg: T): T;
</PRE><BLOCKQUOTE><EM> Return the intersection of the points in <CODE>r</CODE> and <CODE>rg</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Region.m3#Difference">Difference</A>(READONLY rg, rgP: T): T;
</PRE><BLOCKQUOTE><EM> Return the set of points in <CODE>rg</CODE> and not in <CODE>rgP</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Region.m3#SymmetricDifference">SymmetricDifference</A>(READONLY rg, rgP: T): T;
</PRE><BLOCKQUOTE><EM> Return the set of points in exactly one of <CODE>rg</CODE> and <CODE>rgP</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Region.m3#MaxSubset">MaxSubset</A>(READONLY r: Rect.T;
  READONLY rg: T): Rect.T;
</PRE><BLOCKQUOTE><EM> Return a large rectangular subset of <CODE>rg</CODE> containing <CODE>r</CODE>,
   or return <CODE>Empty</CODE> if <CODE>r</CODE> is not a subset of <CODE>rg</CODE>.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Region.m3#Flip">Flip</A>(READONLY rg: T; hor, ver: BOOLEAN): T;
</PRE><BLOCKQUOTE><EM> Return the region which flips <CODE>rg</CODE> about the horizontal and
   vertical axes, depending on whether <CODE>hor</CODE> and <CODE>ver</CODE> are <CODE>TRUE</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> More precisely, let <CODE>H = -1</CODE> if <CODE>hor</CODE> is <CODE>TRUE</CODE>, and <CODE>+1</CODE> otherwise,
   and similarly for <CODE>V</CODE>.  Then a point <CODE>(h,v)</CODE> is in the flipped region
   iff <CODE>(H*h, V*v)</CODE> is in <CODE>rg</CODE>. 

<P><PRE>PROCEDURE <A HREF="Region.m3#Equal">Equal</A>(READONLY rg, rgP: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return whether <CODE>rg</CODE> and <CODE>rgP</CODE> contain the same points. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Region.m3#IsEmpty">IsEmpty</A>(READONLY rg: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return whether <CODE>rg</CODE> is empty. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Region.m3#IsRect">IsRect</A>(READONLY rg: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return whether <CODE>rg</CODE> is a rectangle, that is, whether
   it contains all the points in its bounding box. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Region.m3#Member">Member</A>(READONLY p: Point.T;
  READONLY rg: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return whether <CODE>p</CODE> is in <CODE>rg</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Region.m3#SubsetRect">SubsetRect</A>(READONLY r: Rect.T;
  READONLY rg: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return whether <CODE>r</CODE> is contained in <CODE>rg</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Region.m3#Subset">Subset</A>(READONLY rg, rgP: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return whether <CODE>rg</CODE> is contained in <CODE>rgP</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Region.m3#OverlapRect">OverlapRect</A>(READONLY r: Rect.T;
  READONLY rg: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return whether <CODE>r</CODE> and <CODE>rg</CODE> have any point in common. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Region.m3#Overlap">Overlap</A>(READONLY rg, rgP: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return whether <CODE>rg</CODE> and <CODE>rgP</CODE> have any point in common. </EM></BLOCKQUOTE><PRE>

END Region.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
