<HTML>
<HEAD>
<TITLE>SRC Modula-3: geometry/src/Transform.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>geometry/src/Transform.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="Transform.m3">Transform</A></interface>;
</PRE><BLOCKQUOTE><EM> Creating and manipulating 2-dimensional transformations
   This interface with 2 dimensional transformations. See Newman and Sproull,
   Chapter 4, for more information.
   Index: matrices, transformations ; transformations </EM></BLOCKQUOTE><PRE>

IMPORT <A HREF="Point.i3">Point</A>;
</PRE><BLOCKQUOTE><EM> If X is of type T then X represents the matrix
<PRE>
      
        [ a11  a12  0 ]
        [ a21  a22  0 ]
        [ a31  a32  1 ]
      
   </PRE>
Points in the (h,v) coordinate system (e.g., those represented by
   Point.T's) are interpreted as (h,v)==(h, v, 1). An application of X to a
   point (h,v) consists of a single post-multiplication:
<PRE>
      
       (h, v, 1) [ a11  a12  0 ]      (H, V, 1)
                 [ a21  a22  0 ]  =
                 [ a31  a32  1 ]
      
   </PRE>
The values (H,V) are the transformed points. The transformation matrices
   have REAL elements however they operate on, and produce, integer elements.
   This is done as follows, shown for the H element above:
<PRE>
      
           H := TRUNC(FLOAT(h)*a11 + FLOAT(v)*a21 + a31 + 0.5)
      
   </PRE>
The leading 2 by 2 submatrix of X is the usual rotation/scaling matrix
   while the a31 and a32 elements provide translation. Composition is
   performed by pre-multiplication, i.e., A composed with B is AB </EM></BLOCKQUOTE><PRE>

TYPE
  T = RECORD a11, a12, a21, a22, a31, a32: REAL END;

PROCEDURE <A HREF="Transform.m3#Identity">Identity</A> (): T;
</PRE><BLOCKQUOTE><EM> Returns the identity transformation.  Use this to get new transformations </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Transform.m3#Apply">Apply</A> (tr: T; p: Point.T): Point.T;
</PRE><BLOCKQUOTE><EM> Returns the result of applying the transformation <CODE>tr</CODE> to the point <CODE>p</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Transform.m3#Translate">Translate</A> (h, v: REAL; READONLY tr: T): T;
</PRE><BLOCKQUOTE><EM> Returns the transformation that is the composition of the input
   transformation and the translation (h,v) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Transform.m3#Rotate">Rotate</A> (theta: REAL; READONLY tr: T): T;
</PRE><BLOCKQUOTE><EM> Returns the transformation that is the composition of the input
   transformation and the rotation by `theta' radians </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Transform.m3#Scale">Scale</A> (fh, fv: REAL; READONLY tr: T): T;
</PRE><BLOCKQUOTE><EM> Returns the transformation that is the composition of the input
   transformation and the scaling of the h axis by fh and the v axis by fv.
   Hence, the scaling is anisotropic if fh#fv </EM></BLOCKQUOTE><PRE>
</PRE> Here are a few convenience procedures 

<P><PRE>PROCEDURE <A HREF="Transform.m3#FromPoint">FromPoint</A> (READONLY p: Point.T): T;
</PRE><BLOCKQUOTE><EM> Returns a translation transformation </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Transform.m3#Compose">Compose</A> (READONLY t1, t2: T): T;
</PRE><BLOCKQUOTE><EM> Composes t1 and t2, result is t1*t2. Note that this means that t1 will be
   applied first by, e.g., Apply above. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Transform.m3#RotateAbout">RotateAbout</A> (READONLY p: Point.T; theta: REAL): T;
</PRE><BLOCKQUOTE><EM> Returns the transformation that rotates <CODE>theta</CODE> radians about the point
   <CODE>p</CODE>. This is equivalent to the composition of three transformations:
   translate to origin, rotate theta, translate back to p </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Transform.m3#IsoScale">IsoScale</A> (f: REAL): T;
</PRE><BLOCKQUOTE><EM> Returns a transformation that scales each axis by f </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Transform.m3#AnIsoScale">AnIsoScale</A> (fh, fv: REAL): T;
</PRE><BLOCKQUOTE><EM> See Scale </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Transform.m3#Compare">Compare</A> (READONLY a, b: T): [-1 .. 1];
</PRE><BLOCKQUOTE><EM> == RETURN (-1 if a.h &lt; b.h) OR ((a.h = b.h) AND (a.v &lt; b.v)), 0 if a =
   b, +1 o.  w.) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Transform.m3#Equal">Equal</A> (READONLY a, b: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> == RETURN (a = b) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Transform.m3#Hash">Hash</A> (READONLY a: T): INTEGER;
</PRE><BLOCKQUOTE><EM> == RETURN a suitable hash value  </EM></BLOCKQUOTE><PRE>

END Transform.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
