<HTML>
<HEAD>
<TITLE>SRC Modula-3: geometry/src/Trapezoid.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>geometry/src/Trapezoid.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Trapezoid.def, coded July 87 by Scott Seligman 
<PRE>&lt;*PRAGMA LL*&gt;
</PRE> A <CODE>Trapezoid.T</CODE> represents a set of points lying in a quadrilateral
   whose north and south edges are horizontal and whose west and east
   edges have arbitrary non-horizontal slopes.  For example, a diagonal 
   line can be represented as a tall skinny trapezoid.  

<P><PRE>INTERFACE <interface><A HREF="Trapezoid.m3">Trapezoid</A></interface>;

IMPORT <A HREF="Point.i3">Point</A>;

TYPE
  T = RECORD
    vlo, vhi: INTEGER;
    m1, m2: Rational;
    p1, p2: Point.T;
  END;
  Rational = RECORD n, d: INTEGER END;
</PRE> For a trapezoid <CODE>tr</CODE>, 
<P>
\medskip\bulletitem <CODE>tr.vlo</CODE> and <CODE>tr.vhi</CODE> are the <CODE>v</CODE> coordinates of its north and south edges, respectively;
<P>
\medskip\bulletitem <CODE>tr.m1</CODE> and <CODE>tr.m2</CODE> are the slopes of its west and east edges, respectively, as <CODE>(delta v) / (delta h)</CODE>. A denominator
of zero represents an infinite slope; i.e., a vertical
edge. A numerator of zero is illegal. 
<P>
\medskip\bulletitem <CODE>tr.p1</CODE> and <CODE>tr.p2</CODE> are points on the infinite lines
that extend the west and east edges, respectively.  
<P>
\medskip
Trapezoids are closed on the north and west edges, open on the
south and east edges, closed on the northwest corner, and open on
the other corners. 
<P>
A <CODE>Rational</CODE> <CODE>q</CODE> represents the rational number <CODE>q.n/q.d</CODE>. 

<P>
<P><PRE>PROCEDURE <A HREF="Trapezoid.m3#FromEdges">FromEdges</A> (y1, p1, q1: INTEGER;
                     y2, p2, q2: INTEGER): T;
</PRE><BLOCKQUOTE><EM> Return a trapezoid whose vertices are <CODE>(p1, y1)</CODE>, <CODE>(q1, y1)</CODE>,
   <CODE>(p2, y2)</CODE>, and <CODE>(q2, y2)</CODE>. The altitude of the trapezoid must be
   non-zero. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Trapezoid.m3#FromVertices">FromVertices</A> (READONLY p1, p2, q1, q2: Point.T): T;
</PRE><BLOCKQUOTE><EM> Return a trapezoid from four vertices. The <CODE>p1</CODE> and <CODE>p2</CODE> vertices
   must have the same y-coordinates, as must the <CODE>q1</CODE> and <CODE>q2</CODE> vertices. 
   Furthermore, the altitude of the trapezoid must be non-zero. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Trapezoid.m3#FromTriangle">FromTriangle</A> (READONLY a, b, c: Point.T): T;
</PRE><BLOCKQUOTE><EM> Return a trapezoid from the vertices of a triangle. One of the sides of
   the triangle must be parallel to the x-axis, and the triangle's altitude
   must be non-zero. </EM></BLOCKQUOTE><PRE>

END Trapezoid.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
