<HTML>
<HEAD>
<TITLE>SRC Modula-3: geometry/src/Trapezoid.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>geometry/src/Trapezoid.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Marc H. Brown                                            

<P><PRE>MODULE <module><implements><A HREF="Trapezoid.i3">Trapezoid</A></implements></module>;

IMPORT <A HREF="Point.i3">Point</A>;

PROCEDURE <A NAME="FromEdges"><procedure>FromEdges</procedure></A> (y1, p1, q1: INTEGER;
                     y2, p2, q2: INTEGER): T =
  VAR
    t: T;
    west1 := MIN(p1, q1);
    east1 := MAX(p1, q1);
    west2 := MIN(p2, q2);
    east2 := MAX(p2, q2);
  BEGIN
    t.vlo := MIN(y1, y2);
    t.vhi := MAX(y1, y2);
    t.m1.n := y1 - y2;
    t.m1.d := west1 - west2;
    t.p1 := Point.FromCoords(west1, y1);
    t.m2.n := y1 - y2;
    t.m2.d := east1 - east2;
    t.p2 := Point.FromCoords(east1, y1);
    RETURN t;
  END FromEdges;

PROCEDURE <A NAME="FromVertices"><procedure>FromVertices</procedure></A> (READONLY p1, p2, q1, q2: Point.T): T =
  BEGIN
    RETURN FromEdges(p1.v, p1.h, p2.h, q1.v, q1.h, q2.h);
  END FromVertices;

PROCEDURE <A NAME="FromTriangle"><procedure>FromTriangle</procedure></A> (READONLY a, b, c: Point.T): T =
  BEGIN
    IF a.v = b.v THEN
      RETURN FromVertices(a, b, c, c)
    ELSIF a.v = c.v THEN
      RETURN FromVertices(a, c, b, b)
    ELSE
      RETURN FromVertices(b, c, a, a)
    END;
  END FromTriangle;

BEGIN
END Trapezoid.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
