<HTML>
<HEAD>
<TITLE>SRC Modula-3: jvideo/src/JVBuffer.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>jvideo/src/JVBuffer.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> shared memory buffers for use with JVideo stuff. 

<P><PRE>INTERFACE <interface><A HREF="#x1">JVBuffer</A></interface>;

IMPORT <A HREF="../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../time/src/Common/Tick.i3">Tick</A>, <A HREF="#x2">Utime</A>;

TYPE Serial = CARDINAL;
</PRE> -- the T -- 

<P><PRE>TYPE
  <A HREF="#x3">T</A> &lt;: Public;
  Public =
    MUTEX OBJECT
      serial   : Serial                 := 0; (* id of frame *)
      timestamp: Utime.struct_timeval;
      localTime: Tick.T;
      (* time the previous stage in the pipeline finished processing *)
      length, frameLength: CARDINAL        := 0;
      shmid              : Ctypes.int := -1;
      addr               : ADDRESS         := NIL;
      ready              : ReadyClosure    := NIL; (* see note below *)
    METHODS
      init (shmid: Ctypes.int; address: ADDRESS): T
            RAISES {OSError.E};
      (* the &quot;shmid&quot; should have been attached to &quot;address&quot; before calling
         this method sets length from shmid *)
      free ();                   (* LL &lt; {t, t.pool} *)
      (* readers must call this when finished with the T *)
    END;
</PRE> -- Ready Closure --
<P>
   if the writer of a <CODE>T</CODE> assigns one of these it, then each reader must
   call its <CODE>apply()</CODE> method at some point or pass it on to the next stage
   in the pipeline to be called by another reader.  This is used to support
   flow control.  The endToEnd field should be set true if every stage that
   has a successor managed to get it to at least on successor.  

<P><PRE>TYPE
  ReadyClosure =
    MUTEX OBJECT endToEnd := FALSE; METHODS apply () RAISES {Thread.Alerted}; END;
</PRE> -- Factory -- used to create a buffer and free it
<P>
   this is a virtual type, it should be subclassed to provide an
   implementation.  It will be protected by the Pool lock whenever it is
   called 
<PRE>TYPE
  Factory =
    OBJECT
    METHODS
      make (): T RAISES {Thread.Alerted, OSError.E};
      (* create a brand new buffer *)
      reset (t: T);
      (* re-initialise the buffer, called when a buffer is reused *)
      destroy (t: T) RAISES {Thread.Alerted, OSError.E};
      (* destroy the buffer *)
    END;
</PRE> -- Buffer Pool -- holds a fixed number of buffers.
<P>
   A Pool has two types of clients: readers and writers.  A writer acquires
   a free buffer and fills it with data, then inserts it into the pool.  A
   reader can can get the most recent buffer, or wait until a new buffer is
   inserted.  Multiple readers can get hold of the most recent buffer which
   will be returned to the pool when all of them have freed it, so readers
   must free their buffers as soon as possible.
<P>
   Any storage held in a buffer pool will be freed if the pool is
   collected 

<P><PRE>EXCEPTION
  Closed;                        (* the writer has stopped.  The Pool is
                                    now useless until something is reset *)

TYPE
  <A HREF="#x4">Pool</A> &lt;: PoolPublic;
  PoolPublic =
    MUTEX OBJECT                 (* all methods are LL &lt; {self} *)
    METHODS
      (* administration methods *)
      init (factory: Factory; maxBuffers: CARDINAL): Pool
            RAISES {Thread.Alerted, OSError.E};
      (* set up the Pool to use &quot;factory&quot; to create new buffers.  The pool
         may hold up to &quot;maxBuffers&quot; buffers. *)

      setSize (maxBuffers: CARDINAL) RAISES {Thread.Alerted, OSError.E};
      (* set how many buffers may be held in the pool.  If more than
         &quot;maxBuffers&quot; buffers are already in the pool, the surplus will not
         be destroyed until they have been released by all clients *)

      (* methods for the buffer reader *)
      getCurrentBuffer (): T;
      (* just get the current buffer.  May return NIL.  Any buffer returned
         must be freed *)

      waitForChange (): T RAISES {Thread.Alerted, Closed};
      (* block the thread until the Pool releases a buffer containing a new
         frame.  The caller must call &quot;buffer.free()&quot; when it finished with
         it. *)

      (* methods for the buffer writer *)
      getFreeBuffer (wait := FALSE): T RAISES {Thread.Alerted, OSError.E};
      (* get a free buffer from the pool.  If &quot;wait&quot; = FALSE then return a
         free buffer if one is available or return NIL.  Otherwise, block
         thread until a buffer becomes free.  The returned buffer must
         either be inserted or freed *)

      insert (buffer: T);
      (* set &quot;buffer&quot; to be the current value in the Pool *)

      join  ();
      leave ();
      (* readers from the pool should call &quot;join&quot; when they are interested
         in receiving buffers and &quot;leave&quot; when they cease to be interested.
         The pool will not deliver free buffers to the writer (via
         &quot;getFreeBuffer&quot;) unless there is at least one reader.  It is a
         checked runtime error to call leave too many times, and wastes
         processor time to call it too few times *)

      signalClosed ();
      (* tell any readers that the writer has died. *)
      clearClosed ();
      (* clear the closed flag in the pool *)
    END;

END JVBuffer.
</PRE>
</inInterface>
<HR>
<A NAME="x1">JVBuffer's implementation  is in:
</A><UL>
<LI><A HREF="generic/JVBuffer.m3#0TOP0">jvideo/src/generic/JVBuffer.m3</A>
<LI><A HREF="osf1/JVBuffer.m3#0TOP0">jvideo/src/osf1/JVBuffer.m3</A>
<LI><A HREF="ultrix/JVBuffer.m3#0TOP0">jvideo/src/ultrix/JVBuffer.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface Utime is in:
</A><UL>
<LI><A HREF="../../unix/src/aix-3-2/Utime.i3#0TOP0">unix/src/aix-3-2/Utime.i3</A>
<LI><A HREF="../../unix/src/aix-ps2-1-2/Utime.i3#0TOP0">unix/src/aix-ps2-1-2/Utime.i3</A>
<LI><A HREF="../../unix/src/freebsd-1/Utime.i3#0TOP0">unix/src/freebsd-1/Utime.i3</A>
<LI><A HREF="../../unix/src/freebsd-2/Utime.i3#0TOP0">unix/src/freebsd-2/Utime.i3</A>
<LI><A HREF="../../unix/src/hpux-7-0/Utime.i3#0TOP0">unix/src/hpux-7-0/Utime.i3</A>
<LI><A HREF="../../unix/src/ibm-4-3/Utime.i3#0TOP0">unix/src/ibm-4-3/Utime.i3</A>
<LI><A HREF="../../unix/src/irix-5.2/Utime.i3#0TOP0">unix/src/irix-5.2/Utime.i3</A>
<LI><A HREF="../../unix/src/linux/Utime.i3#0TOP0">unix/src/linux/Utime.i3</A>
<LI><A HREF="../../unix/src/osf-1.ALPHA_OSF/Utime.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Utime.i3</A>
<LI><A HREF="../../unix/src/osf-1.DS3100/Utime.i3#0TOP0">unix/src/osf-1.DS3100/Utime.i3</A>
<LI><A HREF="../../unix/src/solaris-2-x/Utime.i3#0TOP0">unix/src/solaris-2-x/Utime.i3</A>
<LI><A HREF="../../unix/src/sunos-4-x/Utime.i3#0TOP0">unix/src/sunos-4-x/Utime.i3</A>
<LI><A HREF="../../unix/src/sysv-4.0/Utime.i3#0TOP0">unix/src/sysv-4.0/Utime.i3</A>
<LI><A HREF="../../unix/src/ultrix-3-1.generic/Utime.i3#0TOP0">unix/src/ultrix-3-1.generic/Utime.i3</A>
</UL>
<P>
<HR>
<A NAME="x3">opaque type JVBuffer.T is in:
</A><UL>
<LI><A HREF="generic/JVBuffer.m3#T">jvideo/src/generic/JVBuffer.m3</A>
<LI><A HREF="osf1/JVBuffer.m3#T">jvideo/src/osf1/JVBuffer.m3</A>
<LI><A HREF="ultrix/JVBuffer.m3#T">jvideo/src/ultrix/JVBuffer.m3</A>
</UL>
<P>
<HR>
<A NAME="x4">opaque type JVBuffer.Pool is in:
</A><UL>
<LI><A HREF="generic/JVBuffer.m3#Pool">jvideo/src/generic/JVBuffer.m3</A>
<LI><A HREF="osf1/JVBuffer.m3#Pool">jvideo/src/osf1/JVBuffer.m3</A>
<LI><A HREF="ultrix/JVBuffer.m3#Pool">jvideo/src/ultrix/JVBuffer.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
