<HTML>
<HEAD>
<TITLE>SRC Modula-3: jvideo/src/JVConverter.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>jvideo/src/JVConverter.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> this is the superclass for objects which provide a stage in the
   conversion or displaying of video or audio information 

<P><PRE>INTERFACE <interface><A HREF="JVConverter.m3">JVConverter</A></interface>;

IMPORT <A HREF="../../libm3/derived/AtomList.i3">AtomList</A>, <A HREF="JVBuffer.i3">JVBuffer</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

EXCEPTION Error(AtomList.T);

TYPE
  <A HREF="JVConverter.m3#T">T</A> &lt;: Public;
  Private &lt;: ROOT;
  Public =
    Private OBJECT
    METHODS
      join  () RAISES {Error, Thread.Alerted};
      leave () RAISES {Error, Thread.Alerted};
      (* clients of the object should call join() to register their
         interest.  When a client joins after there have been none, a
         thread is started to process input.  When the last client leaves,
         the processing thread will be stopped and things cleaned up.

         It is a checked runtime error to call leave more often than
         join. *)

      setPaused (paused := FALSE);
      (* tell the T that one of the clients is not interested in input for
         the moment, but doesn't want to disconnect.  When all the clients
         are paused, the T will stop accepting input.  This is implemented
         as a simple counter, so each client must keep track of its own
         paused state and not set or unset it multiple times in either
         direction.

         It is a checked runtime error if there are more calls to set
         paused than clients, or more calls to unset than calls to set *)

      getOutput (): JVBuffer.Pool;
      (* return the output buffer pool for the T, may return NIL *)

      close ();
      (* close everything down and clean up.  must be overriden by
         subclass *)
    END;
</PRE> callers can describe how unhandled, but non-fatal, errors are
   reported--rather than crashing 
<PRE>TYPE ErrorReporter = OBJECT METHODS report (msg: TEXT); END;

VAR
  toStderr: ErrorReporter;       (* default error reporter, prints text to
                                    stderr *)

PROCEDURE <A HREF="JVConverter.m3#RegisterErrorReporter">RegisterErrorReporter</A> (er: ErrorReporter): ErrorReporter;
</PRE><BLOCKQUOTE><EM> register an error reporter and the return the previous one.  Either may
   be NIL.  The default (NIL) is to crash </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="JVConverter.m3#ReportError">ReportError</A> (msg: TEXT);
</PRE><BLOCKQUOTE><EM> report the given message, or crash if no handler </EM></BLOCKQUOTE><PRE>
</PRE> -- statistics. these can be set and retreived from JVConverterF.i3 -- 

<P><PRE>TYPE
  Statistics = OBJECT
                 framesStarted, framesProcessed: CARDINAL;
                 (* number of frames attempted, and succesfully processed
                    since record last cleared *)
                 timesBlocked: CARDINAL;
                 (* number of times we had to block before being able to
                    send output *)
               END;

END JVConverter.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
