<HTML>
<HEAD>
<TITLE>SRC Modula-3: jvideo/src/JVConverter.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>jvideo/src/JVConverter.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="JVConverter.i3">JVConverter</A></implements></module>;

IMPORT <A HREF="../../rw/src/Common/IO.i3">IO</A>, <A HREF="JVBuffer.i3">JVBuffer</A>, <A HREF="JVConverterF.i3">JVConverterF</A>, <A HREF="../../os/src/Common/Process.i3">Process</A>, <A HREF="../../rw/src/Common/Stdio.i3">Stdio</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
      OVERRIDES
        init  := Init;
        start := StartCrash;
        stop  := StopCrash;

        join       := Join;
        leave      := Leave;
        setPaused  := SetPaused;
        getOutput  := GetOutput;
        close      := CloseCrash;
        startStats := StartStatsCrash;
        stopStats  := StopStats;
        getStats   := GetStats;
      END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (t: T): T =
  BEGIN
    t.pauseEvent := NEW(Thread.Condition);
    RETURN t;
  END Init;

PROCEDURE <A NAME="StartCrash"><procedure>StartCrash</procedure></A> (&lt;*UNUSED*&gt; t: T) =
  BEGIN
    Process.Crash(&quot;JVConverter.Start not defined&quot;);
  END StartCrash;

PROCEDURE <A NAME="StopCrash"><procedure>StopCrash</procedure></A> (&lt;*UNUSED*&gt; t: T) =
  BEGIN
    Process.Crash(&quot;JVConverter.Stop not defined&quot;);
  END StopCrash;

PROCEDURE <A NAME="Join"><procedure>Join</procedure></A> (t: T) RAISES {Error, Thread.Alerted} =
  BEGIN
    LOCK t DO INC(t.clients); IF t.clients = 1 THEN t.start(); END; END;
  END Join;

PROCEDURE <A NAME="Leave"><procedure>Leave</procedure></A> (t: T) RAISES {Error, Thread.Alerted} =
  BEGIN
    LOCK t DO
      &lt;* ASSERT t.clients &gt; 0 *&gt;
      DEC(t.clients);
      IF t.clients = 0 THEN t.stop(); END;
    END;
  END Leave;

PROCEDURE <A NAME="SetPaused"><procedure>SetPaused</procedure></A> (t: T; paused := FALSE) =
  BEGIN
    LOCK t DO
      IF paused THEN
        &lt;* ASSERT t.paused &lt; t.clients *&gt;
        INC(t.paused);
      ELSE
        &lt;* ASSERT t.paused &gt; 0 *&gt;
        DEC(t.paused);
        IF t.paused = 0 THEN Thread.Broadcast(t.pauseEvent); END;
      END;
    END;
  END SetPaused;

PROCEDURE <A NAME="GetOutput"><procedure>GetOutput</procedure></A> (t: T): JVBuffer.Pool =
  BEGIN
    RETURN t.output;
  END GetOutput;

PROCEDURE <A NAME="CloseCrash"><procedure>CloseCrash</procedure></A> (&lt;*UNUSED*&gt; t: T) =
  BEGIN
    Process.Crash(&quot;JVConverter.Close not defined&quot;);
  END CloseCrash;

PROCEDURE <A NAME="StartStatsCrash"><procedure>StartStatsCrash</procedure></A> (&lt;*UNUSED*&gt; t: T) =
  BEGIN
    Process.Crash(&quot;JVConverter.StartStats not defined&quot;);
  END StartStatsCrash;

PROCEDURE <A NAME="StopStats"><procedure>StopStats</procedure></A> (t: T) =
  BEGIN
    LOCK t DO t.statistics := NIL; END;
  END StopStats;

PROCEDURE <A NAME="GetStats"><procedure>GetStats</procedure></A> (t: T): Statistics =
  BEGIN
    RETURN t.statistics;
  END GetStats;
</PRE> -- Error reporting -- 
<PRE>PROCEDURE <A NAME="StderrReport"><procedure>StderrReport</procedure></A>(&lt;* UNUSED*&gt; e: ErrorReporter; msg: TEXT) =
  BEGIN
    IO.Put(msg &amp; &quot;\n&quot;, Stdio.stderr);
  END StderrReport;

VAR
  mutex:= NEW(MUTEX);
  reporter: ErrorReporter := NIL;

PROCEDURE <A NAME="RegisterErrorReporter"><procedure>RegisterErrorReporter</procedure></A> (er: ErrorReporter): ErrorReporter =
  VAR oldRep: ErrorReporter;
  BEGIN
    LOCK mutex DO oldRep := reporter; reporter := er; END;
    RETURN oldRep;
  END RegisterErrorReporter;

PROCEDURE <A NAME="ReportError"><procedure>ReportError</procedure></A> (msg: TEXT) =
  BEGIN
    LOCK mutex DO
      IF msg = NIL THEN Process.Crash(&quot;no message\n&quot;); END;
      IF reporter = NIL THEN Process.Crash(msg &amp; &quot;\n&quot;); END;
      reporter.report(msg);
    END;
  END ReportError;

BEGIN
  toStderr := NEW(ErrorReporter, report := StderrReport);
END JVConverter.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
