<HTML>
<HEAD>
<TITLE>SRC Modula-3: jvideo/src/JVDecomp.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>jvideo/src/JVDecomp.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> accepts input from a JVConverter and decompresses it into its own buffer
   pool.  These are immutable.  If you want different parameters, close
   this one and open a new one 

<P><PRE>INTERFACE <interface><A HREF="JVDecomp.m3">JVDecomp</A></interface>;

IMPORT <A HREF="../../atom/src/Atom.i3">Atom</A>, <A HREF="JVBuffer.i3">JVBuffer</A>, <A HREF="JVConverter.i3">JVConverter</A>, <A HREF="Jvs.i3">Jvs</A>, <A HREF="../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../time/src/Common/Tick.i3">Tick</A>;

VAR decompError: Atom.T;         (* error has come from this module *)

TYPE
  <A HREF="JVDecomp.m3#T">T</A> &lt;: Public;
  Public =
    JVConverter.T OBJECT
    METHODS
      init (         in        : JVConverter.T;
            READONLY dparams   : Jvs.DcmpParams;
            READONLY cmap      : Jvs.ColormapInfo;
                     maxBuffers: CARDINAL           := 2;
                     factory   : JVBuffer.Factory   := NIL;
                     server    : Jvs.T              := NIL  ): T
            RAISES {OSError.E, Thread.Alerted};
      (* initial setup of T.  &quot;in&quot; provides the frames to decompress.  The
         parameters specify the type of frames to be returned.
         &quot;maxBuffers&quot; specifies the maximum number of buffers allowed in
         the output buffer pool.  &quot;factory&quot; is used for creating new
         buffers.  If it is NIL, then a new one will be created; if
         &quot;server&quot; is non-NIL, then that will be used, otherwise a new one
         will be created.  If &quot;factory&quot; is non-NIL, then &quot;server&quot; must be
         the same one used in &quot;factory&quot; *)

      outSize (): Point.T;
      (* A Jvs.T can only decompress to certain sizes, so call outSize to
         find out what size the buffers really are.  If the converter is
         dead, or not yet ready, returns Point.Origin *)

      getInput (): JVConverter.T;
      (* returns input converter associated with the T *)
    END;
</PRE> -- statistics -- 

<P><PRE>TYPE
  Statistics =
    JVConverter.Statistics OBJECT
      cumLatency: Tick.T;
      (* accumulation of difference between when the last pipeline stage
         finished with a buffer and this stage received it *)
    END;

END JVDecomp.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
