<HTML>
<HEAD>
<TITLE>SRC Modula-3: jvideo/src/JVDecomp.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>jvideo/src/JVDecomp.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="JVDecomp.i3">JVDecomp</A></implements></module>;

IMPORT <A HREF="../../libm3/derived/AtomList.i3">AtomList</A>, <A HREF="../../atom/src/Atom.i3">Atom</A>, <A HREF="JVBuffer.i3">JVBuffer</A>, <A HREF="JVConverter.i3">JVConverter</A>, <A HREF="JVConverterF.i3">JVConverterF</A>, <A HREF="JVFromSource.i3">JVFromSource</A>,
       <A HREF="JVFromDecomp.i3">JVFromDecomp</A>, <A HREF="Jvs.i3">Jvs</A>, <A HREF="../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../time/src/Common/Tick.i3">Tick</A>, <A HREF="../../word/src/Word.i3">Word</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        in        : JVConverter.T;
        maxBuffers: CARDINAL;
        server    : Jvs.T;
        dparams                        := Jvs.DefaultDecompress;
        cmap      : Jvs.ColormapInfo;
        thread    : Thread.T           := NIL;
        closure   : Closure            := NIL;
      OVERRIDES
        init := Init;

        start := Start;
        stop  := Stop;

        outSize  := OutSize;
        getInput := GetInput;

        startStats := StartStats;
        close      := Close;
      END;
</PRE> {{{ -- methods -- 

<P><PRE>PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (         t         : T;
                         in        : JVConverter.T;
                READONLY dparams   : Jvs.DcmpParams;
                READONLY cmap      : Jvs.ColormapInfo;
                         maxBuffers: CARDINAL           := 2;
                         factory   : JVBuffer.Factory   := NIL;
                         server    : Jvs.T              := NIL  ): T
  RAISES {OSError.E, Thread.Alerted} =
  VAR newFac := factory;
  BEGIN
    TRY
      LOCK t DO
        EVAL JVConverter.T.init(t);
        t.maxBuffers := maxBuffers;
        t.in := in;
        t.dparams := dparams;
        t.cmap := cmap;
        t.closure := NEW(Closure, t := t);

        (* create new output buffer pool.  It will be cleaned out when
           collected *)
        IF server = NIL THEN
          t.server := NEW(Jvs.T).init();
        ELSE
          t.server := server;
        END;
        IF newFac = NIL THEN
          newFac := NEW(JVFromDecomp.Factory).init(t.server);
        END;
        t.output := NEW(JVBuffer.Pool).init(newFac, maxBuffers);

        (* get real width and height for image *)
        EVAL t.server.colormap(t.cmap);
        EVAL t.server.setDecompress(t.dparams);

      END;
    EXCEPT
    | OSError.E (e) =&gt; RAISE OSError.E(AtomList.Cons(decompError, e));
    END;
    RETURN t;
  END Init;

PROCEDURE <A NAME="Start"><procedure>Start</procedure></A> (t: T) RAISES {JVConverter.Error, Thread.Alerted} =
  BEGIN
    &lt;* ASSERT t.output # NIL *&gt;
    TRY
      t.output.setSize(t.maxBuffers);
      t.in.join();
      t.thread := Thread.Fork(t.closure);
    EXCEPT
    | OSError.E (e) =&gt;
        RAISE JVConverter.Error(
                AtomList.Cons(Atom.FromText(&quot;JVDecomp.Start&quot;), e));
    END;
  END Start;

PROCEDURE <A NAME="Stop"><procedure>Stop</procedure></A> (t: T) RAISES {JVConverter.Error, Thread.Alerted} =
  BEGIN
    TRY
      t.output.setSize(0);
    EXCEPT
    | OSError.E (al) =&gt;
        RAISE JVConverter.Error(
                AtomList.Cons(Atom.FromText(&quot;JVDecomp.Stop&quot;), al));
    END;
    InnerClose(t);
  END Stop;

PROCEDURE <A NAME="OutSize"><procedure>OutSize</procedure></A> (t: T): Point.T =
  BEGIN
    RETURN Point.T{t.dparams.outX, t.dparams.outY};
  END OutSize;

PROCEDURE <A NAME="GetInput"><procedure>GetInput</procedure></A> (t: T): JVConverter.T =
  BEGIN
    RETURN t.in;
  END GetInput;

PROCEDURE <A NAME="Close"><procedure>Close</procedure></A> (t: T) =
  BEGIN
    LOCK t DO
      TRY
        InnerClose(t);
      EXCEPT
        JVConverter.Error, Thread.Alerted =&gt; (*skip *)
      END;
      t.output.signalClosed();
      t.output := NIL;
      t.server.close();
    END;
  END Close;

PROCEDURE <A NAME="InnerClose"><procedure>InnerClose</procedure></A> (t: T) RAISES {JVConverter.Error, Thread.Alerted} =
  (* LL &gt;= t *)
  VAR
    res   : REFANY;
    thread         := t.thread;
  BEGIN
    IF thread # NIL THEN
      Thread.Alert(thread);

      Thread.Release(t);
      res := Thread.Join(thread);
      Thread.Acquire(t);
      t.thread := NIL;

      t.in.leave();
      (* t.in := NIL; *)

      IF res # NIL AND ISTYPE(res, AtomList.T) THEN
        RAISE
          JVConverter.Error(AtomList.Cons(Atom.FromText(&quot;JVDecomp.Stop&quot;),
                                          NARROW(res, AtomList.T)));
      END;
    END;
  END InnerClose;

PROCEDURE <A NAME="StartStats"><procedure>StartStats</procedure></A> (t: T) =
  BEGIN
    LOCK t DO
      IF t.statistics = NIL THEN t.statistics := NEW(Statistics); END;
      WITH s = NARROW(t.statistics, Statistics) DO
        s.framesStarted := 0;
        s.framesProcessed := 0;
        s.timesBlocked := 0;
        s.cumLatency := 0;
      END;
    END;
  END StartStats;
</PRE> }}} 
 {{{ -- decompress thread -- 

<P><PRE>TYPE Closure = Thread.Closure OBJECT t: T;  OVERRIDES apply := Apply; END;

PROCEDURE <A NAME="Apply"><procedure>Apply</procedure></A> (cl: Closure): REFANY =
  VAR
    inbuf : JVFromSource.T := NIL;
    outbuf: JVFromDecomp.T := NIL;
    t                      := cl.t;
    source: JVBuffer.Pool  := NIL;
    errors: AtomList.T     := NIL;
    paused                 := FALSE;
    tick  : Tick.T;

  PROCEDURE ProcessFrame () RAISES {OSError.E, Thread.Alerted} =
    (* decompress the frame, update the statistics, and put the frame on
       the output queue *)
    BEGIN
      TRY
        t.server.decompress(inbuf.shmid, outbuf.shmid, inbuf.frameLength);
        outbuf.params := t.dparams;
        outbuf.cmap := t.cmap;
        outbuf.serial := inbuf.serial;
        outbuf.timestamp := inbuf.timestamp;
        outbuf.ready := inbuf.ready; (* pass ready closure on to clients of
                                        decompressed buffer *)
        outbuf.localTime := Tick.Now();

        tick := inbuf.localTime;
        inbuf.free();
        inbuf := NIL;
        t.output.insert(outbuf);
        IF t.statistics # NIL THEN
          WITH s = NARROW(t.statistics, Statistics) DO
            INC(s.framesProcessed);
            s.cumLatency :=
              Word.Plus(s.cumLatency, Word.Minus(outbuf.localTime, tick));
          END;
        END;
        outbuf := NIL;
        outbuf := NARROW(t.output.getFreeBuffer(FALSE), JVFromDecomp.T);
      EXCEPT
      | OSError.E (e) =&gt;
          (* if this is a bad decompress, throw the frame away and keep
             going *)
          IF DecompressError(e) THEN
            inbuf.free();
            inbuf := NIL;
          ELSE
            RAISE OSError.E(e);
          END;
      END;
      &lt;* ASSERT inbuf = NIL *&gt;
    END ProcessFrame;

  BEGIN
    TRY
      source := t.in.getOutput();
      &lt;* ASSERT source # NIL *&gt;
      source.join();
      LOOP
        IF outbuf = NIL OR t.paused &gt; 0 THEN
          LOCK t DO
            IF t.statistics # NIL THEN
              INC(NARROW(t.statistics, Statistics).timesBlocked);
            END;
          END;
          t.in.setPaused(TRUE);
          paused := TRUE;

          IF outbuf = NIL THEN
            outbuf := NARROW(t.output.getFreeBuffer(TRUE), JVFromDecomp.T);
          END;

          LOCK t DO
            WHILE t.paused &gt; 0 DO Thread.AlertWait(t, t.pauseEvent); END;
          END;
          t.in.setPaused(FALSE);
          paused := FALSE;
        END;

        inbuf := NARROW(source.waitForChange(), JVFromSource.T);

        LOCK t DO
          IF t.statistics # NIL THEN
            INC(NARROW(t.statistics, Statistics).framesStarted);
          END;

          IF inbuf.info.width &gt; 0 AND inbuf.info.height &gt; 0 THEN
            (* jvserver complains if width, height &lt;= 0 *)
            t.dparams.qfactor := inbuf.info.qfactor;
            t.dparams.inX := inbuf.info.width;
            t.dparams.inY := inbuf.info.height;

            EVAL
              t.server.setDecompress(t.dparams); (* no-op if no change *)
            ProcessFrame();
          ELSE
            inbuf.free();
            inbuf := NIL;
          END;
        END;
      END;                       (* loop *)
    EXCEPT
    | OSError.E (e) =&gt; errors := e;
    | JVBuffer.Closed, Thread.Alerted =&gt; (* skip *)
    END;
    IF paused THEN t.in.setPaused(FALSE); END;
    IF inbuf # NIL THEN inbuf.free(); END;
    IF outbuf # NIL THEN outbuf.free(); END;
    IF source # NIL THEN source.leave(); END;

    RETURN errors;
  END Apply;

PROCEDURE <A NAME="DecompressError"><procedure>DecompressError</procedure></A> (e: AtomList.T): BOOLEAN =
  (* return TRUE if &quot;e&quot; contains Jvs.DecompressFailure *)
  VAR curr := e;
  BEGIN
    WHILE curr # NIL DO
      IF curr.head = Jvs.DecompressFailure THEN RETURN TRUE; END;
      curr := curr.tail;
    END;
    RETURN FALSE;
  END DecompressError;
</PRE> }}} 

<P>
<P><PRE>BEGIN
  decompError := Atom.FromText(&quot;JVDecomp: &quot;);

END JVDecomp.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
