<HTML>
<HEAD>
<TITLE>SRC Modula-3: jvideo/src/JVDecompPool.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>jvideo/src/JVDecompPool.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> this interface provides shared access to a set of JVDecomps and JVSinks.
   When a caller asks for a particular type of connection to a jv source,
   the pool will try to find an existing Sink and Decomp which match the
   parameters or create new ones.  This done, it links the Sink and Decomp
   and returns the Decomp. 

<P><PRE>INTERFACE <interface><A HREF="JVDecompPool.m3">JVDecompPool</A></interface>;

IMPORT <A HREF="JVBuffer.i3">JVBuffer</A>, <A HREF="JVDecomp.i3">JVDecomp</A>, <A HREF="JVSink.i3">JVSink</A>, <A HREF="Jvs.i3">Jvs</A>, <A HREF="../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

PROCEDURE <A HREF="JVDecompPool.m3#GetDecomp">GetDecomp</A> (hostname: TEXT;          (* name of source host *)
                     quality : JVSink.Quality := JVSink.DefaultQuality;
                     (* transmission quality *)
                     READONLY dparams: Jvs.DcmpParams;
                     READONLY cmap   : Jvs.ColormapInfo;
                              create                      := TRUE;
                     maxSinkBuffs, maxDecompBuffs: CARDINAL := 2;
                     decompFactory: JVBuffer.Factory := NIL;
                     decompServer : Jvs.T            := NIL;
                     delay: CARDINAL := 0): JVDecomp.T
  RAISES {OSError.E, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> try to find an exisiting Sink/Decomp pair which match the given
   parameters.  If either is not found then, create some if <CODE>create</CODE> is
   TRUE, otherwise return NIL.
<P>
   <CODE>maxSinkBuffs</CODE> and <CODE>maxDecompBuffs</CODE> set the maximum sizes for the buffer
   pools if they are created.
<P>
   <CODE>decompFactory</CODE> is used for creating new decompression.  buffers.  If it
   is NIL, then a new one will be created; if <CODE>decompServer</CODE> is non-NIL,
   then that will be used, otherwise a new one will be created.  If
   <CODE>decompFactory</CODE> is non-NIL, then <CODE>decompServer</CODE> must be the same one
   used in <CODE>decompFactory</CODE>
<P>
   the caller should call decomp.join() and pool.join() to register an
   interest with the returned decomp and pool </EM></BLOCKQUOTE><PRE>

END JVDecompPool.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
