<HTML>
<HEAD>
<TITLE>SRC Modula-3: jvideo/src/JVDecompPool.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>jvideo/src/JVDecompPool.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="JVDecompPool.i3">JVDecompPool</A></implements></module>;

IMPORT <A HREF="JVBuffer.i3">JVBuffer</A>, <A HREF="JVDecomp.i3">JVDecomp</A>, <A HREF="JVSink.i3">JVSink</A>, <A HREF="JVSinkPool.i3">JVSinkPool</A>, <A HREF="Jvs.i3">Jvs</A>, <A HREF="../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

TYPE
  Elt = RECORD
          sourceHost: TEXT;
          quality   : JVSink.Quality;
          dparams   : Jvs.DcmpParams;
          cmap      : Jvs.ColormapInfo;
          decomp    : JVDecomp.T;
          next      : EltRef             := NIL;
        END;
  EltRef = REF Elt;

VAR jvs: Jvs.T := NIL;

PROCEDURE <A NAME="GetDecomp"><procedure>GetDecomp</procedure></A> (hostname: TEXT;
                     quality : JVSink.Quality := JVSink.DefaultQuality;
                     READONLY dparams: Jvs.DcmpParams;
                     READONLY cmap   : Jvs.ColormapInfo;
                              create                      := TRUE;
                     maxSinkBuffs, maxDecompBuffs: CARDINAL := 2;
                     decompFactory: JVBuffer.Factory := NIL;
                     decompServer : Jvs.T            := NIL;
                     delay        : CARDINAL                 ): JVDecomp.T
  RAISES {OSError.E, Thread.Alerted} =
  VAR localparams := dparams;
  (* with output sizes converted for jv board alignment *)
  BEGIN
    (* get acceptable outX, outY *)
    IF jvs = NIL THEN jvs := NEW(Jvs.T).init(); END;
    EVAL jvs.setDecompress(localparams);

    WITH elt = SearchList(hostname, quality, localparams, cmap) DO
      IF elt # NIL THEN RETURN elt.decomp; END;
    END;
    IF NOT create THEN RETURN NIL; END;

    WITH sink = JVSinkPool.GetSink(
                  hostname, quality, create, maxSinkBuffs, delay),
         res = NEW(JVDecomp.T).init(sink, dparams, cmap, maxDecompBuffs,
                                    decompFactory, decompServer),

         elt = NEW(EltRef, sourceHost := hostname, quality := quality,
                   dparams := localparams, cmap := cmap, decomp := res) DO
      &lt;* ASSERT sink # NIL *&gt;
      LOCK mutex DO elt.next := list; list := elt; END;
      RETURN res;
    END;
  END GetDecomp;
</PRE> -- internal procedures -- 

<P><PRE>PROCEDURE <A NAME="SearchList"><procedure>SearchList</procedure></A> (         sourceHost: TEXT;
                               quality   : JVSink.Quality;
                      READONLY dparams   : Jvs.DcmpParams;
                      READONLY cmap      : Jvs.ColormapInfo): EltRef =
  (* look for an element which matches params.  Return NIL if none *)
  PROCEDURE TextEqual (t1, t2: TEXT): BOOLEAN =
    BEGIN
      RETURN (t1 = NIL AND t2 = NIL)
               OR (t1 # NIL AND t2 # NIL AND Text.Equal(t1, t2));
    END TextEqual;
  VAR curr := list;
  BEGIN
    LOCK mutex DO
      WHILE curr # NIL DO
        IF TextEqual(sourceHost, curr.sourceHost)
             AND quality = curr.quality AND dparams = curr.dparams
             AND cmap.id = curr.cmap.id
             AND cmap.nColors = curr.cmap.nColors
             AND cmap.monochrome = curr.cmap.monochrome
             AND TextEqual(cmap.displayName, curr.cmap.displayName) THEN
          EXIT;
        END;
        curr := curr.next;
      END;
    END;
    RETURN curr;
  END SearchList;

VAR
  mutex         := NEW(MUTEX);
  list : EltRef := NIL;

BEGIN
END JVDecompPool.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
