<HTML>
<HEAD>
<TITLE>SRC Modula-3: jvideo/src/JVSinkPool.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>jvideo/src/JVSinkPool.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> this interface provides shared access to a set of JVSinks.  When a
   caller asks for a particular type of Sink, the pool will try to find an
   existing one or create a new one if none exists. 

<P><PRE>INTERFACE <interface><A HREF="JVSinkPool.m3">JVSinkPool</A></interface>;

IMPORT <A HREF="JVSink.i3">JVSink</A>, <A HREF="../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

PROCEDURE <A HREF="JVSinkPool.m3#GetSink">GetSink</A> (hostname: TEXT;          (* name of source host *)
                   quality : JVSink.Quality := JVSink.DefaultQuality;
                   (* transmission quality *)
                   create               := TRUE;
                   maxBuffers: CARDINAL := 2;
                   delay: CARDINAL := 0): JVSink.T
  RAISES {OSError.E, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> try to find an existing sink which matches the given parameters If one
   exists, then return it.  If none exists, then if <CODE>create</CODE> then make a
   new one otherwise return NIL.
<P>
   the <CODE>maxBuffers</CODE> field is used during the creation of a buffer pool for
   a new sink and specifies the maximum size of the pool.
<P>
   the caller should call sink.join() and pool.join() to register an
   interest with the returned sink and pool </EM></BLOCKQUOTE><PRE>

END JVSinkPool.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
