<HTML>
<HEAD>
<TITLE>SRC Modula-3: jvideo/src/JVSinkPool.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>jvideo/src/JVSinkPool.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="JVSinkPool.i3">JVSinkPool</A></implements></module>;

IMPORT <A HREF="JVFromSource.i3">JVFromSource</A>, <A HREF="Jvs.i3">Jvs</A>, <A HREF="JVSink.i3">JVSink</A>, <A HREF="../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

TYPE
  Elt = RECORD
          hostname: TEXT;
          quality : JVSink.Quality;
          sink    : JVSink.T;
          delay   : CARDINAL;
          next    : EltRef           := NIL;
        END;
  EltRef = REF Elt;

PROCEDURE <A NAME="GetSink"><procedure>GetSink</procedure></A> (hostname  : TEXT;
                   quality   : JVSink.Quality := JVSink.DefaultQuality;
                   create                     := TRUE;
                   maxBuffers: CARDINAL       := 2;
                   delay     : CARDINAL                                 ):
  JVSink.T RAISES {OSError.E, Thread.Alerted} =
  VAR res: JVSink.T := NIL;
  BEGIN
    WITH elt = SearchList(hostname, quality, delay) DO
      IF elt # NIL THEN RETURN elt.sink; END;
    END;
    IF create THEN
      res := NEW(JVSink.T).init(
               hostname, quality, maxBuffers,
               NEW(JVFromSource.Factory).init(NEW(Jvs.T).init()), delay);

      (* add to list *)
      WITH elt = NEW(EltRef, hostname := hostname, quality := quality,
                     delay := delay, sink := res) DO
        LOCK mutex DO elt.next := list; list := elt; END;
      END;
    END;
    RETURN res;
  END GetSink;
</PRE> -- internal procedures -- 

<P><PRE>PROCEDURE <A NAME="SearchList"><procedure>SearchList</procedure></A> (hostname: TEXT;
                      quality : JVSink.Quality;
                      delay   : CARDINAL        ): EltRef =
  (* look for an element which matches params.  Return NIL if none *)
  VAR curr := list;
  BEGIN
    LOCK mutex DO
      WHILE curr # NIL DO
        IF ((hostname = NIL AND curr.hostname = NIL)
              OR (hostname # NIL AND curr.hostname # NIL
                    AND Text.Equal(hostname, curr.hostname)))
             AND quality = curr.quality AND delay = curr.delay THEN
          EXIT;
        END;
        curr := curr.next;
      END;
    END;
    RETURN curr;
  END SearchList;

VAR
  mutex         := NEW(MUTEX);
  list : EltRef := NIL;
BEGIN

END JVSinkPool.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
