<HTML>
<HEAD>
<TITLE>SRC Modula-3: jvideo/src/Jv.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>jvideo/src/Jv.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> common type for client interface to local J-Video server.  The video and
   audio types are subclassed from it. 

<P><PRE>INTERFACE <interface><A HREF="#x1">Jv</A></interface>;

IMPORT <A HREF="../../atom/src/Atom.i3">Atom</A>, <A HREF="../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

TYPE
  <A HREF="#x2">T</A> &lt;: Public;
  Public =
    MUTEX OBJECT
    METHODS
      (* LL &gt; self *)
      init (pipeName: TEXT): T RAISES {OSError.E};
      (* establish connection with local server.  &quot;pipeName&quot; is the name of
         the named unix socket which the client should connect to *)
      close ();
      (* close connection to local server, ignoring all exceptions *)
    END;

VAR ServerFailure: Atom.T;
</PRE><BLOCKQUOTE><EM> may be part of OSError.E list </EM></BLOCKQUOTE><PRE>
</PRE> LL &gt;= t 
<PRE>PROCEDURE <A HREF="#x3">Send</A> (t: T; buf: ADDRESS; nbytes: CARDINAL)
  RAISES {OSError.E, Thread.Alerted};

PROCEDURE <A HREF="#x4">Recv</A> (t: T; buf: ADDRESS; nbytes: CARDINAL)
  RAISES {OSError.E, Thread.Alerted};

END Jv.
</PRE>
</inInterface>
<HR>
<A NAME="x1">Jv's implementation  is in:
</A><UL>
<LI><A HREF="generic/Jv.m3#0TOP0">jvideo/src/generic/Jv.m3</A>
<LI><A HREF="osf1/Jv.m3#0TOP0">jvideo/src/osf1/Jv.m3</A>
<LI><A HREF="ultrix/Jv.m3#0TOP0">jvideo/src/ultrix/Jv.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">opaque type Jv.T is in:
</A><UL>
<LI><A HREF="generic/Jv.m3#T">jvideo/src/generic/Jv.m3</A>
<LI><A HREF="osf1/Jv.m3#T">jvideo/src/osf1/Jv.m3</A>
<LI><A HREF="ultrix/Jv.m3#T">jvideo/src/ultrix/Jv.m3</A>
</UL>
<P>
<HR>
<A NAME="x3">procedure Jv.Send is in:
</A><UL>
<LI><A HREF="generic/Jv.m3#Send">jvideo/src/generic/Jv.m3</A>
<LI><A HREF="osf1/Jv.m3#Send">jvideo/src/osf1/Jv.m3</A>
<LI><A HREF="ultrix/Jv.m3#Send">jvideo/src/ultrix/Jv.m3</A>
</UL>
<P>
<HR>
<A NAME="x4">procedure Jv.Recv is in:
</A><UL>
<LI><A HREF="generic/Jv.m3#Recv">jvideo/src/generic/Jv.m3</A>
<LI><A HREF="osf1/Jv.m3#Recv">jvideo/src/osf1/Jv.m3</A>
<LI><A HREF="ultrix/Jv.m3#Recv">jvideo/src/ultrix/Jv.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
