<HTML>
<HEAD>
<TITLE>SRC Modula-3: jvideo/src/Jva.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>jvideo/src/Jva.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> note: SIGPIPE set to be ignored by JVSink 

<P><PRE>UNSAFE MODULE <module><implements><A HREF="Jva.i3">Jva</A></implements></module>;

IMPORT <A HREF="../../atom/src/Atom.i3">Atom</A>, <A HREF="../../libm3/derived/AtomList.i3">AtomList</A>, <A HREF="Jv.i3">Jv</A>, <A HREF="JvaProtocol.i3">JvaProtocol</A>, <A HREF="../../C/src/Common/M3toC.i3">M3toC</A>, <A HREF="../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
      OVERRIDES
        init          := Init;
        connect       := Connect;
        setMute       := SetMute;
        setVolume     := SetVolume;
        getStatistics := GetStatistics;
        close         := Close;
      END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (t: T): T RAISES {OSError.E} =
  BEGIN
    TRY
      LOCK t DO RETURN Jv.T.init(t, JvaProtocol.PipeName); END;
    EXCEPT
    | OSError.E (e) =&gt; RAISE OSError.E(AtomList.Cons(Jv.ServerFailure, e));
    END;
  END Init;

PROCEDURE <A NAME="Connect"><procedure>Connect</procedure></A> (t: T; hostname: TEXT)
  RAISES {OSError.E, Thread.Alerted} =
  VAR
    req  : JvaProtocol.ConnectReqRec;
    reply: JvaProtocol.ConnectReplyRec;
  BEGIN
    IF hostname = NIL OR Text.Empty(hostname) THEN
      RAISE OSError.E(AtomList.List1(invalidHostname));
    END;
    TRY
      req.hostnameLength := Text.Length(hostname) + 1;
      WITH string = M3toC.TtoS(hostname) DO
          LOCK t DO
            Jv.Send(t, ADR(req), BYTESIZE(req));
            Jv.Send(t, string, req.hostnameLength);
            Jv.Recv(t, ADR(reply), BYTESIZE(reply));
          END;
          IF reply.request # req.request THEN
            RAISE OSError.E(AtomList.List1(Atom.FromText(&quot;Connect&quot;)));
          END;
      END;
    EXCEPT
    | OSError.E (e) =&gt; RAISE OSError.E(AtomList.Cons(Jv.ServerFailure, e));
    END;
  END Connect;

CONST
  MuteVal = ARRAY BOOLEAN OF
              JvaProtocol.MuteCode{JvaProtocol.MuteOff, JvaProtocol.MuteOn};

PROCEDURE <A NAME="SetMute"><procedure>SetMute</procedure></A> (t: T; on: BOOLEAN) RAISES {OSError.E, Thread.Alerted} =
  VAR
    req  : JvaProtocol.MuteReqRec;
    reply: JvaProtocol.MuteReplyRec;
  BEGIN
    TRY
      req.mute := MuteVal[on];
      LOCK t DO
        Jv.Send(t, ADR(req), BYTESIZE(req));
        Jv.Recv(t, ADR(reply), BYTESIZE(reply));
      END;
      IF reply.request # req.request THEN
        RAISE OSError.E(AtomList.List1(Atom.FromText(&quot;Mute&quot;)));
      END;
    EXCEPT
    | OSError.E (e) =&gt; RAISE OSError.E(AtomList.Cons(Jv.ServerFailure, e));
    END;
  END SetMute;

PROCEDURE <A NAME="SetVolume"><procedure>SetVolume</procedure></A> (t: T; volume: Volume)
  RAISES {OSError.E, Thread.Alerted} =
  VAR
    req  : JvaProtocol.VolumeReqRec;
    reply: JvaProtocol.VolumeReplyRec;
  BEGIN
    TRY
      req.volume := volume;
      LOCK t DO
        Jv.Send(t, ADR(req), BYTESIZE(req));
        Jv.Recv(t, ADR(reply), BYTESIZE(reply));
      END;
      IF reply.request # req.request THEN
        RAISE OSError.E(AtomList.List1(Atom.FromText(&quot;Volume&quot;)));
      END;
    EXCEPT
    | OSError.E (e) =&gt; RAISE OSError.E(AtomList.Cons(Jv.ServerFailure, e));
    END;
  END SetVolume;

PROCEDURE <A NAME="GetStatistics"><procedure>GetStatistics</procedure></A> (t: T): Statistics
  RAISES {OSError.E, Thread.Alerted} =
  VAR
    req  : JvaProtocol.StatisticsReqRec;
    reply: JvaProtocol.StatisticsReplyRec;
  BEGIN
    TRY
      LOCK t DO
        Jv.Send(t, ADR(req), BYTESIZE(req));
        Jv.Recv(t, ADR(reply), BYTESIZE(reply));
      END;
      IF reply.request # req.request THEN
        RAISE OSError.E(AtomList.List1(Atom.FromText(&quot;Statistics&quot;)));
      END;
    EXCEPT
    | OSError.E (e) =&gt; RAISE OSError.E(AtomList.Cons(Jv.ServerFailure, e));
    END;
    RETURN reply.statistics;
  END GetStatistics;

PROCEDURE <A NAME="Close"><procedure>Close</procedure></A> (t: T) =
  BEGIN
    LOCK t DO Jv.T.close(t); END;
  END Close;

BEGIN
  invalidHostname := Atom.FromText(&quot;Jva: invalid hostname&quot;);
END Jva.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
