<HTML>
<HEAD>
<TITLE>SRC Modula-3: jvideo/src/JvaProtocol.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>jvideo/src/JvaProtocol.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface>JvaProtocol</interface>;

IMPORT <A HREF="Jva.i3">Jva</A>;

FROM <A HREF="../../C/src/Common/Ctypes.i3">Ctypes</A> IMPORT int;

CONST
  Socket = 2520;                 (* the port number for the local server *)
  PipeName    = &quot;/tmp/jvideo/argohear.2520&quot;;
  (* client and server communicate via this named pipe *)

  MAXREQUEST = 256;

  FirstRequest = Connect;
  Connect      = 1;
  Mute         = 2;
  Volume       = 3;
  Statistics   = 4;
  LastRequest  = Statistics;

TYPE TypeCode = BITS BITSIZE(int) FOR [FirstRequest .. LastRequest];

CONST
  MuteOff = 0;
  MuteOn  = 1;

TYPE MuteCode = BITS BITSIZE(int) FOR [MuteOff .. MuteOn];

TYPE
  ConnectReqRec =
    RECORD
      request       : TypeCode := Connect;
      hostnameLength: int;
      (* data for hostname goes here for 'hostnameLength' bytes *)
    END;
  ConnectReqPtr = UNTRACED REF ConnectReqRec;

TYPE
  ConnectReplyRec = RECORD
                      request: int;  (* to check correct request code *)
                    END;
  ConnectReplyPtr = UNTRACED REF ConnectReplyRec;

TYPE
  MuteReqRec = RECORD
                 request: TypeCode   := Mute;
                 mute   : MuteCode;
               END;
  MuteReqPtr = UNTRACED REF MuteReqRec;

TYPE
  MuteReplyRec = RECORD
                   request: int;  (* to check correct request code *)
                 END;
  MuteReplyPtr = UNTRACED REF MuteReplyRec;

TYPE
  VolumeReqRec = RECORD
                   request: TypeCode := Volume;
                   volume : int;
                 END;
  VolumeReqPtr = UNTRACED REF VolumeReqRec;

TYPE
  VolumeReplyRec = RECORD
                     request: int;  (* to check correct request code *)
                   END;
  VolumeReplyPtr = UNTRACED REF VolumeReplyRec;

TYPE
  StatisticsReqRec = RECORD request: TypeCode := Statistics;  END;
  StatisticsReqPtr = UNTRACED REF StatisticsReqRec;

TYPE
  StatisticsReplyRec = RECORD
                         request: int;  (* to check correct request code *)
                         statistics: Jva.Statistics;
                       END;
  StatisticsReplyPtr = UNTRACED REF StatisticsReplyRec;

CONST
  HdrSizes = ARRAY TypeCode OF
               CARDINAL{
               BYTESIZE(ConnectReplyRec), BYTESIZE(MuteReplyRec),
               BYTESIZE(VolumeReplyRec), BYTESIZE(StatisticsReplyRec)};
</PRE> no message is shorter than an AnyHeader, so we can always read in the
   number of bytes in an AnyHeader 
<PRE>TYPE
  AnyHeader = RECORD type: int;  END;
  AnyHeaderPtr = UNTRACED REF AnyHeader;

CONST
  MaxHdrSize = MaxHdrBytes DIV BYTESIZE(CHAR);
  MaxHdrBytes = MAX(BYTESIZE(AnyHeader),
                    MAX(HdrSizes[Connect],
                        MAX(HdrSizes[Mute],
                            MAX(HdrSizes[Volume], HdrSizes[Statistics]))));

TYPE
  Header = ARRAY [0 .. MaxHdrSize - 1] OF CHAR;
  HeaderPtr = UNTRACED REF Header;

END JvaProtocol.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
