<HTML>
<HEAD>
<TITLE>SRC Modula-3: jvideo/src/Jvs.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>jvideo/src/Jvs.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> video client interface to the local J-Video server.  All the methods
   lock the object and block the thread until the server replies 

<P><PRE>INTERFACE <interface><A HREF="Jvs.m3">Jvs</A></interface>;

IMPORT <A HREF="../../atom/src/Atom.i3">Atom</A>, <A HREF="../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="Jv.i3">Jv</A>, <A HREF="../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

TYPE
  ShmBufId = Ctypes.int;
  BufferType = {Compress, Decompress};
</PRE> parameters for decompression 
<PRE>TYPE
  DcmpParams = RECORD
                 qfactor   : CARDINAL;
                 inX, inY  : INTEGER;
                 brightness: CARDINAL;
                 contrast  : CARDINAL;
                 saturation: CARDINAL;
                 reqX, reqY: INTEGER;   (* what the client wants *)
                 outX, outY: INTEGER;   (* what the client gets *)
               END;
CONST DefaultDecompress = DcmpParams{0, 640, 480, 0, 0, 0, 0, 0, 0, 0};

TYPE
  Id = Ctypes.unsigned_long_int; (* same as X *)
  ColormapInfo = RECORD
                   id         : Id       := IdNone;
                   nColors    : CARDINAL := 0; (* in/out *)
                   monochrome            := FALSE;
                   displayName: TEXT     := NIL;
                 END;
CONST IdNone = 0;                (* same as X *)

VAR XNameTooLong, DecompressFailure: Atom.T;
</PRE><BLOCKQUOTE><EM> may be part of OSError.E list </EM></BLOCKQUOTE><PRE>

TYPE
  <A HREF="Jvs.m3#T">T</A> &lt;: Public;
  Public =
    Jv.T OBJECT
    METHODS
      (* all methods LL &lt; self *)

      init (): T RAISES {OSError.E};
      (* initialise local state and establish a connection with the local
         server *)

      allocateBuffer (type: BufferType): ShmBufId
                      RAISES {OSError.E, Thread.Alerted};
      (* allocate a shared memory buffer in the server, return its kernel
         id *)
      deallocateBuffer (shmid: ShmBufId)
                        RAISES {OSError.E, Thread.Alerted};
      (* deallocate a shared memory buffer in the server *)

      setCompress (qfactor, xdec, ydec, frameskip: INTEGER): Point.T
                   RAISES {OSError.E, Thread.Alerted};
      (* set parameters for the compression stream *)

      compress (dest: ShmBufId): CARDINAL
                RAISES {OSError.E, Thread.Alerted};
      (* tells the server to compress a video frame into the the shared
         memory buffer *)

      decompress (src, dest: ShmBufId; srcByteLength: CARDINAL)
                  RAISES {OSError.E, Thread.Alerted};
      (* tells the server to to decompress &quot;src&quot; into &quot;dest&quot;.  The server
         will zero the compressed data block from the end of the compressed
         data to the next 512-byte boundary *)

      setDecompress (VAR params: DcmpParams): BOOLEAN
                     RAISES {OSError.E, Thread.Alerted};
      (* set parameters for the decompression stream.  Returns actual width
         and height set by server in params.outX and params.outY.  Returns
         TRUE if parameters different from previous settings, otherwise
         returns FALSE and is a no-op *)

      colormap (VAR info: ColormapInfo): BOOLEAN
                RAISES {OSError.E, Thread.Alerted};
      (* tells the server to acquire &quot;ncolors&quot; colour cells for the
         colormap &quot;id&quot; in the X server &quot;displayName&quot; and fill them with the
         colours for the image stream.  Returns number of colours acutally
         allocated in info.ncolors.  Returns TRUE if settings different
         from previous, otherwise returns FALSE and is a no-op. *)

      (* &quot;close()&quot; now LL &lt; self *)
    END;

END Jvs.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
