<HTML>
<HEAD>
<TITLE>SRC Modula-3: jvideo/src/Jvs.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>jvideo/src/Jvs.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> note: SIGPIPE set to be ignored by JVSink 

<P><PRE>UNSAFE MODULE <module><implements><A HREF="Jvs.i3">Jvs</A></implements></module>;

IMPORT <A HREF="../../atom/src/Atom.i3">Atom</A>, <A HREF="../../libm3/derived/AtomList.i3">AtomList</A>, <A HREF="../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="Jv.i3">Jv</A>, <A HREF="JvsProtocol.i3">JvsProtocol</A>, <A HREF="../../C/src/Common/M3toC.i3">M3toC</A>, <A HREF="../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../geometry/src/Point.i3">Point</A>,
       <A HREF="../../runtime/src/common/RTMisc.i3">RTMisc</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        dparams                 := DefaultDecompress;
        cmap   : ColormapInfo;
      OVERRIDES
        init             := Init;
        allocateBuffer   := AllocateBuffer;
        deallocateBuffer := DeallocateBuffer;
        compress         := Compress;
        setCompress      := SetCompress;
        decompress       := Decompress;
        setDecompress    := SetDecompress;
        colormap         := Colormap;
        close            := Close;
      END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (t: T): T RAISES {OSError.E} =
  BEGIN
    TRY
      LOCK t DO RETURN Jv.T.init(t, JvsProtocol.PipeName); END;
    EXCEPT
    | OSError.E (e) =&gt; RAISE OSError.E(AtomList.Cons(Jv.ServerFailure, e));
    END;
  END Init;

PROCEDURE <A NAME="AllocateBuffer"><procedure>AllocateBuffer</procedure></A> (t: T; type: BufferType): ShmBufId
  RAISES {OSError.E, Thread.Alerted} =
  VAR
    req: JvsProtocol.AllocateReq;
    rep: JvsProtocol.AllocateRep;
  BEGIN
    TRY
      CASE type OF
      | BufferType.Compress =&gt;
          req.type := JvsProtocol.JPEG;
          req.width := 0;
          req.height := 0;
      | BufferType.Decompress =&gt;
          req.type := JvsProtocol.Dithered;
          req.width := 1280;
          req.height := 1024;
      END;
      req.direction := JvsProtocol.Output;
      LOCK t DO
        Jv.Send(t, ADR(req), BYTESIZE(req));
        Jv.Recv(t, ADR(rep), BYTESIZE(rep));
      END;
      IF rep.requestCode # req.requestCode THEN
        RAISE OSError.E(AtomList.List1(Atom.FromText(&quot;AllocateBuffer&quot;)));
      END;
    EXCEPT
    | OSError.E (e) =&gt; RAISE OSError.E(AtomList.Cons(Jv.ServerFailure, e));
    END;
    RETURN rep.shmid;
  END AllocateBuffer;

PROCEDURE <A NAME="DeallocateBuffer"><procedure>DeallocateBuffer</procedure></A> (t: T; shmid: ShmBufId)
  RAISES {OSError.E, Thread.Alerted} =
  VAR
    req: JvsProtocol.DeallocateReq;
    rep: JvsProtocol.DeallocateRep;
  BEGIN
    TRY
      req.shmid := shmid;
      LOCK t DO
        Jv.Send(t, ADR(req), BYTESIZE(req));
        Jv.Recv(t, ADR(rep), BYTESIZE(rep));
      END;
      IF rep.requestCode # req.requestCode THEN
        RAISE OSError.E(AtomList.List1(Atom.FromText(&quot;DeallocateBuffer&quot;)));
      END;
    EXCEPT
    | OSError.E (e) =&gt; RAISE OSError.E(AtomList.Cons(Jv.ServerFailure, e));
    END;
  END DeallocateBuffer;

PROCEDURE <A NAME="Compress"><procedure>Compress</procedure></A> (t: T; dest: ShmBufId): CARDINAL
  RAISES {OSError.E, Thread.Alerted} =
  VAR
    req: JvsProtocol.CompressReq;
    rep: JvsProtocol.CompressRep;
  BEGIN
    TRY
      req.shmid := dest;
      LOCK t DO
        Jv.Send(t, ADR(req), BYTESIZE(req));
        Jv.Recv(t, ADR(rep), BYTESIZE(rep));
      END;
      IF rep.requestCode # req.requestCode OR rep.shmid # req.shmid THEN
        RAISE OSError.E(AtomList.List1(Atom.FromText(&quot;Compress&quot;)));
      END;
      RETURN rep.length;
    EXCEPT
    | OSError.E (e) =&gt; RAISE OSError.E(AtomList.Cons(Jv.ServerFailure, e));
    END;
  END Compress;

PROCEDURE <A NAME="SetCompress"><procedure>SetCompress</procedure></A> (t: T; qfactor, xdec, ydec, frameskip: INTEGER):
  Point.T RAISES {OSError.E, Thread.Alerted} =
  VAR
    req: JvsProtocol.SetCompressReq;
    rep: JvsProtocol.SetCompressRep;
  BEGIN
    TRY
      req.qfactor := qfactor;
      req.xdec := xdec;
      req.ydec := ydec;
      req.frameskip := frameskip;
      LOCK t DO
        Jv.Send(t, ADR(req), BYTESIZE(req));
        Jv.Recv(t, ADR(rep), BYTESIZE(rep));
      END;
      IF rep.requestCode # req.requestCode THEN
        RAISE OSError.E(AtomList.List1(Atom.FromText(&quot;SetCompress&quot;)));
      END;
    EXCEPT
    | OSError.E (e) =&gt; RAISE OSError.E(AtomList.Cons(Jv.ServerFailure, e));
    END;
    RETURN Point.T{rep.width, rep.height};
  END SetCompress;

PROCEDURE <A NAME="Decompress"><procedure>Decompress</procedure></A> (t: T; src, dest: ShmBufId; srcByteLength: CARDINAL)
  RAISES {OSError.E, Thread.Alerted} =
  VAR
    req: JvsProtocol.DecompressReq;
    rep: JvsProtocol.DecompressRep;
  BEGIN
    TRY
      req.cshmid := src;
      req.dshmid := dest;
      req.length := srcByteLength;
      LOCK t DO
        Jv.Send(t, ADR(req), BYTESIZE(req));
        Jv.Recv(t, ADR(rep), BYTESIZE(rep));
      END;
      IF rep.requestCode # req.requestCode OR rep.cshmid # req.cshmid
           OR rep.dshmid # req.dshmid THEN
        RAISE OSError.E(AtomList.List1(DecompressFailure));
      END;
    EXCEPT
    | OSError.E (e) =&gt; RAISE OSError.E(AtomList.Cons(Jv.ServerFailure, e));
    END;
  END Decompress;
</PRE> the stuff for aligning the X axis is taken from Lance's JVideo.c code.
   He can explain it to you... 
<PRE>CONST
  DesiredRounding = 4;           (* 8 for an alpha *)

PROCEDURE <A NAME="SetDecompress"><procedure>SetDecompress</procedure></A> (t: T; VAR params: DcmpParams): BOOLEAN
  RAISES {OSError.E, Thread.Alerted} =
  VAR
    req         : JvsProtocol.SetDecompressReq;
    rep         : JvsProtocol.SetDecompressRep;
    roundedWidth: CARDINAL;
  BEGIN
    TRY
      LOCK t DO
        IF params = t.dparams THEN RETURN FALSE; END;

        req.qfactor := params.qfactor;
        req.inX := params.inX;
        req.inY := params.inY;
        req.outX := params.reqX;
        req.outY := params.reqY;
        req.brightness := params.brightness;
        req.contrast := params.contrast;
        req.saturation := params.saturation;

        LOOP
          Jv.Send(t, ADR(req), BYTESIZE(req));
          Jv.Recv(t, ADR(rep), BYTESIZE(rep));
          IF rep.requestCode # req.requestCode THEN
            RAISE
              OSError.E(AtomList.List1(Atom.FromText(&quot;SetDecompress&quot;)));
          END;
          roundedWidth := (((rep.actualOutX + rep.linePadding + 3) DIV 4) * 4);
          IF (roundedWidth MOD DesiredRounding) = 0 THEN EXIT; END;
          DEC(req.outX);
        END;

        params.outX := roundedWidth;
        params.outY := rep.actualOutY;
        t.dparams := params;
      END;
    EXCEPT
    | OSError.E (e) =&gt; RAISE OSError.E(AtomList.Cons(Jv.ServerFailure, e));
    END;
    RETURN TRUE;
  END SetDecompress;

CONST BoolToInt = ARRAY BOOLEAN OF Ctypes.int{0, 1};

PROCEDURE <A NAME="Colormap"><procedure>Colormap</procedure></A> (t: T; VAR info: ColormapInfo): BOOLEAN
  RAISES {OSError.E, Thread.Alerted} =
  VAR
    req   : JvsProtocol.ColormapReq;
    rep   : JvsProtocol.ColormapRep;
    length: CARDINAL;
  BEGIN
    TRY
      LOCK t DO
        WITH cmap = t.cmap DO
          IF cmap.id = info.id AND cmap.nColors = info.nColors
               AND cmap.monochrome = info.monochrome THEN
            RETURN FALSE;
          END;

          IF info.displayName # NIL THEN
            length := Text.Length(info.displayName);
            IF length &gt; JvsProtocol.MaxXServerNameLen - 1 THEN
              RAISE OSError.E(AtomList.List1(XNameTooLong));
            END;

            WITH string = M3toC.TtoS(info.displayName) DO
              RTMisc.Copy(string, ADR(req.serverName[0]), length + 1);
            END;
          ELSE
            RTMisc.Zero(ADR(req.serverName[0]), BYTESIZE(req.serverName));
          END;

          req.nColors := info.nColors;
          req.id := info.id;
          req.monochrome := BoolToInt[info.monochrome];

          Jv.Send(t, ADR(req), BYTESIZE(req));
          Jv.Recv(t, ADR(rep), BYTESIZE(rep));
          IF rep.requestCode # req.requestCode THEN
            RAISE OSError.E(AtomList.List1(Atom.FromText(&quot;Colormap&quot;)));
          END;
          info.nColors := rep.nColors;
          t.cmap := info;
        END;
      END;
    EXCEPT
    | OSError.E (e) =&gt; RAISE OSError.E(AtomList.Cons(Jv.ServerFailure, e));
    END;
    RETURN TRUE;
  END Colormap;

PROCEDURE <A NAME="Close"><procedure>Close</procedure></A> (t: T) =
  BEGIN
    LOCK t DO Jv.T.close(t); END;
  END Close;

BEGIN
  XNameTooLong := Atom.FromText(&quot;Jvs XNameTooLong&quot;);
  DecompressFailure := Atom.FromText(&quot;Decompress&quot;);
END Jvs.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
