<HTML>
<HEAD>
<TITLE>SRC Modula-3: jvideo/src/JvsBuffer.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>jvideo/src/JvsBuffer.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> subclass of JVBuffer which uses a Jvs.T to allocate shared memory
   buffers 

<P><PRE>INTERFACE <interface><A HREF="#x1">JvsBuffer</A></interface>;

IMPORT <A HREF="JVBuffer.i3">JVBuffer</A>, <A HREF="Jvs.i3">Jvs</A>, <A HREF="../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

TYPE T = JVBuffer.T;

TYPE
  <A HREF="#x2">Factory</A> &lt;: FactoryPublic;
  FactoryPublic = JVBuffer.Factory OBJECT
                  METHODS
                    init (jvs: Jvs.T; type: Jvs.BufferType): Factory;
                    (* the &quot;jvs&quot; is used to create shared memory buffers.
                       It should already have been opened *)

                    newBuf (): T;
                    (* this is called by &quot;make&quot; to create a new T.  It must
                       be overriden by the subclass *)
                  END;
</PRE> This is where we allocate shared memory buffers.  It turns out that the
   jvdriver doesn't deallocate them, so we should keep the ones we have on
   a free list.  In addition, there are only two sizes of shared memory
   buffer allocated: small (for compressed images) and large (for
   decompressed images).  Note that the shared memory images last as long
   as the connection to the server which was used to create them, so do not
   break the connection while still using the memory buffers. 

<P><PRE>PROCEDURE <A HREF="#x3">AllocateBuffer</A> (jvs: Jvs.T; type: Jvs.BufferType): Jvs.ShmBufId
  RAISES {OSError.E, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> find or create a shared memory buffer of the given buffer type and
   return its id. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x4">FreeBuffer</A> (type: Jvs.BufferType; id: Jvs.ShmBufId);
</PRE><BLOCKQUOTE><EM> we are no longer using the shared memory buffer </EM></BLOCKQUOTE><PRE>

VAR
  shmNotAttached: OSError.Code;

PROCEDURE <A HREF="#x5">BufferAddress</A> (id: Jvs.ShmBufId): ADDRESS RAISES {OSError.E};
</PRE><BLOCKQUOTE><EM> to avoid multiple attachements to the same shared memory buffer, we do
   the attach in /AllocateBuffer/.  This procedure returns that address for
   shared memory segments acquired from /AllocateBuffer/.  Raises OSError.E
   if the shared memory segment has not been attached </EM></BLOCKQUOTE><PRE>

END JvsBuffer.
</PRE>
</inInterface>
<HR>
<A NAME="x1">JvsBuffer's implementation  is in:
</A><UL>
<LI><A HREF="generic/JvsBuffer.m3#0TOP0">jvideo/src/generic/JvsBuffer.m3</A>
<LI><A HREF="osf1/JvsBuffer.m3#0TOP0">jvideo/src/osf1/JvsBuffer.m3</A>
<LI><A HREF="ultrix/JvsBuffer.m3#0TOP0">jvideo/src/ultrix/JvsBuffer.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">opaque type JvsBuffer.Factory is in:
</A><UL>
<LI><A HREF="generic/JvsBuffer.m3#Factory">jvideo/src/generic/JvsBuffer.m3</A>
<LI><A HREF="osf1/JvsBuffer.m3#Factory">jvideo/src/osf1/JvsBuffer.m3</A>
<LI><A HREF="ultrix/JvsBuffer.m3#Factory">jvideo/src/ultrix/JvsBuffer.m3</A>
</UL>
<P>
<HR>
<A NAME="x3">procedure JvsBuffer.AllocateBuffer is in:
</A><UL>
<LI><A HREF="generic/JvsBuffer.m3#AllocateBuffer">jvideo/src/generic/JvsBuffer.m3</A>
<LI><A HREF="osf1/JvsBuffer.m3#AllocateBuffer">jvideo/src/osf1/JvsBuffer.m3</A>
<LI><A HREF="ultrix/JvsBuffer.m3#AllocateBuffer">jvideo/src/ultrix/JvsBuffer.m3</A>
</UL>
<P>
<HR>
<A NAME="x4">procedure JvsBuffer.FreeBuffer is in:
</A><UL>
<LI><A HREF="generic/JvsBuffer.m3#FreeBuffer">jvideo/src/generic/JvsBuffer.m3</A>
<LI><A HREF="osf1/JvsBuffer.m3#FreeBuffer">jvideo/src/osf1/JvsBuffer.m3</A>
<LI><A HREF="ultrix/JvsBuffer.m3#FreeBuffer">jvideo/src/ultrix/JvsBuffer.m3</A>
</UL>
<P>
<HR>
<A NAME="x5">procedure JvsBuffer.BufferAddress is in:
</A><UL>
<LI><A HREF="generic/JvsBuffer.m3#BufferAddress">jvideo/src/generic/JvsBuffer.m3</A>
<LI><A HREF="osf1/JvsBuffer.m3#BufferAddress">jvideo/src/osf1/JvsBuffer.m3</A>
<LI><A HREF="ultrix/JvsBuffer.m3#BufferAddress">jvideo/src/ultrix/JvsBuffer.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
