<HTML>
<HEAD>
<TITLE>SRC Modula-3: jvideo/src/generic/Jv.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>jvideo/src/generic/Jv.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

UNSAFE MODULE <module><implements><A HREF="../Jv.i3">Jv</A></implements></module>;

IMPORT <A HREF="../../../atom/src/Atom.i3">Atom</A>, <A HREF="../../../libm3/derived/AtomList.i3">AtomList</A>, <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="../../../os/src/POSIX/FilePosix.i3">FilePosix</A>, <A HREF="../../../rw/src/Common/FileRd.i3">FileRd</A>, <A HREF="../../../rw/src/Common/FileWr.i3">FileWr</A>, <A HREF="../../../C/src/Common/M3toC.i3">M3toC</A>,
       <A HREF="../../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../../os/src/POSIX/OSErrorPosix.i3">OSErrorPosix</A>, <A HREF="../../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../../runtime/src/common/RTMisc.i3">RTMisc</A>, <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../../rw/src/Common/Wr.i3">Wr</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        rd: Rd.T;
        wr: Wr.T;
      OVERRIDES
        init  := Init;
        close := Close;
      END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (t: T; pipeName: TEXT): T RAISES {OSError.E} =
  (* open Unix domain connection to server. *)
  BEGIN
    OSErrorPosix.Raise()
    RETURN NIL;
  END Init;

PROCEDURE <A NAME="Close"><procedure>Close</procedure></A> (t: T) =
  BEGIN
    TRY
      Wr.Close(t.wr);
      Rd.Close(t.rd);
    EXCEPT
    | Thread.Alerted, Wr.Failure, Rd.Failure =&gt; (* skip *)
    END;
  END Close;
</PRE> -- send and receiving stuff, assume BYTESIZE(CHAR) = byte -- 
<PRE>TYPE
  LongArrayPtr =
    UNTRACED REF
      ARRAY [0 .. ((LAST(CARDINAL) DIV BITSIZE(CHAR)) - 1)] OF CHAR;
</PRE><BLOCKQUOTE><EM> hack to get around type system.  The horrible formula for the length of
   the array gives the longest possible array </EM></BLOCKQUOTE><PRE>

PROCEDURE <A NAME="Send"><procedure>Send</procedure></A> (t: T; buf: ADDRESS; nbytes: CARDINAL)
  RAISES {OSError.E, Thread.Alerted} =
  BEGIN
    TRY
      WITH chars = LOOPHOLE(buf, LongArrayPtr) DO
        Wr.PutString(t.wr, SUBARRAY(chars^, 0, nbytes));
      END;
      Wr.Flush(t.wr);
    EXCEPT
    | Wr.Failure (e) =&gt;
        RAISE OSError.E(AtomList.Cons(Atom.FromText(&quot;Write&quot;), e));
    END;
  END Send;

PROCEDURE <A NAME="Recv"><procedure>Recv</procedure></A> (t: T; buf: ADDRESS; nbytes: CARDINAL)
  RAISES {OSError.E, Thread.Alerted} =
  VAR nchars: CARDINAL;
  BEGIN
    TRY
      WITH chars = LOOPHOLE(buf, LongArrayPtr) DO
        nchars := Rd.GetSub(t.rd, SUBARRAY(chars^, 0, nbytes));
      END;
      IF nchars &lt; nbytes THEN
        RAISE
          OSError.E(AtomList.List2(ServerFailure, Atom.FromText(&quot;Read&quot;)));
      END;
    EXCEPT
    | Rd.Failure (e) =&gt;
        RAISE OSError.E(AtomList.Cons(Atom.FromText(&quot;Read&quot;), e));
    END;
  END Recv;

BEGIN
  &lt;* ASSERT BYTESIZE(CHAR) = BYTESIZE(Ctypes.char) *&gt;
  (* dumb consistency check *)
  ServerFailure := Atom.FromText(&quot;Jv ServerFailure&quot;);

END Jv.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
