<HTML>
<HEAD>
<TITLE>SRC Modula-3: jvideo/src/ultrix/JvsBuffer.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>jvideo/src/ultrix/JvsBuffer.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

UNSAFE MODULE <module><implements><A HREF="../JvsBuffer.i3">JvsBuffer</A></implements></module>;

IMPORT <A HREF="../../../atom/src/Atom.i3">Atom</A>, <A HREF="../../../libm3/derived/AtomList.i3">AtomList</A>, <A HREF="../../../libm3/derived/IntRefTbl.i3">IntRefTbl</A>, <A HREF="../JVBuffer.i3">JVBuffer</A>, <A HREF="../Jvs.i3">Jvs</A>, <A HREF="../../../os/src/Common/OSError.i3">OSError</A>,
       <A HREF="../../../os/src/POSIX/OSErrorPosix.i3">OSErrorPosix</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="#x1">Ushm</A>;

REVEAL
  <A NAME="Factory">Factory</A> = FactoryPublic BRANDED OBJECT
              jvs : Jvs.T;
              type: Jvs.BufferType;
            OVERRIDES
              init    := Init;
              make    := Make;
              reset   := Reset;
              destroy := Destroy;
            END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (f: Factory; jvs: Jvs.T; type: Jvs.BufferType): Factory =
  BEGIN
    f.jvs := jvs;
    f.type := type;
    RETURN f;
  END Init;

PROCEDURE <A NAME="Make"><procedure>Make</procedure></A> (f: Factory): JVBuffer.T
  RAISES {Thread.Alerted, OSError.E} =
  BEGIN
    WITH res     = f.newBuf(),
         buffId  = AllocateBuffer(f.jvs, f.type),
         address = BufferAddress(buffId)          DO
      RETURN res.init(buffId, address);
    END;
  END Make;

PROCEDURE <A NAME="Reset"><procedure>Reset</procedure></A> (&lt;* UNUSED*&gt; f: Factory; &lt;* UNUSED *&gt; t: JVBuffer.T) =
  BEGIN
    (* dummy procedure *)
  END Reset;

PROCEDURE <A NAME="Destroy"><procedure>Destroy</procedure></A> (f: Factory; jv: JVBuffer.T) =
  BEGIN
    FreeBuffer(f.type, jv.shmid);
  END Destroy;
</PRE> jvdriver doesn't recognise Deallocate requests, it deallocates shm
   buffers when the client breaks the connection.  So we want to stash shm
   buffers here for reuse until the process dies 
<PRE>TYPE
  BuffElt = REF RECORD
                  id  : Jvs.ShmBufId;
                  next: BuffElt        := NIL;
                END;
  RefAddr = REF RECORD address: ADDRESS;  END;

VAR
  mutex     := NEW(MUTEX);
  lists     := ARRAY Jvs.BufferType OF BuffElt{NIL, NIL};
  addresses := NEW(IntRefTbl.Default).init(5);
</PRE><BLOCKQUOTE><EM> we only add to /addresses/, so we only need to lock writes, not reads.
   We also assume that shmids are not reused during the run of the
   program </EM></BLOCKQUOTE><PRE>

PROCEDURE <A NAME="AllocateBuffer"><procedure>AllocateBuffer</procedure></A> (jvs: Jvs.T; type: Jvs.BufferType): Jvs.ShmBufId
  RAISES {OSError.E, Thread.Alerted} =
  BEGIN
    LOCK mutex DO
      VAR head := lists[type];
      BEGIN
        IF head # NIL THEN lists[type] := head.next; RETURN head.id; END;
      END;
      (* otherwise we need to allocate a new one *)
      VAR
        id   := jvs.allocateBuffer(type);
        addr := LOOPHOLE(Ushm.shmat(id, NIL, 0), ADDRESS);
      BEGIN
        IF LOOPHOLE(addr, INTEGER) = -1 THEN
          OSErrorPosix.Raise();
        END;
        EVAL addresses.put(id, NEW(RefAddr, address := addr));
        RETURN id;
      END;
    END;
  END AllocateBuffer;

PROCEDURE <A NAME="FreeBuffer"><procedure>FreeBuffer</procedure></A> (type: Jvs.BufferType; id: Jvs.ShmBufId) =
  BEGIN
    LOCK mutex DO
      WITH new = NEW(BuffElt, id := id, next := lists[type]) DO
        lists[type] := new;
      END;
    END;
  END FreeBuffer;

PROCEDURE <A NAME="BufferAddress"><procedure>BufferAddress</procedure></A> (id: Jvs.ShmBufId): ADDRESS RAISES {OSError.E} =
  VAR ref: REFANY;
  BEGIN
    IF NOT addresses.get(id, ref) THEN
      RAISE OSError.E(shmNotAttached);
    END;
    RETURN NARROW(ref, RefAddr).address;
  END BufferAddress;

BEGIN
  shmNotAttached :=
    NEW(AtomList.T,
        head := Atom.FromText(&quot;JvsBuffer.SharedMem segment not attached&quot;));
END JvsBuffer.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Ushm is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Ushm.i3#0TOP0">unix/src/aix-3-2/Ushm.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Ushm.i3#0TOP0">unix/src/aix-ps2-1-2/Ushm.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Ushm.i3#0TOP0">unix/src/freebsd-1/Ushm.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Ushm.i3#0TOP0">unix/src/freebsd-2/Ushm.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Ushm.i3#0TOP0">unix/src/hpux-7-0/Ushm.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Ushm.i3#0TOP0">unix/src/ibm-4-3/Ushm.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Ushm.i3#0TOP0">unix/src/irix-5.2/Ushm.i3</A>
<LI><A HREF="../../../unix/src/linux/Ushm.i3#0TOP0">unix/src/linux/Ushm.i3</A>
<LI><A HREF="../../../unix/src/osf-1.generic/Ushm.i3#0TOP0">unix/src/osf-1.generic/Ushm.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Ushm.i3#0TOP0">unix/src/solaris-2-x/Ushm.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Ushm.i3#0TOP0">unix/src/sunos-4-x/Ushm.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Ushm.i3#0TOP0">unix/src/sysv-4.0/Ushm.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.AP3000/Ushm.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Ushm.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.ARM/Ushm.i3#0TOP0">unix/src/ultrix-3-1.ARM/Ushm.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.DS3100/Ushm.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Ushm.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.NEXT/Ushm.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Ushm.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SEQUENT/Ushm.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Ushm.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN3/Ushm.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Ushm.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN386/Ushm.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Ushm.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.UMAX/Ushm.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Ushm.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.VAX/Ushm.i3#0TOP0">unix/src/ultrix-3-1.VAX/Ushm.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
