<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/AnchorSplit.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/AnchorSplit.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;
&lt;* PRAGMA SUBTYPE *&gt;
</PRE> An <CODE>AnchorSplit</CODE> is a multi-split version of <CODE>AnchorBtnVBT</CODE>.
   The first child is the {\em anchor} that is displayed (such
   as a text string or an icon).  The second child is the {\em
   menu} that is displayed when the anchor is activated.  Attempts
   to give an anchor-split more than two children cause the extra
   children to be lost.
<P>
   At initialization time, the feedback for the anchor is
   specified.  It must be a childless multi-filter.  Also at
   initialization time, a frame is specified that will surround
   the menu.  The frame is also a childless multi-filter. 

<P><PRE>INTERFACE <interface><A HREF="AnchorSplit.m3">AnchorSplit</A></interface>;

IMPORT <A HREF="../../ui/src/split/AnchorBtnVBT.i3">AnchorBtnVBT</A>, <A HREF="FeedbackVBT.i3">FeedbackVBT</A>, <A HREF="MultiFilter.i3">MultiFilter</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

TYPE
  &lt;* SUBTYPE T &lt;: MultiSplit.T *&gt;
  <A HREF="AnchorSplit.m3#T">T</A> &lt;: Public;
  Public = AnchorBtnVBT.T OBJECT
           METHODS
             &lt;* LL &lt;= VBT.mu *&gt;
             init (f           : FeedbackVBT.T;
                   menuFrame   : MultiFilter.T;
                   n           : CARDINAL        := 0;
                   anchorParent: VBT.T           := NIL;
                   hfudge                        := 0.0;
                   vfudge                        := 0.0  ): T;
           END;
</PRE> The call <CODE>v.init(...)</CODE> initializes <CODE>v</CODE> as an <CODE>AnchorSplit</CODE>.
   The feedback <CODE>f</CODE> and the multi-filter <CODE>menuFrame</CODE> must have no
   multi-children.  That is, calling <CODE>MultiFilter.Child(f)</CODE> and
   <CODE>MultiFilter.Child(menuFrame)</CODE> must both return <CODE>NIL</CODE>.  The
   other parameters, <CODE>n</CODE>, <CODE>anchorParent</CODE>, <CODE>hfudge</CODE>, and <CODE>vfudge</CODE>
   are the same as in <CODE>AnchorBtnVBT</CODE>. 

<P>
<P><PRE>END AnchorSplit.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
