<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/AnchorSplit.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/AnchorSplit.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="AnchorSplit.i3">AnchorSplit</A></implements></module>;

IMPORT <A HREF="../../ui/src/split/AnchorBtnVBT.i3">AnchorBtnVBT</A>, <A HREF="FeedbackVBT.i3">FeedbackVBT</A>, <A HREF="../../ui/src/split/Filter.i3">Filter</A>, <A HREF="MultiClass.i3">MultiClass</A>,
       <A HREF="MultiFilter.i3">MultiFilter</A>, <A HREF="SwitchVBT.i3">SwitchVBT</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;
</PRE> The first child (anchor) is MultiFilter.Child (Filter.Child (v)).
   The second child (menu)  is MultiFilter.Child (v.menu).


<P><PRE>REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
      METHODS
        getAnchorChild (): VBT.T   := GetAnchorChild;
        setAnchorChild (ch: VBT.T) := SetAnchorChild;
        getMenuChild   (): VBT.T   := GetMenuChild;
        setMenuChild   (ch: VBT.T) := SetMenuChild;
      OVERRIDES
        init   := Init;
        pre    := SwitchVBT.Pre;
        post   := SwitchVBT.Post;
        cancel := SwitchVBT.Cancel;
      END;

TYPE
  MC = MultiClass.Split OBJECT
    OVERRIDES
      replace := Replace;
      insert  := Insert;
      succ    := Succ;
    END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v             : T;
                feedback      : FeedbackVBT.T;
                menuFrame     : MultiFilter.T;
                n             : CARDINAL        := 0;
                anchorParent  : VBT.T           := NIL;
                hfudge, vfudge                  := 0.0  ): T =
  BEGIN
    &lt;* ASSERT MultiFilter.Child (feedback) = NIL *&gt;
    &lt;* ASSERT MultiFilter.Child (menuFrame) = NIL *&gt;
    EVAL AnchorBtnVBT.T.init (
           v, feedback, menuFrame, n, anchorParent, hfudge, vfudge);
    MultiClass.Be (v, NEW (MC));
    RETURN v
  END Init;

PROCEDURE <A NAME="GetAnchorChild"><procedure>GetAnchorChild</procedure></A> (v: T): VBT.T =
  BEGIN
    RETURN MultiFilter.Child (Filter.Child (v))
  END GetAnchorChild;

PROCEDURE <A NAME="SetAnchorChild"><procedure>SetAnchorChild</procedure></A> (v: T; ch: VBT.T) =
  BEGIN
    EVAL MultiFilter.Replace (Filter.Child (v), ch)
  END SetAnchorChild;

PROCEDURE <A NAME="GetMenuChild"><procedure>GetMenuChild</procedure></A> (v: T): VBT.T =
  BEGIN
    RETURN MultiFilter.Child (v.menu)
  END GetMenuChild;

PROCEDURE <A NAME="SetMenuChild"><procedure>SetMenuChild</procedure></A> (v: T; ch: VBT.T) =
  BEGIN
    EVAL MultiFilter.Replace (v.menu, ch)
  END SetMenuChild;

PROCEDURE <A NAME="Insert"><procedure>Insert</procedure></A> (m: MC; pred, ch: VBT.T) =
  VAR v: T := m.vbt;
  BEGIN
    IF pred = NIL THEN
      v.setAnchorChild (ch)
    ELSIF pred = v.getAnchorChild () THEN
      IF v.getMenuChild () = NIL THEN
        v.setMenuChild (ch)
      ELSE
        v.setAnchorChild (ch)    (* See Trestle Ref Man, p.  46 *)
      END
    ELSE
      v.setMenuChild (ch)        (* See Trestle Ref Man, p.  46 *)
    END
  END Insert;

PROCEDURE <A NAME="Replace"><procedure>Replace</procedure></A> (m: MC; ch, new: VBT.T) =
  VAR v: T := m.vbt;
  BEGIN
    IF ch = NIL THEN             &lt;* ASSERT FALSE *&gt;
    ELSIF ch = v.getAnchorChild () THEN
      v.setAnchorChild (new)
    ELSIF ch = v.getMenuChild () THEN
      v.setMenuChild (new)
    ELSE                         &lt;* ASSERT FALSE *&gt;
    END
  END Replace;

PROCEDURE <A NAME="Succ"><procedure>Succ</procedure></A> (m: MC; ch: VBT.T): VBT.T =
  VAR v: T := m.vbt;
  BEGIN
    IF ch = NIL THEN
      RETURN v.getAnchorChild ()
    ELSIF ch = v.getAnchorChild () THEN
      RETURN v.getMenuChild ()
    ELSIF ch = v.getMenuChild () THEN
      RETURN NIL
    ELSE                         &lt;* ASSERT FALSE *&gt;
    END
  END Succ;

BEGIN
END AnchorSplit.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
