<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/BiFeedbackVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/BiFeedbackVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="BiFeedbackVBT.i3">BiFeedbackVBT</A></implements></module>;

IMPORT <A HREF="FeedbackVBT.i3">FeedbackVBT</A>, <A HREF="../../ui/src/split/Filter.i3">Filter</A>, <A HREF="MultiClass.i3">MultiClass</A>, <A HREF="MultiFilter.i3">MultiFilter</A>, <A HREF="MultiSplit.i3">MultiSplit</A>,
       <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
      OVERRIDES
        init    := Init;
        normal  := Normal;
        excited := Excited;
      END;

TYPE
  MC = MultiClass.Filter OBJECT
       OVERRIDES
         pred    := Succ;
         succ    := Succ;
         replace := Replace;
       END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v: T; f1, f2: FeedbackVBT.T; ch: VBT.T): T =
  BEGIN
    &lt;* ASSERT MultiFilter.Child(f1) = NIL *&gt;
    &lt;* ASSERT MultiFilter.Child(f2) = NIL *&gt;
    EVAL MultiFilter.Replace(f2, ch);
    EVAL MultiFilter.Replace(f1, f2);
    EVAL FeedbackVBT.T.init(v, f1);
    MultiClass.Be(v, NEW(MC));
    IF ch # NIL THEN MultiClass.BeChild(v, ch) END;
    FeedbackVBT.Normal(v);
    RETURN v
  END Init;

PROCEDURE <A NAME="Normal"><procedure>Normal</procedure></A> (v: T) =
  VAR
    f1: FeedbackVBT.T := Filter.Child(v);
    f2: FeedbackVBT.T := MultiFilter.Child(f1);
  BEGIN
    FeedbackVBT.SetState(f1, FeedbackVBT.GetState(v));
    FeedbackVBT.Normal(f1);
    FeedbackVBT.SetState(f2, FeedbackVBT.GetState(v));
    FeedbackVBT.Normal(f2)
  END Normal;

PROCEDURE <A NAME="Excited"><procedure>Excited</procedure></A> (v: T) =
  VAR
    f1: FeedbackVBT.T := Filter.Child(v);
    f2: FeedbackVBT.T := MultiFilter.Child(f1);
  BEGIN
    FeedbackVBT.SetState(f1, FeedbackVBT.GetState(v));
    FeedbackVBT.Excited(f1);
    FeedbackVBT.SetState(f2, FeedbackVBT.GetState(v));
    FeedbackVBT.Excited(f2)
  END Excited;

PROCEDURE <A NAME="Replace"><procedure>Replace</procedure></A> (m: MC; &lt;* UNUSED *&gt; ch: VBT.T; new: VBT.T) =
  VAR
    v : T             := m.vbt;
    f1: FeedbackVBT.T := Filter.Child(v);
    f2: FeedbackVBT.T := MultiFilter.Child(f1);
  BEGIN
    EVAL MultiFilter.Replace(f2, new);
  END Replace;

PROCEDURE <A NAME="Succ"><procedure>Succ</procedure></A> (m: MC; ch: VBT.T): VBT.T =
  &lt;* FATAL MultiSplit.NotAChild *&gt;
  VAR
    v : T             := m.vbt;
    f1: FeedbackVBT.T := Filter.Child(v);
    f2: FeedbackVBT.T := MultiFilter.Child(f1);
  BEGIN
    IF ch = NIL THEN
      RETURN MultiSplit.Succ(f2, ch)
    ELSE
      RETURN NIL
    END
  END Succ;

BEGIN
END BiFeedbackVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
