<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/BooleanVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/BooleanVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="BooleanVBT.i3">BooleanVBT</A></implements></module>;

IMPORT <A HREF="../../ui/src/split/ButtonVBT.i3">ButtonVBT</A>, <A HREF="FeedbackVBT.i3">FeedbackVBT</A>, <A HREF="../../ui/src/split/Filter.i3">Filter</A>, <A HREF="../../ui/src/split/HighlightVBT.i3">HighlightVBT</A>, <A HREF="MultiClass.i3">MultiClass</A>,
       <A HREF="MultiFilter.i3">MultiFilter</A>, <A HREF="MultiSplit.i3">MultiSplit</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
      OVERRIDES
        init := Init;
        callback := Callback;
      END;

TYPE
  MC = MultiClass.Filter OBJECT
       OVERRIDES
         replace := Replace;
         succ    := Succ
       END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v: T; btn: ButtonVBT.T): T =
  BEGIN
    EVAL HighlightVBT.T.init(v, btn);
    (* Wipe out the Action on the button. *)
    btn.action := Action;
    MultiClass.Be(v, NEW(MC));
    WITH ch = MultiFilter.Child(btn) DO
      IF ch # NIL THEN MultiClass.BeChild(v, ch) END
    END;
    RETURN v
  END Init;

PROCEDURE <A NAME="Callback"><procedure>Callback</procedure></A> (&lt;* UNUSED *&gt;          v : T;
                    &lt;* UNUSED *&gt; READONLY cd: VBT.MouseRec) =
  BEGIN
  END Callback;

PROCEDURE <A NAME="Action"><procedure>Action</procedure></A> (btn: ButtonVBT.T; READONLY cd: VBT.MouseRec) =
  BEGIN
    WITH f = Filter.Child(btn) DO
      FeedbackVBT.SetState(f, NOT FeedbackVBT.GetState(f));
    END;
    NARROW(VBT.Parent(btn), T).callback(cd);
  END Action;

PROCEDURE <A NAME="Put"><procedure>Put</procedure></A> (v: T; state: BOOLEAN) =
  BEGIN
    WITH btn = Filter.Child(v),
         f   = Filter.Child(btn)   DO
      FeedbackVBT.SetState(f, state)
    END
  END Put;

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A> (v: T): BOOLEAN =
  BEGIN
    WITH btn = Filter.Child(v),
         f   = Filter.Child(btn)   DO
      RETURN FeedbackVBT.GetState(f)
    END
  END Get;

PROCEDURE <A NAME="Replace"><procedure>Replace</procedure></A> (m: MC; &lt;* UNUSED *&gt; ch: VBT.T; new: VBT.T) =
  BEGIN
    WITH v   = NARROW(m.vbt, T),
         btn = Filter.Child(v) DO
      EVAL MultiFilter.Replace(btn, new)
    END
  END Replace;

PROCEDURE <A NAME="Succ"><procedure>Succ</procedure></A> (m: MC; ch: VBT.T): VBT.T =
  &lt;* FATAL MultiSplit.NotAChild *&gt;
  BEGIN
    WITH v   = NARROW(m.vbt, T),
         btn = Filter.Child(v) DO
      RETURN MultiSplit.Succ(btn, ch)
    END
  END Succ;

BEGIN
END BooleanVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
