<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/BorderedFeedbackVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/BorderedFeedbackVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="BorderedFeedbackVBT.i3">BorderedFeedbackVBT</A></implements></module>;

IMPORT <A HREF="../../ui/src/split/BorderedVBT.i3">BorderedVBT</A>, <A HREF="FeedbackVBT.i3">FeedbackVBT</A>, <A HREF="../../ui/src/split/Filter.i3">Filter</A>, <A HREF="../../ui/src/split/HighlightVBT.i3">HighlightVBT</A>, <A HREF="MultiClass.i3">MultiClass</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>,
       <A HREF="../../ui/src/vbt/Pixmap.i3">Pixmap</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../ui/src/split/TranslateVBT.i3">TranslateVBT</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        hl: HighlightVBT.T;
      OVERRIDES
        init    := Init;
        normal  := Normal;
        excited := Excited;
      END;

TYPE
  MC = MultiClass.Filter BRANDED OBJECT
       OVERRIDES
         succ    := Succ;
         pred    := Succ;
         replace := Replace;
       END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v: T; ch: VBT.T; size := 2.0; op := PaintOp.BgFg):
  T =
  BEGIN
    v.hl := HighlightVBT.New(ch);
    EVAL FeedbackVBT.T.init(v, TranslateVBT.New(v.hl));
    MultiClass.Be(v, NEW(MC));
    IF ch # NIL THEN MultiClass.BeChild(v, ch) END;
    FeedbackVBT.Normal(v);
    RETURN v
  END Init;

PROCEDURE <A NAME="Normal"><procedure>Normal</procedure></A> (v: T) =
  VAR pm: Pixmap.T;
  BEGIN
    IF FeedbackVBT.GetState(v) THEN
      HighlightVBT.SetTexture(v.hl, Pixmap.Solid);
      HighlightVBT.SetRect(v.hl, Rect.Full, LAST(CARDINAL))
    ELSE
      HighlightVBT.SetRect(v.hl, Rect.Empty, 0)
    END
  END Normal;

PROCEDURE <A NAME="Excited"><procedure>Excited</procedure></A> (v: T) =
  BEGIN
    HighlightVBT.SetTexture(v.hl, Pixmap.Gray);
    HighlightVBT.SetRect(v.hl, Rect.Full, LAST(CARDINAL))
  END Excited;

PROCEDURE <A NAME="Replace"><procedure>Replace</procedure></A> (m: MC; &lt;* UNUSED *&gt; ch: VBT.T; new: VBT.T) =
  BEGIN
    EVAL Filter.Replace(NARROW(m.vbt, T).hl, new)
  END Replace;

PROCEDURE <A NAME="Succ"><procedure>Succ</procedure></A> (m: MC; ch: VBT.T): VBT.T =
  BEGIN
    IF ch = NIL THEN
      RETURN Filter.Child(NARROW(m.vbt, T).hl)
    ELSE
      RETURN NIL
    END
  END Succ;

BEGIN
END BorderedFeedbackVBT.
</PRE> <P>
MODULE BorderedFeedbackVBT;
<P>
IMPORT BorderedVBT, FeedbackVBT, Filter, MultiClass, PaintOp,
       Pixmap, VBT;
<P>
REVEAL
  T = Public BRANDED OBJECT
        op: PaintOp.T
      OVERRIDES
        init    := Init;
        normal  := Normal;
        excited := Excited;
      END;
<P>
TYPE
  MC = MultiClass.Filter BRANDED OBJECT
       OVERRIDES
         succ    := Succ;
         pred    := Succ;
         replace := Replace;
       END;
<P>
PROCEDURE Init (v: T; ch: VBT.T; size := 2.0; op := PaintOp.BgFg):
  T =
  BEGIN
    EVAL FeedbackVBT.T.init(
           v, BorderedVBT.New(ch, size, op, Pixmap.Solid));
    v.op := op;
    MultiClass.Be(v, NEW(MC));
    IF ch # NIL THEN MultiClass.BeChild(v, ch) END;
    FeedbackVBT.Normal(v);
    RETURN v
  END Init;
<P>
PROCEDURE Normal (v: T) =
  VAR pm: Pixmap.T;
  BEGIN
    IF FeedbackVBT.GetState(v) THEN
      pm := Pixmap.Solid;
    ELSE
      pm := Pixmap.Empty;
    END;
    BorderedVBT.SetColor(Filter.Child(v), v.op, pm)
  END Normal;
<P>
PROCEDURE Excited (v: T) =
  BEGIN
    BorderedVBT.SetColor(Filter.Child(v), v.op, Pixmap.Gray);
  END Excited;
<P>
PROCEDURE Replace (m: MC; &lt;* UNUSED *&gt; ch: VBT.T; new: VBT.T) =
  BEGIN
    WITH feedback = m.vbt,
         shadow   = Filter.Child(feedback) DO
      EVAL Filter.Replace(shadow, new)
    END
  END Replace;
<P>
PROCEDURE Succ (m: MC; ch: VBT.T): VBT.T =
  BEGIN
    WITH feedback = m.vbt,
         shadow   = Filter.Child(feedback) DO
      IF ch = NIL THEN
        RETURN Filter.Child(shadow)
      ELSE
        RETURN NIL
      END
    END
  END Succ;
<P>
BEGIN
END BorderedFeedbackVBT.
<P>


</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
