<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/ChoiceVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/ChoiceVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;
&lt;* PRAGMA SUBTYPE *&gt;
</PRE> A <CODE>ChoiceVBT</CODE> multi-filter behaves in concert with other
   <CODE>ChoiceVBT</CODE>s to implement {\em radio buttons}. Abstractly, a
   <CODE>ChoiceVBT</CODE> <CODE>v</CODE> consists of
<P>
<PRE>
      state(v)       TRUE <KBD>or</KBD> FALSE
      group(v)       <KBD>a set of </KBD>ChoiceVBT<KBD>s (the {\em radio group})</KBD>
</PRE>
  A group <CODE>g</CODE> consist of
<P>
<PRE>
      selection(g)   <KBD>the one member of </KBD>g<KBD> whose state is </KBD>TRUE<KBD>,</KBD>
                     <KBD>or </KBD>NIL<KBD> if there is no such member.</KBD>
</PRE>
   <CODE>state(v)</CODE> is defined as <CODE>v = selection (group (v))</CODE>.
<P>
   Structurally, a <CODE>ChoiceVBT</CODE> is identical to a <CODE>BooleanVBT</CODE>: it is a
   multi-filter that maintains a Boolean state for its VBT-child.  All
   events are forwarded to the VBT-child.
<P>
   When the <CODE>action</CODE> procedure of the button would normally be
   invoked, the value of the state of the <CODE>ChoiceVBT</CODE> is toggled and
   the <CODE>callback</CODE> method on the <CODE>ChoiceVBT</CODE> is invoked.
<P>
   The multi-child of a <CODE>ChoiceVBT</CODE> is defined to be the multi-child
   of the <CODE>ButtonVBT</CODE>. 

<P><PRE>INTERFACE <interface><A HREF="ChoiceVBT.m3">ChoiceVBT</A></interface>;

IMPORT <A HREF="BooleanVBT.i3">BooleanVBT</A>, <A HREF="../../ui/src/split/ButtonVBT.i3">ButtonVBT</A>;

TYPE
  &lt;* SUBTYPE T &lt;: MultiFilter.T *&gt;
  <A HREF="ChoiceVBT.m3#T">T</A> &lt;: Public;
  Public = BooleanVBT.T OBJECT
           METHODS
             &lt;* LL &lt;= VBT.mu *&gt;
             init (button: ButtonVBT.T; group: Group): T;
           END;
</PRE> The call <CODE>v.init(...)</CODE> initializes <CODE>v</CODE> as a <CODE>ChoiceVBT</CODE> with
   an initial state of <CODE>FALSE</CODE>. It is added to the radio group
   <CODE>group</CODE>. 

<P><PRE>TYPE <A HREF="ChoiceVBT.m3#Group">Group</A> &lt;: ROOT;
</PRE> A <CODE>Group</CODE> is a set of <CODE>ChoiceVBT</CODE>s.
<P>
   A <CODE>ChoiceVBT</CODE> <CODE>v</CODE> is added to a group when <CODE>v</CODE> is initialized.
   When <CODE>v</CODE> is discarded, it is removed from its group. 

<P><PRE>PROCEDURE <A HREF="ChoiceVBT.m3#Get">Get</A> (v: T): T;
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return <CODE>selection(group(v))</CODE> </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ChoiceVBT.m3#Put">Put</A> (v: T);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Equivalent to <CODE>selection(group(v)) := v</CODE> </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ChoiceVBT.m3#Clear">Clear</A> (v: T);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Equivalent to <CODE>selection(group(v)) := NIL</CODE> </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ChoiceVBT.m3#Selection">Selection</A> (group: Group): T;
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return <CODE>selection(group)</CODE> </EM></BLOCKQUOTE><PRE>

END ChoiceVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
