<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/ChoiceVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/ChoiceVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="ChoiceVBT.i3">ChoiceVBT</A></implements></module>;

IMPORT <A HREF="BooleanVBT.i3">BooleanVBT</A>, <A HREF="../../ui/src/split/ButtonVBT.i3">ButtonVBT</A>, <A HREF="../../ui/src/split/Filter.i3">Filter</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        group: Group
      OVERRIDES
        init    := Init;
        discard := Discard
      END;

REVEAL
  <A NAME="Group">Group</A> = MUTEX BRANDED OBJECT
            selection: T         := NIL;
            members  : RefList.T := NIL
          END;

TYPE Link = REF RECORD v: T END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v: T; btn: ButtonVBT.T; group: Group): T =
  BEGIN
    EVAL BooleanVBT.T.init (v, btn);
    VBT.PutProp (btn, NEW (Link, v := v));
    btn.action := Action;
    v.group := group;
    LOCK group DO group.members := RefList.Cons (v, group.members) END;
    RETURN v
  END Init;

PROCEDURE <A NAME="Discard"><procedure>Discard</procedure></A> (v: T) =
  PROCEDURE remove (VAR list: RefList.T) =
    BEGIN
      IF list = NIL THEN         (* skip *)
      ELSIF list.head = v THEN
        list := list.tail
      ELSE
        remove (list.tail)
      END
    END remove;
  BEGIN
    LOCK v.group DO
      remove (v.group.members);
      IF v.group.selection = v THEN v.group.selection := NIL END;
      v.group := NIL
    END;
    Filter.T.discard (v)
  END Discard;

PROCEDURE <A NAME="Action"><procedure>Action</procedure></A> (btn: ButtonVBT.T; READONLY cd: VBT.MouseRec) =
  VAR cl: Link := VBT.GetProp (btn, TYPECODE (Link));
  BEGIN
    Put (cl.v);
    cl.v.callback (cd)
  END Action;

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A> (v: T): T =
  BEGIN
    RETURN Selection (v.group)
  END Get;

PROCEDURE <A NAME="Put"><procedure>Put</procedure></A> (v: T) =
  BEGIN
    Select (v.group, v);
  END Put;

PROCEDURE <A NAME="Clear"><procedure>Clear</procedure></A> (v: T) =
  BEGIN
    Select (v.group, NIL);
  END Clear;

PROCEDURE <A NAME="Select"><procedure>Select</procedure></A> (group: Group; new: T) =
  VAR old := Selection (group);
  BEGIN
    IF old # NIL THEN BooleanVBT.Put (old, FALSE) END;
    LOCK group DO group.selection := new END;
    IF new # NIL THEN BooleanVBT.Put (new, TRUE) END
  END Select;

PROCEDURE <A NAME="Selection"><procedure>Selection</procedure></A> (group: Group): T =
  BEGIN
    LOCK group DO RETURN group.selection END
  END Selection;
</PRE> This procedure used to be exported, but I couldn't find any
   clients. No surprise. 
PROCEDURE Member (group: Group): T =
  BEGIN
    LOCK group DO
      IF group.memebrs = NIL THEN RETURN NIL END;
      RETURN group.members.head
    END
  END Member;


<P><PRE>BEGIN
END ChoiceVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
