<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/FeedbackVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/FeedbackVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;
</PRE> A <CODE>FeedbackVBT</CODE> is a filter that provides some visual feedback for
   its child.
<P>
   The essence of a <CODE>FeedbackVBT</CODE> are its <CODE>normal</CODE> and <CODE>excited</CODE>
   methods.  The <CODE>normal</CODE> method is intended for giving permanent
   feedback, whereas the <CODE>excited</CODE> method is used for displaying
   transitory feedback (e.g., while a button is pressed).  In
   addition, a feedback maintains a {\it state} flag to
   distinguish between an ``on'' and ``off'' state (e.g., for use
   by a <CODE>BooleanVBT</CODE>).
<P>
   Clients should not invoke a <CODE>FeedbackVBT</CODE>'s <CODE>normal</CODE> and
   <CODE>excited</CODE> methods directly.  Instead, use the procedures
   <CODE>Normal</CODE> and <CODE>Excited</CODE> in this interface.  The state of a
   <CODE>FeedbackVBT</CODE> is set using the <CODE>SetState</CODE> procedure; it is
   queried using the procedure <CODE>GetState</CODE>.
<P>
   The default <CODE>normal</CODE> and <CODE>excited</CODE> methods are no-ops.  A
   <CODE>FeedbackVBT</CODE> by itself is not very useful; subtypes are expected
   to override these methods with something useful.  Also, VBTkit
   switches that use <CODE>FeedbackVBT</CODE>s assume that the <CODE>FeedbackVBT</CODE> is a
   multi-filter, not simply a filter. 

<P><PRE>INTERFACE <interface><A HREF="FeedbackVBT.m3">FeedbackVBT</A></interface>;

IMPORT <A HREF="../../ui/src/split/Filter.i3">Filter</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

TYPE
  <A HREF="FeedbackVBT.m3#T">T</A> &lt;: Public;
  Public = Filter.T OBJECT
           METHODS
             &lt;* LL &lt;= VBT.mu *&gt;
             init (ch: VBT.T): T;
             &lt;* LL = VBT.mu *&gt;
             normal  ();
             excited ();
           END;
</PRE> The call <CODE>v.init(ch)</CODE> initializes <CODE>v</CODE> as a <CODE>FeedbackVBT</CODE>
   with VBT child <CODE>ch</CODE>.  The
   default <CODE>normal</CODE> and <CODE>excited</CODE> methods are no-ops. 

<P><PRE>PROCEDURE <A HREF="FeedbackVBT.m3#Normal">Normal</A> (v: T);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Invoke v's <CODE>normal</CODE> method. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FeedbackVBT.m3#Excited">Excited</A> (v: T);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Invoke v's <CODE>excited</CODE> method. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FeedbackVBT.m3#SetState">SetState</A> (v: T; state: BOOLEAN);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Record the <CODE>state</CODE> and then invoke whichever of <CODE>v</CODE>'s methods,
   <CODE>normal</CODE> or <CODE>excited</CODE>, was most recently invoked. If neither method
   has ever been invoked, the <CODE>normal</CODE> method is invoked. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FeedbackVBT.m3#GetState">GetState</A> (v: T): BOOLEAN;
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the value of the most recent call to <CODE>SetState</CODE>. 
   The initial state is <CODE>FALSE</CODE>. </EM></BLOCKQUOTE><PRE>

END FeedbackVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
