<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/FeedbackVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/FeedbackVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="FeedbackVBT.i3">FeedbackVBT</A></implements></module>;

IMPORT <A HREF="../../ui/src/split/Filter.i3">Filter</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

TYPE
  LastCall = {Normal, Excited};

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        last  := LastCall.Normal;
        state := FALSE;
      OVERRIDES
        init    := Init;
        normal  := Noop;
        excited := Noop;
        redisplay := Redisplay;
      END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v: T; ch: VBT.T): T =
  BEGIN
    RETURN Filter.T.init(v, ch);
  END Init;

PROCEDURE <A NAME="Noop"><procedure>Noop</procedure></A> (&lt;* UNUSED *&gt; v: T) =
  BEGIN
  END Noop;

PROCEDURE <A NAME="Redisplay"><procedure>Redisplay</procedure></A> (v: T) =
  BEGIN
    SetState(v, GetState(v))
  END Redisplay;

PROCEDURE <A NAME="SetState"><procedure>SetState</procedure></A> (v: T; state: BOOLEAN) =
  BEGIN
    IF v.state # state THEN
      v.state := state;
      IF v.last = LastCall.Normal THEN
        v.normal()
      ELSE
        v.excited()
      END
    END
  END SetState;

PROCEDURE <A NAME="GetState"><procedure>GetState</procedure></A> (v: T): BOOLEAN =
  BEGIN
    RETURN v.state
  END GetState;

PROCEDURE <A NAME="Normal"><procedure>Normal</procedure></A> (v: T) =
  BEGIN
    v.last := LastCall.Normal;
    v.normal()
  END Normal;

PROCEDURE <A NAME="Excited"><procedure>Excited</procedure></A> (v: T) =
  BEGIN
    v.last := LastCall.Excited;
    v.excited()
  END Excited;

BEGIN
END FeedbackVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
