<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/FileBrowserVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/FileBrowserVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;
</PRE> A <CODE>FileBrowserVBT</CODE> displays the files in a directory, and allows
   the user to traverse the file system and to select one or more
   files.  There are two additional widgets that can be associated
   with a <CODE>FileBrowserVBT</CODE>.  A {\em helper}
   \index{FBHelper}\label{FBHelper} is a type-in field that displays
   the pathname of the directory and allows the user to type new
   pathnames.  A {\em directory-menu}\index{FBDirMenu}
   \label{FBDirMenu} is a menu containing the names of each level in
   the directory tree, with the root at the bottom; you can go to any
   level in the tree by selecting the appropriate item in the menu.
<P>
   There are two user-actions, selecting and activating.
<P>
   \begin{itemize}
<P>
   \item The user may {\it select} items, either by single-clicking on
   an item to select just that one, or by single-clicking and dragging
   to select a range.  Shift-clicking adds to the selection.  A change
   in selection is reported to the client by invoking the
   <CODE>selectItems</CODE> method.  The client can read the current selection by
   calling <CODE>GetFile</CODE> or <CODE>GetFiles</CODE>.
<P>
   \item The user may {\it activate} an item, either by
   double-clicking on it, or by typing its name in the helper followed
   by Return.
<P>
   Activation of a {\it file} is reported to the client by invoking
   the <CODE>activateFile</CODE> method, whose default is a no-op.
<P>
   Activation of a {\it directory} is reported by invoking the
   <CODE>activateDir</CODE> method, whose default behavior is to call <CODE>Set</CODE> to
   display the activated directory.
<P>
   The client can distinguish between a double-click and Return by
   looking at the <CODE>AnyEvent.T</CODE> passed to the activation method.  A
   double-click will be reported as an <CODE>AnyEvent.Mouse</CODE>, and Return
   will be reported as an <CODE>AnyEvent.Key</CODE>.
<P>
   \end{itemize}
<P>
   Directories are indicated in the display by showing some text
   (e.g., ``(dir)'') after the name, but that is not part of the
   pathname returned by <CODE>getValue</CODE>, <CODE>GetFile</CODE>, <CODE>GetFiles</CODE>, or the
   value passed to <CODE>activateDir</CODE>.
<P>
   A background thread calls <CODE>Refresh(v)</CODE> for every open filebrowser
   <CODE>v</CODE>, once per second, to see whether it needs to be updated
   (although a distributed filesystem may cause a substantial delay
   before the change is noticed).
<P>
   <CODE>FileBrowserVBT</CODE> is internally synchronized.
<P>


<P><PRE>INTERFACE <interface><A HREF="FileBrowserVBT.m3">FileBrowserVBT</A></interface>;

IMPORT <A HREF="AnchorSplit.i3">AnchorSplit</A>, <A HREF="../../vbtkitutils/src/AnyEvent.i3">AnyEvent</A>, <A HREF="../../ui/src/vbt/Font.i3">Font</A>, <A HREF="ListVBT.i3">ListVBT</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>,
       <A HREF="../../os/src/Common/Pathname.i3">Pathname</A>, <A HREF="Shadow.i3">Shadow</A>, <A HREF="../../libm3/derived/TextList.i3">TextList</A>, <A HREF="../../etext/src/TypeinVBT.i3">TypeinVBT</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

TYPE
  <A HREF="FileBrowserVBT.m3#T">T</A> &lt;: Public;
  Public =
    ListVBT.T OBJECT
    METHODS
      &lt;* LL.sup &lt;= VBT.mu *&gt;
      init (font                      := Font.BuiltIn;
            colors: PaintOp.ColorQuad := NIL           ): T;
      &lt;* LL.sup = VBT.mu *&gt;
      selectItems  (event: AnyEvent.T);
      activateFile (filename: Pathname.T; event: AnyEvent.T);
      activateDir  (dirname : Pathname.T; event: AnyEvent.T);
      error        (err: E);
    END;
</PRE> The call <CODE>v.init(...)</CODE> initializes <CODE>v</CODE> as a <CODE>FileBrowserVBT</CODE>.  If
   <CODE>v.painter</CODE> is a subtype of <CODE>ListVBT.TextPainter</CODE>, <CODE>init</CODE> calls
   <CODE>v.paint.setFont(font)</CODE>.  The <CODE>selector</CODE> field must be either <CODE>NIL</CODE>
   (in which case a new selector is created) or a subtype of
   <CODE>FileBrowserVBT.Selector</CODE>.  The initial state of the filebrowser is
   the current working directory, as returned by
   <CODE>Process.GetWorkingDirectory</CODE>.
<P>
   The implementation calls <CODE>v.selectItems(event)</CODE> when the user
   changes the selection using the mouse.
<P>
   When the user double-clicks on a file in the browser, the
   implementation calls <CODE>v.activateFile(filename, event)</CODE>, where
   <CODE>filename</CODE> in the absolute pathname corresponding to the first selected
   item. If the user types Return in the helper, the implementation
   calls <CODE>v.activateFile(filename, event)</CODE>, where <CODE>filename</CODE>
   is either the pathname in the helper, if that was absolute, or
   absolute pathname corresponding to
<PRE>
      Pathname.Join (GetDir(v), 'helper text', NIL)
</PRE>
   Don't forget that if <CODE>activateFile</CODE> is being called because of a
   double-click, multiple files might be selected in the browser, even
   though you are given only one in the <CODE>filename</CODE> parameter.
<P>
   The implementation calls <CODE>v.activateDir(dir)</CODE> when a directory is
   activated.  The normal action is simply to set <CODE>v</CODE> to view that
   directory, relative to <CODE>GetDir(v)</CODE>.  If an error occurs during the
   activation, the <CODE>error</CODE> method is invoked.
<P>
   The implementation calls <CODE>v.error(...)</CODE> when an error occurs during
   user action in <CODE>v</CODE>, and the <CODE>Error</CODE> exception cannot be raised
   (e.g., because it happened in a separate thread).  Some examples of
   errors are as follows: the user has typed a nonexistent directory
   in the path; the current directory has become inaccessible; the
   user has no permission to read the directory.  The default method
   is a no-op.  By overriding this method, the client can provide
   better information to the user.
<P>
   The <CODE>error</CODE> method is passed an <CODE>E</CODE> object containing information
   about the error that occurred. Here is its definition: 

<P><PRE>EXCEPTION Error (E);
TYPE
  E = OBJECT
        v   : T;
        text: TEXT       := &quot;&quot;;
        path: Pathname.T := &quot;&quot;
      END;
</PRE><BLOCKQUOTE><EM> The argument to the <CODE>Error</CODE> exception includes the
   <CODE>FileBrowserVBT</CODE> itself, along with a descriptive message and
   the pathname in question when the error occurred. </EM></BLOCKQUOTE><PRE>
</PRE> Finally, if you create a subtype of <CODE>FileBrowserVBT</CODE> (which is a
   subtype of <CODE>ListVBT.T</CODE>) and you specify a selector for it, it
   must be a subtype of <CODE>Selector</CODE>: 

<P><PRE>TYPE <A HREF="FileBrowserVBT.m3#Selector">Selector</A> &lt;: ListVBT.MultiSelector;
</PRE> \subsubsection{The Helper} 
   <P>
   The FileBrowser's helper (see page \pageref{FBHelper}) is a
   <CODE>TypeinVBT</CODE>.  Once the user types in the helper, any selected items
   in the browser are unselected.  If the user types Return in the
   browser, that will activate the name in the Helper.
   <P>
   If an error occurs during the activation, the <CODE>error</CODE> method of the
   filebrowser to which the helper is attached will be invoked. 

<P><PRE>TYPE <A HREF="FileBrowserVBT.m3#Helper">Helper</A> &lt;: TypeinVBT.T;

PROCEDURE <A HREF="FileBrowserVBT.m3#SetHelper">SetHelper</A> (v: T; helper: Helper) RAISES {Error};
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Sets the helper for <CODE>v</CODE> to be <CODE>helper</CODE>, and fills it with
   <CODE>GetDir(v)</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> \subsubsection{The Directory-Menu} 

<P> The directory menu shows the name of each of the parent directories,
   going back to the root directory. 

<P><PRE>TYPE
  <A HREF="FileBrowserVBT.m3#DirMenu">DirMenu</A> &lt;: PublicDirMenu;
  PublicDirMenu =
    AnchorSplit.T OBJECT
    METHODS
      &lt;* LL.sup &lt;= VBT.mu *&gt;
      init (font             := Font.BuiltIn;
            shadow: Shadow.T := NIL;
            n     : CARDINAL := 0             ): DirMenu
    END;
</PRE> The <CODE>font</CODE> and <CODE>shadow</CODE> control the appearance of the text
   within the menu.  As usual, if <CODE>shadow</CODE> is <CODE>NIL</CODE>, then
   <CODE>Shadow.None</CODE> is used instead.  The parameter <CODE>n</CODE> is used by
   <CODE>AnchorSplit</CODE> to determine the <CODE>ZSplit</CODE> in which to install
   the menu. 

<P>
<P><PRE>PROCEDURE <A HREF="FileBrowserVBT.m3#SetDirMenu">SetDirMenu</A> (v: T; dm: DirMenu);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Sets the directory-menu of <CODE>v</CODE> to be <CODE>dm</CODE> and fill it with the
   current directory. </EM></BLOCKQUOTE><PRE>
</PRE> \subsubsection{FileBrowser options} 

<P> A file browser can be ``read-only'': 

<P><PRE>PROCEDURE <A HREF="FileBrowserVBT.m3#SetReadOnly">SetReadOnly</A> (v: T; readOnly: BOOLEAN);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Change the ``read-only'' mode of <CODE>v</CODE> to be <CODE>readOnly</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> If a file browser is ``read-only'' then in subsequent calls to
<PRE>
      v.activateFile(filename)
   <CODE></PRE>
filename</CODE> is guaranteed to exist.  Otherwise, the user can type the
   name of a non-existing file into the helper.  A newly initialized
   <CODE>FileBrowserVBT</CODE> is not read-only.
<P>
   By default all files in the directory are displayed, but the
   following procedure can be used to filter which files are
   shown: 

<P><PRE>PROCEDURE <A HREF="FileBrowserVBT.m3#SetSuffixes">SetSuffixes</A> (v: T; suffixes: TEXT);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Specify which <CODE>suffixes</CODE> are to be displayed. </EM></BLOCKQUOTE><PRE>
</PRE> If <CODE>suffixes</CODE> is not the empty string, only files with the
   specified suffixes (and all directories) will be displayed.
   The format of <CODE>suffixes</CODE> is a sequence of suffixes (not
   including the period) separated by non-alphanumeric characters
   (e.g., spaces).  The special suffix <CODE>$</CODE> indicates ``files with
   no suffix.''  Calling <CODE>SetSuffixes</CODE> procedure does not force
   <CODE>v</CODE> to be redisplayed. 

<P> \subsubsection{Setting the displayed directory} 

<P><PRE>PROCEDURE <A HREF="FileBrowserVBT.m3#Set">Set</A> (v       : T;
               pathname: Pathname.T;
               time    : VBT.TimeStamp := 0) RAISES {Error};
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Set the display state of v. </EM></BLOCKQUOTE><PRE>
</PRE> The <CODE>pathname</CODE> may be absolute or relative; if it's relative, it
   is relative to the current displayed directory.
<P>
   If <CODE>pathname</CODE> refers to a non-existent or inaccessible directory,
   <CODE>Error</CODE> will be raised.  The exception will also be raised if
   <CODE>pathname</CODE> refers to a non-existent file and <CODE>v</CODE> is read-only.
<P>
   If <CODE>time</CODE> is not zero and there is a helper, then the helper
   will take the keyboard focus and will display its new contents
   in replace-mode, ready for the user to type something in its
   place. 

<P><PRE>PROCEDURE <A HREF="FileBrowserVBT.m3#Unselect">Unselect</A> (v: T);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Put <CODE>v</CODE> into the no-selection state, without changing the
   current directory. Equivalent to <CODE>v.selectNone()</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FileBrowserVBT.m3#Refresh">Refresh</A> (v: T) RAISES {Error};
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Update the display without changing the directory.</EM></BLOCKQUOTE><PRE>
</PRE> If <CODE>v</CODE>'s domain is not empty, and its directory has been <CODE>Set</CODE>, and
   the directory has changed since the last time it was displayed,
   then <CODE>v</CODE> will be marked for redisplay.  <CODE>Error</CODE> is raised only if
   the directory has become inaccessible for some reason; in this
   case, the browser goes to the empty state, so that if the client
   catches <CODE>Error</CODE> and takes no other action, the browser will be
   empty but not broken. 

<P> \subsubsection{Retrieving selections from the browser} 

<P><PRE>PROCEDURE <A HREF="FileBrowserVBT.m3#GetFiles">GetFiles</A> (v: T): TextList.T RAISES {Error};
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the current selections of <CODE>v</CODE>, or <CODE>NIL</CODE> if there are no
   selections. The list includes ``full'' pathnames; they satisfy
   <CODE>Pathname.Absolute</CODE>, but they may contain symbolic links. Use
   <CODE>FS.GetAbsolutePathname</CODE> to get a pathname with no symbolic links.
   </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FileBrowserVBT.m3#GetFile">GetFile</A> (v: T): Pathname.T RAISES {Error};
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the first selection, or the empty string if there are no
   selections. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FileBrowserVBT.m3#GetDir">GetDir</A> (v: T): Pathname.T;
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the current displayed directory of <CODE>v</CODE>.  Returns an empty
   string if <CODE>v</CODE> is in the ``empty'' state. </EM></BLOCKQUOTE><PRE>

END FileBrowserVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
