<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/FileBrowserVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/FileBrowserVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL                                                                 *&gt;
&lt;* PRAGMA EXPORTED                                                           *&gt;

MODULE <module><implements><A HREF="FileBrowserVBT.i3">FileBrowserVBT</A></implements></module>;

IMPORT <A HREF="AnchorSplit.i3">AnchorSplit</A>, <A HREF="../../vbtkitutils/src/AnyEvent.i3">AnyEvent</A>, <A HREF="../../atom/src/Atom.i3">Atom</A>, <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../ui/src/split/BorderedVBT.i3">BorderedVBT</A>, <A HREF="../../ui/src/vbt/Cursor.i3">Cursor</A>, <A HREF="../../os/src/Common/File.i3">File</A>, <A HREF="../../ui/src/split/Filter.i3">Filter</A>,
       <A HREF="../../ui/src/vbt/Font.i3">Font</A>, <A HREF="../../os/src/Common/FS.i3">FS</A>, <A HREF="../../ui/src/split/HVSplit.i3">HVSplit</A>, <A HREF="../../etext/src/ISOChar.i3">ISOChar</A>, <A HREF="../../fmtlex/src/Lex.i3">Lex</A>, <A HREF="ListVBT.i3">ListVBT</A>, <A HREF="MenuSwitchVBT.i3">MenuSwitchVBT</A>, <A HREF="MultiFilter.i3">MultiFilter</A>,
       <A HREF="MultiSplit.i3">MultiSplit</A>, <A HREF="../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../os/src/Common/Pathname.i3">Pathname</A>, <A HREF="../../ui/src/vbt/Pixmap.i3">Pixmap</A>, <A HREF="../../os/src/Common/Process.i3">Process</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>,
       <A HREF="../../os/src/Common/RegularFile.i3">RegularFile</A>, <A HREF="Shadow.i3">Shadow</A>, <A HREF="ShadowedVBT.i3">ShadowedVBT</A>, <A HREF="ShadowedFeedbackVBT.i3">ShadowedFeedbackVBT</A>, <A HREF="../../ui/src/split/Split.i3">Split</A>, <A HREF="../../text/src/Text.i3">Text</A>,
       <A HREF="../../libm3/derived/TextList.i3">TextList</A>, <A HREF="../../libm3/derived/TextListSort.i3">TextListSort</A>, <A HREF="../../etext/src/TextPort.i3">TextPort</A>, <A HREF="../../rw/src/Common/TextRd.i3">TextRd</A>, <A HREF="../../ui/src/split/TextVBT.i3">TextVBT</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../time/src/Common/Time.i3">Time</A>,
       <A HREF="../../etext/src/TypeinVBT.i3">TypeinVBT</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../weakref/src/WeakRef.i3">WeakRef</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED &quot;FileBrowserVBT 4.0&quot; OBJECT
        mu: MUTEX;
        &lt;* LL = mu *&gt;
        helper  : Helper;
        dirmenu : DirMenu;
        suffixes: TextList.T;
        readOnly: BOOLEAN;
        dir     : Pathname.T;
        toSelect: TEXT; (* if non-empty/NIL, select this string *)
        truthInHelper: BOOLEAN;   (* where to look for the value *)
        time         : Time.T;  (* last time we looked at this directory *)
        statThread   : Thread.T;
        isDir        : REF ARRAY OF BOOLEAN
      OVERRIDES
        init         := Init;
        selectItems  := SelectItems; (* no-op *)
        activateFile := ActivateFile; (* no-op *)
        activateDir  := ActivateDir;
        error        := DefaultError; (* no-op *)
        insertCells  := InsertCells;
        removeCells  := RemoveCells;
        getValue     := GetValue;
      END;
  <A NAME="Selector">Selector</A> = ListVBT.MultiSelector BRANDED OBJECT
               v: T
             OVERRIDES
               insideClick := InsideClick
             END;
  <A NAME="Helper">Helper</A> = TypeinVBT.T BRANDED OBJECT
             parent: T;
           OVERRIDES
             returnAction := HelperReturn;
             modified     := HelperModified
           END;
  <A NAME="DirMenu">DirMenu</A> = PublicDirMenu BRANDED OBJECT
              font                       := Font.BuiltIn;
              shadow     : Shadow.T      := NIL; (* Shadow.None *)
              filebrowser: T;
              top        : TextVBT.T;
              vbox       : DirMenuVBox;
            OVERRIDES
              init := InitDirMenu
            END;

TYPE
  (* The feedback on the DirMenu button is a DirMenuTop.  Its multi-child is a
     TextVBT. *)
  DirMenuTop = ShadowedFeedbackVBT.T OBJECT dm: DirMenu END;

  (* Each item in the vbox (&quot;pathname component&quot;) is a DirMenuButton. *)
  DirMenuButton = MenuSwitchVBT.T OBJECT
                    dm: DirMenu
                  METHODS
                    init (text: TEXT): DirMenuButton := InitDirMenuButton;
                    put  (text: TEXT)                := DirMenuButtonPut;
                    get  (): TEXT                    := DirMenuButtonGet;
                  OVERRIDES
                    callback := DirMenuButtonCallback
                  END;

  (* The vbox of components needs to get its width from the DirMenu button. *)
  DirMenuVBox =
    HVSplit.T OBJECT dm: DirMenu OVERRIDES shape := DMVBoxShape END;

  (* We maintain a list of weak references to all initilialized filebrowsers,
     and we scan the list once a second, refreshing each one. *)
  FBList = REF RECORD
                 car: WeakRef.T;
                 cdr: FBList      := NIL
               END;

VAR
  tlock := NEW (MUTEX);
  &lt;* LL = tlock *&gt;
  fblist: FBList := NIL;
  fbcond         := NEW (Thread.Condition);
</PRE>***************************  Creation  **************************

<P><PRE>PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v     : T;
                font  : Font.T            := Font.BuiltIn;
                colors: PaintOp.ColorQuad := NIL           ): T =
  BEGIN
    IF colors = NIL THEN colors := Shadow.None END;
    v.mu := NEW (MUTEX);
    TRY
      LOCK v.mu DO
        TYPECASE v.selector OF
        | NULL =&gt; v.selector := NEW (Selector, v := v).init (v)
        | Selector (s) =&gt; s.v := v
        ELSE                     &lt;* ASSERT FALSE *&gt;
        END;
        EVAL ListVBT.T.init (v, colors);
        TYPECASE v.painter OF
        | ListVBT.TextPainter (tp) =&gt; tp.setFont (v, font)
        ELSE
        END;
        v.helper := NIL;
        v.dirmenu := NIL;
        v.suffixes := NIL;
        v.readOnly := FALSE;
        v.toSelect := &quot;&quot;;
        v.truthInHelper := FALSE;
        v.isDir := NEW (REF ARRAY OF BOOLEAN, 100);
        v.statThread := NIL;
        LOCK tlock DO
          fblist := NEW (FBList, car := WeakRef.FromRef (v), cdr := fblist);
          Thread.Signal (fbcond)
        END;
        v.dir := Process.GetWorkingDirectory ();
      END
    EXCEPT
    | OSError.E (code) =&gt; CallError (v, code); v.dir := &quot;&quot;
    END;
    RETURN v
  END Init;

PROCEDURE <A NAME="InsertCells"><procedure>InsertCells</procedure></A> (v: T; at: ListVBT.Cell; n: CARDINAL) =
  (* Insert the &quot;isDir&quot; bits, too. *)
  VAR
    count   := v.count ();
    first   := MAX (0, MIN (at, count));
    oldbits := v.isDir;
    oldsize := NUMBER (oldbits^);
  BEGIN
    Public.insertCells (v, at, n);
    IF n + count &gt; oldsize THEN
      v.isDir :=
        NEW (REF ARRAY OF BOOLEAN, MAX (n + count, oldsize + oldsize DIV 2));
      SUBARRAY (v.isDir^, 0, oldsize) := oldbits^
    END;
    SUBARRAY (v.isDir^, first + n, count - first) :=
      SUBARRAY (v.isDir^, first, count - first);
    FOR i := first TO first + n - 1 DO v.isDir [i] := FALSE END
  END InsertCells;

PROCEDURE <A NAME="RemoveCells"><procedure>RemoveCells</procedure></A> (v: T; at: ListVBT.Cell; n: CARDINAL) =
  (* Delete (shift) the &quot;isDir&quot; bits, too. *)
  VAR
    count  := v.count ();
    first  := MAX (0, MIN (at, count));
    amount := MIN (at + n, count) - first;
    k      := count - (first + amount);
  BEGIN
    Public.removeCells (v, at, n);
    IF amount &gt; 0 THEN
      SUBARRAY (v.isDir^, first, k) := SUBARRAY (v.isDir^, first + amount, k)
    END
  END RemoveCells;

PROCEDURE <A NAME="GetValue"><procedure>GetValue</procedure></A> (v: T; this: ListVBT.Cell): REFANY =
  (* Strip off the directory marker if this is a directory. *)
  VAR val: Pathname.T := Public.getValue (v, this);
  BEGIN
    IF v.isDir [this] THEN
      val := Text.Sub (val, 0, Text.Length (val) - DirMarkerLength)
    END;
    RETURN val
  END GetValue;

&lt;* EXPORTED *&gt;
PROCEDURE <A NAME="Refresh"><procedure>Refresh</procedure></A> (v: T) =
  &lt;* LL = {} *&gt;
  BEGIN
    LOCK v.mu DO
      IF VBT.Domain (v) = Rect.Empty THEN RETURN END;
      TRY
        IF FS.Status (v.dir).modificationTime &gt; v.time THEN DisplayDir (v) END
      EXCEPT
      | OSError.E (code) =&gt;
          v.dir := &quot;&quot;;
          v.removeCells (0, LAST (CARDINAL));
          CallError (v, code)
      END
    END
  END Refresh;

PROCEDURE <A NAME="Watcher"><procedure>Watcher</procedure></A> (&lt;* UNUSED *&gt; cl: Thread.Closure): REFANY =
  &lt;* LL = {} *&gt;
  (* This loops forever.  It waits until there are some filebrowsers, then it
     refreshes them all and sleeps for a second. *)
  VAR
    v   : T;
    list: FBList;
  BEGIN
    LOOP
      LOCK tlock DO
        WHILE fblist = NIL DO Thread.Wait (tlock, fbcond) END;
        list := fblist;
        v := WeakRef.ToRef (list.car);
        IF v = NIL THEN          (* The last one is gone. *)
          fblist := NIL
        ELSE
          Refresh (v);
          WHILE list.cdr # NIL DO (* Any more? *)
            v := WeakRef.ToRef (list.cdr.car);
            IF v = NIL THEN      (* It's gone. *)
              list.cdr := list.cdr.cdr (* (pop (cdr list)) *)
            ELSE
              list := list.cdr;  (* (pop list) *)
              Refresh (v)
            END                  (* IF *)
          END                    (* WHILE *)
        END                      (* IF *)
      END;                       (* LOCK *)
      Thread.Pause (1.0D0)
    END                          (* LOOP *)
  END Watcher;

&lt;* EXPORTED *&gt;
PROCEDURE <A NAME="SetHelper"><procedure>SetHelper</procedure></A> (v: T; helper: Helper) =
  BEGIN
    LOCK v.mu DO
      v.helper := helper;
      IF helper # NIL THEN helper.parent := v END
    END
  END SetHelper;

PROCEDURE <A NAME="InitDirMenu"><procedure>InitDirMenu</procedure></A> (dm    : DirMenu;
                       font  : Font.T    := Font.BuiltIn;
                       shadow: Shadow.T  := NIL; (* Shadow.None *)
                       n     : CARDINAL  := 0                      ):
  DirMenu =
  BEGIN
    IF shadow = NIL THEN shadow := Shadow.None END;
    dm.shadow := shadow;
    dm.font := font;
    dm.top := NEW (TextVBT.T).init (&quot;&quot;, fnt := font, bgFg := shadow);
    dm.vbox := NEW (DirMenuVBox, dm := dm).init (Axis.T.Ver);
    WITH feedback = NEW (DirMenuTop, dm := dm).init (NIL, shadow),
         menuFrame = NEW (ShadowedVBT.T).init (
                       NIL, shadow, Shadow.Style.Raised) DO
      EVAL AnchorSplit.T.init (dm, feedback, menuFrame, n);
      MultiSplit.AddChild (dm, dm.top);
      MultiSplit.AddChild (dm, dm.vbox);
      RETURN dm
    END
  END InitDirMenu;

PROCEDURE <A NAME="DMVBoxShape"><procedure>DMVBoxShape</procedure></A> (vbox: DirMenuVBox; ax: Axis.T; n: CARDINAL):
  VBT.SizeRange =
  BEGIN
    IF ax = Axis.T.Ver THEN
      RETURN HVSplit.T.shape (vbox, ax, n)
    ELSE                         (* Match the width of the top button. *)
      VAR
        op          : PaintOp.T;     (* UNUSED *)
        txt         : Pixmap.T;      (* UNUSED *)
        borderSizeMM: REAL;
        borderedVBT : BorderedVBT.T := VBT.Parent (vbox);
      BEGIN
        BorderedVBT.Get (borderedVBT, borderSizeMM, op, txt);
        WITH borderSizeRealPixels = VBT.MMToPixels (vbox, borderSizeMM, ax),
             shadowSizeMM         = vbox.dm.shadow.size,
             shadowSizeRealPixels = VBT.MMToPixels (vbox, shadowSizeMM, ax),
             buttonWidth          = Rect.HorSize (VBT.Domain (vbox.dm)),
             w = ROUND (
                   FLOAT (buttonWidth)
                     - 2.0 * (borderSizeRealPixels + shadowSizeRealPixels)),
             myWidth = HVSplit.T.shape (vbox, ax, n).pref,
             width   = MAX (w, myWidth)                    DO
          RETURN VBT.SizeRange {width, width, width + 1}
        END
      END
    END
  END DMVBoxShape;

&lt;* EXPORTED *&gt;
PROCEDURE <A NAME="SetDirMenu"><procedure>SetDirMenu</procedure></A> (v: T; dm: DirMenu) =
  BEGIN
    LOCK v.mu DO
      v.dirmenu := dm;
      IF dm # NIL THEN dm.filebrowser := v; END
    END
  END SetDirMenu;
</PRE>************************  Client interface  **********************

<P><PRE>&lt;* EXPORTED *&gt;
PROCEDURE <A NAME="SetReadOnly"><procedure>SetReadOnly</procedure></A> (v: T; readOnly: BOOLEAN) =
  BEGIN
    LOCK v.mu DO v.readOnly := readOnly END
  END SetReadOnly;

&lt;* EXPORTED *&gt;
PROCEDURE <A NAME="SetSuffixes"><procedure>SetSuffixes</procedure></A> (v: T; suffixes: TEXT) =
  BEGIN
    WITH list = ParseSuffixes (suffixes) DO
      LOCK v.mu DO
        v.suffixes := list;
        v.time := 0.0D0;             (* force true redisplay next chance *)
        VBT.Mark (v)
      END
    END
  END SetSuffixes;

PROCEDURE <A NAME="ParseSuffixes"><procedure>ParseSuffixes</procedure></A> (suffixes: TEXT): TextList.T =
  VAR
    list  : TextList.T := NIL;
    rd                 := TextRd.New (suffixes);
    suffix: TEXT;
  &lt;* FATAL Thread.Alerted *&gt;
  BEGIN
    TRY
      TRY
        LOOP
          Lex.Skip (rd, ISOChar.All - ISOChar.AlphaNumerics);
          suffix := Lex.Scan (rd, ISOChar.AlphaNumerics);
          IF Text.Empty (suffix) THEN EXIT END;
          list := TextList.Cons (suffix, list)
        END
      FINALLY
        Rd.Close (rd)
      END
    EXCEPT
    | Rd.Failure =&gt;
    END;
    RETURN list
  END ParseSuffixes;

&lt;* EXPORTED *&gt;
PROCEDURE <A NAME="Set"><procedure>Set</procedure></A> (v: T; path: Pathname.T; time: VBT.TimeStamp := 0)
  RAISES {Error} =
  &lt;* LL.sup = VBT.mu *&gt;
  VAR file, abs: Pathname.T; type: File.Type;
  BEGIN
    LOCK v.mu DO
      TRY
        IF NOT Pathname.Absolute (path) THEN
          path := Pathname.Join (v.dir, path, NIL)
        END;
        TRY
          abs := FS.GetAbsolutePathname (path);
          type := FS.Status (abs).type;
          IF type = RegularFile.FileType THEN
              v.dir := Pathname.Prefix (abs);
              file := Pathname.Last (abs)
          ELSIF type = FS.DirectoryFileType THEN
            v.dir := abs; file := &quot;&quot;
          ELSE                   &lt;* ASSERT FALSE *&gt;
          END
        EXCEPT
        | OSError.E (c) =&gt;
            (* That name failed, but maybe this isn't a readonly filebrowser,
               and it's a &quot;new&quot; filename in an existing directory.  Check the
               parent directory (prefix). *)
            IF v.readOnly THEN RAISE OSError.E (c) END; (* Nope. *)
            file := Pathname.Last (path);
            path := Pathname.Prefix (path);
            abs := FS.GetAbsolutePathname (path);
            (* If that failed, the parent-directory didn't exist, either, so
               let the caller handle this exception. *)
            IF FS.Status (abs).type = FS.DirectoryFileType THEN
              v.dir := abs
            ELSE
              (* The &quot;parent&quot; exists, but it isn't a directory. *)
              RaiseError (v, &quot;Not a directory&quot;, path)
            END                  (* IF *)
        END                      (* inner TRY *)
      EXCEPT
      | OSError.E (c) =&gt; RaiseError (v, Atom.ToText (c.head), path)
      END;                       (* outer TRY *)
      v.toSelect := file;
      v.time := 0.0D0;           (* That'll trigger the Watcher. *)
      ShowFileInHelper (v, file, time);
    END                          (* LOCK *)
  END Set;

&lt;* EXPORTED *&gt;
PROCEDURE <A NAME="Unselect"><procedure>Unselect</procedure></A> (v: T) =
  BEGIN
    LOCK v.mu DO v.selectNone () END
  END Unselect;

&lt;* EXPORTED *&gt;
PROCEDURE <A NAME="GetDir"><procedure>GetDir</procedure></A> (v: T): Pathname.T =
  BEGIN
    LOCK v.mu DO RETURN v.dir END
  END GetDir;

&lt;* EXPORTED *&gt;
PROCEDURE <A NAME="GetFile"><procedure>GetFile</procedure></A> (v: T): Pathname.T RAISES {Error} =
  BEGIN
    WITH files = GetFiles (v) DO
      IF files = NIL THEN RETURN &quot;&quot; ELSE RETURN files.head END
    END
  END GetFile;

&lt;* EXPORTED *&gt;
PROCEDURE <A NAME="GetFiles"><procedure>GetFiles</procedure></A> (v: T): TextList.T RAISES {Error} =
  BEGIN
    LOCK v.mu DO
      IF v.truthInHelper THEN
        VAR file := TextPort.GetText (v.helper);
        BEGIN
          IF NOT Pathname.Valid (file) THEN
            RaiseError (v, &quot;Invalid pathname&quot;, file)
          ELSIF NOT Pathname.Absolute (file) THEN
            file := Pathname.Join (v.dir, file, NIL)
          END;
          RETURN TextList.List1 (file)
        END
      ELSIF Text.Empty (v.dir) THEN
        RETURN NIL
      ELSE
        VAR res: TextList.T := NIL;
        BEGIN
          FOR i := v.count () - 1 TO 0 BY -1 DO
            IF v.isSelected (i) THEN
              res := TextList.Cons (
                       Pathname.Join (v.dir, v.getValue (i), NIL), res)
            END
          END;
          RETURN res
        END
      END
    END
  END GetFiles;
</PRE>*********************  Displaying a directory  **********************

<P><PRE>CONST DirMarker = &quot; (dir)&quot;;
VAR DirMarkerLength := Text.Length (DirMarker);

PROCEDURE <A NAME="DisplayDir"><procedure>DisplayDir</procedure></A> (v: T) =
  (* Display the directory v.dir, which might or might not really be
     accessible.  If it isn't accessible, call v.error. *)
  &lt;* LL = v.mu *&gt;
  VAR
    allfiles: TextList.T := NIL; (* Entire directory, except .  and .. *)
    satfiles: TextList.T := NIL; (* Files that have OK suffixes *)
  VAR
    oldCount := v.count ();
    newCount := 0;
    this     := -1; (* entry to select *)
    cl       := NEW (StatCl, v := v); (* Thread closure *)
  PROCEDURE satisfies (file: Pathname.T): BOOLEAN =
    VAR
      ext      := Pathname.LastExt (file);
      suffixes := v.suffixes;
    BEGIN
      IF Text.Empty (ext) THEN ext := &quot;$&quot; END;
      WHILE suffixes # NIL DO
        IF Text.Equal (ext, suffixes.head) THEN RETURN TRUE END;
        suffixes := suffixes.tail
      END;
      RETURN FALSE
    END satisfies;
  BEGIN
    IF v.statThread # NIL THEN Thread.Alert (v.statThread) END;
    VBT.SetCursor (v, Cursor.NotReady);
    TRY
      allfiles := TextListSort.SortD (Directory (v.dir));
      cl.files := allfiles;
      IF v.suffixes = NIL THEN
        satfiles := allfiles
      ELSE
        WHILE allfiles # NIL DO
          IF satisfies (allfiles.head) THEN
            satfiles := TextList.Cons (allfiles.head, satfiles)
          END;
          allfiles := allfiles.tail
        END;
        satfiles := TextList.ReverseD (satfiles)
      END;
      newCount := TextList.Length (satfiles) + 2;
      IF oldCount &lt; newCount THEN
        v.insertCells (oldCount, newCount - oldCount)
      ELSIF newCount &lt; oldCount THEN
        v.removeCells (newCount, oldCount - newCount)
      END;
      v.isDir [0] := TRUE;       (* for Current *)
      v.isDir [1] := TRUE;       (* for Parent *)
      FOR i := 2 TO newCount - 1 DO v.isDir [i] := FALSE END;
      v.setValue (0, Pathname.Current &amp; DirMarker);
      v.setValue (1, Pathname.Parent &amp; DirMarker);
      FOR i := 2 TO newCount - 1 DO
        IF NOT Text.Empty (v.toSelect) AND
          Text.Equal (satfiles.head, v.toSelect) THEN
          this := i; v.toSelect := &quot;&quot;;
        END;
        v.setValue (i, satfiles.head);
        satfiles := satfiles.tail;
      END;
      v.selectOnly (this);
      v.time := FS.Status (v.dir).modificationTime;
      ShowDirInMenu (v);
      v.statThread := Thread.Fork (cl)
    EXCEPT
    | OSError.E (e) =&gt; CallError (v, e)
    END
  END DisplayDir;

PROCEDURE <A NAME="Directory"><procedure>Directory</procedure></A> (dir: Pathname.T): TextList.T RAISES {OSError.E} =
  (* Return a list of all the files in the directory. *)
  VAR
    files: TextList.T := NIL;
    iter              := FS.Iterate (dir);
    name : Pathname.T;
  BEGIN
    TRY
      WHILE iter.next (name) DO files := TextList.Cons (name, files) END;
      RETURN files
    FINALLY
      iter.close ()
    END
  END Directory;

TYPE
  StatCl = Thread.Closure OBJECT
             v    : T;
             files: TextList.T;
           OVERRIDES
             apply := DoStats
           END;

PROCEDURE <A NAME="DoStats"><procedure>DoStats</procedure></A> (cl: StatCl): REFANY =
  VAR
    file : Pathname.T;
    i                 := 2;      (* We're skipping over Current and Parent *)
    v                 := cl.v;
    count             := v.count ();
  BEGIN
    TRY
      WHILE cl.files # NIL DO
        file := cl.files.head;
        cl.files := cl.files.tail;
        TRY
          IF FS.Status (Pathname.Join (v.dir, file, NIL)).type
               = FS.DirectoryFileType THEN
            LOCK v.mu DO
              IF Thread.TestAlert () THEN RETURN NIL END;
              LOOP
                IF i = count THEN
                  v.insertCells (count, 1);
                  v.setValue (count, file &amp; DirMarker);
                  v.isDir [count] := TRUE;
                  INC (count);
                  INC (i);
                  EXIT
                ELSE
                  WITH t = Text.Compare (v.getValue (i), file) DO
                    IF t = -1 THEN
                      INC (i)
                    ELSIF t = 0 THEN
                      v.setValue (i, file &amp; DirMarker);
                      v.isDir [i] := TRUE;
                      INC (i);
                      EXIT
                    ELSE
                      v.insertCells (i, 1);
                      v.setValue (i, file &amp; DirMarker);
                      v.isDir [i] := TRUE;
                      INC (count);
                      INC (i);
                      EXIT
                    END          (* IF *)
                  END            (* WITH *)
                END              (* IF *)
              END                (* LOOP *)
            END                  (* LOCK *)
          END                    (* IF *)
        EXCEPT
        | OSError.E (c) =&gt; CallError (v, c)
        END                      (* TRY *)
      END                        (* WHILE *)
    FINALLY
      VBT.SetCursor (v, Cursor.DontCare)
    END;                         (* TRY *)
    RETURN NIL
  END DoStats;

PROCEDURE <A NAME="InitDirMenuButton"><procedure>InitDirMenuButton</procedure></A> (dmb: DirMenuButton; text: TEXT): DirMenuButton =
  VAR
    textvbt := TextVBT.New (text, fnt := dmb.dm.font, bgFg := dmb.dm.shadow,
                            halign := 0.0, hmargin := 2.0);
    menubutton := ShadowedFeedbackVBT.NewMenu (textvbt, dmb.dm.shadow);
  BEGIN
    EVAL MenuSwitchVBT.T.init (dmb, menubutton);
    RETURN dmb
  END InitDirMenuButton;

PROCEDURE <A NAME="DirMenuButtonPut"><procedure>DirMenuButtonPut</procedure></A> (dmb: DirMenuButton; text: TEXT) =
  VAR
    menubutton: ShadowedFeedbackVBT.T := Filter.Child (dmb);
    textvbt   : TextVBT.T             := MultiFilter.Child (menubutton);
  BEGIN
    TextVBT.Put (textvbt, text)
  END DirMenuButtonPut;

PROCEDURE <A NAME="DirMenuButtonGet"><procedure>DirMenuButtonGet</procedure></A> (dmb: DirMenuButton): TEXT =
  VAR
    menubutton: ShadowedFeedbackVBT.T := Filter.Child (dmb);
    textvbt   : TextVBT.T             := MultiFilter.Child (menubutton);
  BEGIN
    RETURN TextVBT.Get (textvbt)
  END DirMenuButtonGet;

PROCEDURE <A NAME="DirMenuButtonCallback"><procedure>DirMenuButtonCallback</procedure></A> (dmb: DirMenuButton; READONLY cd: VBT.MouseRec) =
  &lt;* LL = VBT.mu *&gt;
  VAR
    arcs := NEW(Pathname.Arcs).init();
    vbox := dmb.dm.vbox;
    next := dmb;
  BEGIN
    arcs.addlo (dmb.get ());
    TRY
      LOOP
        next := Split.Succ (vbox, next);
        IF next = NIL THEN EXIT END;
        arcs.addlo (next.get ())
      END;
      Set (dmb.dm.filebrowser, Pathname.Compose (arcs), cd.time)
    EXCEPT
    | Error (e) =&gt; dmb.dm.filebrowser.error (e)
    | Pathname.Invalid, Split.NotAChild =&gt; &lt;* ASSERT FALSE *&gt;
    END
  END DirMenuButtonCallback;
</PRE>**************************  User interface  *************************

<P><PRE>PROCEDURE <A NAME="InsideClick"><procedure>InsideClick</procedure></A> (         s   : Selector;
                       READONLY cd  : VBT.MouseRec;
                                this: ListVBT.Cell  ) =
  &lt;* LL = VBT.mu *&gt;
  VAR v := s.v;
  VAR
    first: ListVBT.Cell;
    path : Pathname.T;
    isDir: BOOLEAN;
    event               := AnyEvent.FromMouse (cd);
  BEGIN
    ListVBT.MultiSelector.insideClick (s, cd, this);
    ShowFileInHelper (v, &quot;&quot;, cd.time);
    IF cd.clickType = VBT.ClickType.FirstDown THEN
      v.selectItems (event)
    ELSIF cd.clickType = VBT.ClickType.LastUp AND cd.clickCount = 3 THEN
      LOCK v.mu DO
        IF NOT v.getFirstSelected (first) THEN (* error? *) RETURN END;
        isDir := v.isDir [first];
        path := Pathname.Join (v.dir, v.getValue (first), NIL)
      END;
      IF isDir THEN
        v.activateDir (path, event)
      ELSE
        v.activateFile (path, event)
      END
    END
  END InsideClick;

PROCEDURE <A NAME="SelectItems"><procedure>SelectItems</procedure></A> (&lt;* UNUSED *&gt; v: T; &lt;* UNUSED *&gt; event: AnyEvent.T) =
  BEGIN
  END SelectItems;

PROCEDURE <A NAME="ActivateFile"><procedure>ActivateFile</procedure></A> (&lt;* UNUSED *&gt; v       : T;
                        &lt;* UNUSED *&gt; filename: Pathname.T;
                        &lt;* UNUSED *&gt; event   : AnyEvent.T) =
  BEGIN
  END ActivateFile;

PROCEDURE <A NAME="ActivateDir"><procedure>ActivateDir</procedure></A> (v: T; dirname: Pathname.T; event: AnyEvent.T) =
  &lt;* LL.sup = VBT.mu *&gt;
  VAR time := AnyEvent.TimeStamp (event);
  BEGIN
    TRY Set (v, dirname, time) EXCEPT Error (x) =&gt; v.error (x) END
  END ActivateDir;

PROCEDURE <A NAME="DefaultError"><procedure>DefaultError</procedure></A> (&lt;* UNUSED *&gt; v: T; &lt;* UNUSED *&gt; err: E) =
  BEGIN
  END DefaultError;

PROCEDURE <A NAME="ShowFileInHelper"><procedure>ShowFileInHelper</procedure></A> (v: T; file: Pathname.T; time: VBT.TimeStamp) =
  &lt;* LL = v.mu *&gt;
  VAR forHelper: Pathname.T;
  BEGIN
    IF v.helper = NIL THEN RETURN END;
    (* Prevent TextPort from calling &quot;v.helper.modified ()&quot; (which is
       HelperModified) when we do the following SetText.  HelperModified
       unselects everything and sets v.truthInHelper to TRUE. *)
    TextPort.SetModified (v.helper, TRUE);
    IF v.dirmenu = NIL OR Text.Empty (file) THEN
      forHelper := file
    ELSE
      forHelper := Pathname.Last (file)
    END;
    TextPort.SetText (v.helper, forHelper);
    v.truthInHelper := NOT Text.Empty(forHelper);
    IF time # 0 AND NOT Text.Empty (forHelper) THEN
      TextPort.Select (v.helper, time := time, replaceMode := TRUE)
    END;
    (* Re-enable &quot;v.helper.modified()&quot; *)
    TextPort.SetModified (v.helper, FALSE);
  END ShowFileInHelper;

PROCEDURE <A NAME="ShowDirInMenu"><procedure>ShowDirInMenu</procedure></A> (v: T) =
  &lt;* LL = v.mu *&gt;
  &lt;* FATAL Split.NotAChild *&gt;
  VAR
    dm                       := v.dirmenu;
    vbox     : HVSplit.T;
    prevChild: VBT.T         := NIL;
    thisChild: DirMenuButton;
    arcs     : Pathname.Arcs;
  &lt;* FATAL Pathname.Invalid *&gt;
  BEGIN
    IF dm = NIL THEN RETURN END;
    vbox := dm.vbox;
    arcs := Pathname.Decompose (v.dir);
    WITH curr = arcs.remhi () DO
      IF curr = NIL THEN
        TextVBT.Put (dm.top, &quot;????&quot;)
      ELSE
        TextVBT.Put (dm.top, curr)
      END
    END;
    LOOP
      thisChild := Split.Succ (vbox, prevChild);
      IF thisChild = NIL THEN
        IF arcs.size () = 0 THEN
          EXIT
        ELSE
          thisChild :=
            NEW (DirMenuButton, dm := dm).init (arcs.remhi ());
          Split.Insert (vbox, prevChild, thisChild);
          prevChild := thisChild
        END
      ELSIF arcs.size () = 0 THEN     (* delete remaining children *)
        Split.Delete (vbox, Split.Succ (vbox, prevChild))
      ELSE
        thisChild.put (arcs.remhi ());
        prevChild := thisChild
      END
    END
  END ShowDirInMenu;

PROCEDURE <A NAME="HelperModified"><procedure>HelperModified</procedure></A> (hp: Helper) =
  &lt;* LL = v.mu *&gt;
  (* That's the locking level because this is the &quot;modified&quot; method of the
     Helper, which is invoked by TextPort.ReplaceInVText, which is called by
     TextPort.SetText, which is called by ShowFileInHelper and others. *)
  BEGIN
    WITH v = hp.parent DO v.selectNone (); v.truthInHelper := TRUE END
  END HelperModified;

PROCEDURE <A NAME="HelperReturn"><procedure>HelperReturn</procedure></A> (hp: Helper; READONLY event: VBT.KeyRec) =
  &lt;* LL = VBT.mu *&gt;
  VAR
    v    := hp.parent;
    text := TextPort.GetText (hp);
  BEGIN
    TRY
      LOCK v.mu DO
        IF NOT Pathname.Valid (text) THEN
          RaiseError (v, &quot;Invalid pathname&quot;, text)
        END;
        IF NOT Pathname.Absolute (text) THEN
          text := Pathname.Join (v.dir, text, NIL)
        END
      END;
      Set (v, text, event.time);
      text := TextPort.GetText(hp);
      IF NOT Text.Empty (text) THEN
        v.activateFile(text, AnyEvent.FromKey(event))
      END
    EXCEPT
    | Error (x) =&gt; v.error (x)
    END
  END HelperReturn;

PROCEDURE <A NAME="RaiseError"><procedure>RaiseError</procedure></A> (v: T; text, path: TEXT := &quot;&quot;) RAISES {Error} =
  BEGIN
    RAISE Error (NEW (E, v := v, text := text, path := path))
  END RaiseError;

PROCEDURE <A NAME="CallError"><procedure>CallError</procedure></A> (v: T; e: OSError.Code) =
  VAR text := &quot;&quot;;
  BEGIN
    WHILE e # NIL DO
      text := text &amp; Atom.ToText (e.head) &amp; &quot; &quot;;
      e := e.tail
    END;
    v.error (NEW (E, v := v, text := text, path := v.dir))
  END CallError;

BEGIN
  EVAL Thread.Fork (NEW (Thread.Closure, apply := Watcher))
END FileBrowserVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
