<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/FlexVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/FlexVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;
</PRE> The <CODE>FlexVBT.T</CODE> is a filter whose shape is based on a {\em natural}
   size with some {\em stretch} and {\em shrink}.  If a natural amount
   is left unspecified, the stretch and shrink are applied relative to
   the child's size.  If a stretch or shrink is left unspecified, 0 is
   assumed.  All units are specified in millimeters.  See
   Figure~\ref{flexvbt} for examples.
<P>
   This interface is similar to <CODE>RigidVBT</CODE>, but more powerful in that
   one can specify a size based on a child's size and can dynamically
   change the size specification.  Also, it presents a slightly
   different model to the client: In <CODE>RigidVBT</CODE>, one thinks in terms
   of the low and high bounds of some range.  Here, one thinks in
   terms of the amount thed natural size value can be stretched and
   shrunk. 

<P><PRE>INTERFACE <interface><A HREF="FlexVBT.m3">FlexVBT</A></interface>;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../ui/src/split/Filter.i3">Filter</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

CONST
  Large    = 99999.0;
  Missing  = -Large;
  Infinity = Large;

TYPE
  SizeRange = RECORD natural, shrink, stretch: REAL END;
  Shape     = ARRAY Axis.T OF SizeRange;
</PRE> Some useful shapes are defined at the end of this interface. 

<P><PRE>TYPE
  <A HREF="FlexVBT.m3#T">T</A> &lt;: Public;
  Public = Filter.T OBJECT
           METHODS
             &lt;* LL.sup &lt;= VBT.mu *&gt;
             init (ch: VBT.T; READONLY sh := Default): T
           END;
</PRE> The call <CODE>v.init(ch, sh)</CODE> initializes <CODE>v</CODE> as a <CODE>FlexVBT</CODE> with child
   <CODE>ch</CODE> and shape specification <CODE>sh</CODE>.  The default shape causes <CODE>v</CODE> to
   be a no-op: it will simply return the shape of its child as its
   own. 

<P><PRE>PROCEDURE <A HREF="FlexVBT.m3#FromAxis">FromAxis</A> (         ch: VBT.T;
                             ax: Axis.T;
                    READONLY sh: SizeRange := DefaultRange): T;
&lt;* LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return a <CODE>FlexVBT</CODE> whose shape specification in the <CODE>ax</CODE> dimension
   is <CODE>sh</CODE> and whose shape in the other dimension is that of <CODE>ch</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FlexVBT.m3#Set">Set</A> (v: T; READONLY sh: Shape);
&lt;* LL.sup = VBT.mu.v *&gt;
</PRE><BLOCKQUOTE><EM> Change the shape of <CODE>v</CODE> to <CODE>sh</CODE>, and notify <CODE>v</CODE>'s parent that
   <CODE>v</CODE>'s size has changed. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FlexVBT.m3#SetRange">SetRange</A> (v: T; ax: Axis.T; READONLY sr: SizeRange);
&lt;* LL.sup = VBT.mu.v *&gt;
</PRE><BLOCKQUOTE><EM> Change the shape of <CODE>v</CODE> to <CODE>sr</CODE> along the <CODE>ax</CODE> axis, and
   notify <CODE>v</CODE>'s parent that <CODE>v</CODE>'s size has changed. </EM></BLOCKQUOTE><PRE>
</PRE> The rest of this interface defines some useful shapes: <CODE>Default</CODE>
   uses child's size; <CODE>Fixed</CODE> uses child's preferred, removing all
   shrink and stretch; <CODE>Stretchy</CODE> uses child's preferred and shrink,
   giving infinite stretch; and <CODE>Rigid</CODE> is a procedure to set a shape
   to a specified natural size, with neither stretch nor shrink.  

<P><PRE>CONST
  Default  = Shape{DefaultRange, DefaultRange};
  DefaultRange =
    SizeRange {natural := Missing,
               shrink  := Missing,
               stretch := Missing};

  Fixed   = Shape{FixedRange, FixedRange};
  FixedRange =
    SizeRange {natural := Missing,
               shrink  := 0.0,
               stretch := 0.0};

  Stretchy = Shape{StretchyRange, StretchyRange};
  StretchyRange =
    SizeRange {natural := Missing,
               shrink  := Missing,
               stretch := Infinity};

PROCEDURE <A HREF="FlexVBT.m3#RigidRange">RigidRange</A> (natural: REAL): SizeRange;
&lt;* LL = arbitrary *&gt;
</PRE><BLOCKQUOTE><EM> Return a <CODE>SizeRange</CODE> with the specified natural amount and
   with no stretch or shrink.  Equivalent to
<PRE>
       SizeRange {natural, 0.0, 0.0}
</EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FlexVBT.m3#Rigid">Rigid</A> (hNat, vNat: REAL): Shape;
&lt;* LL = arbitrary *&gt;
</PRE><BLOCKQUOTE><EM> Return a <CODE>Shape</CODE> with the specified natural amounts long
   the horizontal and vertical axes and
   with no stretch or shrink.  Equivalent to
<PRE>
       Shape {SizeRange {hNat, 0.0, 0.0},
              SizeRange {vNat, 0.0, 0.0}}
</EM></BLOCKQUOTE><PRE>

END FlexVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
