<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/FlexVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/FlexVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="FlexVBT.i3">FlexVBT</A></implements></module>;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../ui/src/split/Filter.i3">Filter</A>, <A HREF="../../ui/src/split/FilterClass.i3">FilterClass</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../ui/src/vbt/VBTClass.i3">VBTClass</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        sh: Shape;
      OVERRIDES
        init     := Init;
        shape    := DoShape;
        rescreen := Rescreen
      END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v: T; ch: VBT.T; READONLY sh := Default): T =
  BEGIN
    EVAL Filter.T.init (v, ch);
    v.sh := sh;
    RETURN v
  END Init;

PROCEDURE <A NAME="FromAxis"><procedure>FromAxis</procedure></A> (         ch: VBT.T;
                             ax: Axis.T;
                    READONLY sr: SizeRange := DefaultRange): T =
  VAR sh: Shape;
  BEGIN
    sh[ax] := sr;
    sh[Axis.Other[ax]] := DefaultRange;
    RETURN NEW(T).init(ch, sh);
  END FromAxis;

PROCEDURE <A NAME="Set"><procedure>Set</procedure></A> (v: T; READONLY sh: Shape) =
  BEGIN
    v.sh := sh;
    VBT.NewShape(v);
  END Set;

PROCEDURE <A NAME="SetRange"><procedure>SetRange</procedure></A> (v: T; ax: Axis.T; READONLY sr: SizeRange) =
  BEGIN
    v.sh[ax] := sr;
    VBT.NewShape(v);
  END SetRange;

PROCEDURE <A NAME="DoShape"><procedure>DoShape</procedure></A> (v: T; ax: Axis.T; n: CARDINAL):
  VBT.SizeRange =
  VAR range, chRange: VBT.SizeRange;
  BEGIN
    IF AnyMissing(v.sh[ax]) THEN
      chRange := VBTClass.GetShape(v.ch, ax, n);
      IF AllMissing(v.sh[ax]) THEN RETURN chRange END
    END;
    WITH sh = v.sh[ax] DO
      IF sh.natural = Missing THEN
        range.pref := chRange.pref
      ELSE
        range.pref := ROUND(VBT.MMToPixels(v, sh.natural, ax))
      END;
      IF sh.shrink = Missing THEN
        IF sh.natural # Missing THEN
          range.lo := range.pref
        ELSE
          range.lo := MIN(chRange.lo, range.pref)
        END;
      ELSE
        range.lo :=
          MAX(0, range.pref
                   - ROUND(VBT.MMToPixels(v, sh.shrink, ax)))
      END;
      IF sh.stretch = Missing THEN
        IF sh.natural # Missing THEN
          range.hi := range.pref + 1
        ELSE
          range.hi := MAX(chRange.hi, range.pref + 1)
        END;
      ELSE
        range.hi :=
          MIN(MAX(range.pref + 1, VBT.DefaultShape.hi),
              range.pref + 1
                + ROUND(VBT.MMToPixels(v, sh.stretch, ax)))
      END
    END;
    RETURN range
  END DoShape;

PROCEDURE <A NAME="Rescreen"><procedure>Rescreen</procedure></A> (v: T; READONLY cd: VBT.RescreenRec) =
  BEGIN
    Filter.T.rescreen (v, cd);
    VBT.NewShape (v);
  END Rescreen;

PROCEDURE <A NAME="AllMissing"><procedure>AllMissing</procedure></A> (READONLY range: SizeRange): BOOLEAN =
  BEGIN
    RETURN (range.natural = Missing) AND
           (range.shrink  = Missing) AND
           (range.stretch = Missing);
  END AllMissing;

PROCEDURE <A NAME="AnyMissing"><procedure>AnyMissing</procedure></A> (READONLY range: SizeRange): BOOLEAN =
  BEGIN
    RETURN (range.natural = Missing) OR
           (range.shrink  = Missing) OR
           (range.stretch = Missing);
  END AnyMissing;

PROCEDURE <A NAME="RigidRange"><procedure>RigidRange</procedure></A> (natural: REAL): SizeRange =
  BEGIN
    RETURN SizeRange{natural, 0.0, 0.0}
  END RigidRange;

PROCEDURE <A NAME="Rigid"><procedure>Rigid</procedure></A> (hNat, vNat: REAL): Shape =
  BEGIN
    RETURN
      Shape{SizeRange{hNat, 0.0, 0.0}, SizeRange{vNat, 0.0, 0.0}}
  END Rigid;

BEGIN
END FlexVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
