<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/GuardedBtnVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/GuardedBtnVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="GuardedBtnVBT.i3">GuardedBtnVBT</A></implements></module>;

IMPORT <A HREF="../../ui/src/split/BtnVBTClass.i3">BtnVBTClass</A>, <A HREF="../../ui/src/split/ButtonVBT.i3">ButtonVBT</A>, <A HREF="../../ui/src/vbt/Cursor.i3">Cursor</A>, <A HREF="../../ui/src/split/Filter.i3">Filter</A>, <A HREF="MultiClass.i3">MultiClass</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>,
       <A HREF="../../ui/src/vbt/Pixmap.i3">Pixmap</A>, <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="ReactivityVBT.i3">ReactivityVBT</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="SwitchVBT.i3">SwitchVBT</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>,
       <A HREF="../../ui/src/vbt/VBTClass.i3">VBTClass</A>, <A HREF="VBTKitResources.i3">VBTKitResources</A>;

VAR
  guardTexture           : Pixmap.T;
  guardTextureInitialized           := FALSE;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        guarded     : BOOLEAN   := TRUE;
        guardedOnPre: BOOLEAN;
      OVERRIDES
        init     := Init;
        pre      := Pre;
        post     := Post;
        cancel   := Cancel;
        callback := Callback;
        position := Position;
      END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v         : T;
                ch        : VBT.T;
                colors    : PaintOp.ColorScheme := NIL): T=
  VAR
    feedback := NEW (ReactivityVBT.T,
                     paintDormant := PaintDormant).init (
                  ch, colors);
  BEGIN
    EVAL ButtonVBT.T.init (v, feedback, Action);
    MultiClass.Be (v, NEW(SwitchVBT.MC));
    IF ch # NIL THEN MultiClass.BeChild(v, ch) END;
    SetGuard (v, TRUE);
    RETURN v
  END Init;

PROCEDURE <A NAME="Callback"><procedure>Callback</procedure></A> ( &lt;* UNUSED *&gt; v: T;
                     &lt;* UNUSED *&gt; READONLY cd: VBT.MouseRec) =
  BEGIN
  END Callback;

PROCEDURE <A NAME="Action"><procedure>Action</procedure></A> (selfAsButtonVBT: ButtonVBT.T; READONLY cd: VBT.MouseRec) =
  BEGIN
    NARROW (selfAsButtonVBT, T).callback (cd)
  END Action;

PROCEDURE <A NAME="Pre"><procedure>Pre</procedure></A> (v: T) =
  BEGIN
    v.guardedOnPre := v.guarded;
    SetGuard (v, FALSE);
  END Pre;

PROCEDURE <A NAME="Post"><procedure>Post</procedure></A> (v: T) =
  BEGIN
    IF NOT v.guardedOnPre THEN
      (* Restore guard on second LastUp *)
      SetGuard (v, TRUE)
    END
  END Post;

PROCEDURE <A NAME="Cancel"><procedure>Cancel</procedure></A> (v: T) =
  BEGIN
   (* Restore guard on chord-cancel *)
    SetGuard(v, TRUE);
  END Cancel;

PROCEDURE <A NAME="Position"><procedure>Position</procedure></A> (v: T; READONLY cd: VBT.PositionRec) =
  BEGIN
    IF NOT v.guarded AND NOT v.armed AND cd.cp.gone THEN
      (* Restore guard when moving out of v before next FirstDown *)
      SetGuard(v, TRUE)
    END;
    ButtonVBT.T.position(v, cd);
  END Position;

PROCEDURE <A NAME="SetGuard"><procedure>SetGuard</procedure></A> (v: T; fg: BOOLEAN) =
  VAR newState: ReactivityVBT.State;
  BEGIN
    v.guarded := fg;
    IF fg THEN
      newState := ReactivityVBT.State.Dormant
    ELSE
      newState := ReactivityVBT.State.Active
   END;
   ReactivityVBT.Set (Filter.Child(v), newState, Cursor.DontCare);
  END SetGuard;

PROCEDURE <A NAME="PaintDormant"><procedure>PaintDormant</procedure></A> (self  : ReactivityVBT.T;
                        r     : Rect.T;
                        colors: PaintOp.ColorScheme) =
  BEGIN
    IF NOT guardTextureInitialized THEN
      guardTexture := VBTKitResources.GetPixmap (&quot;NEDiagonal&quot;);
      guardTextureInitialized := TRUE
    END;
    VBT.PaintTexture (
      self, r, colors.transparentFg, guardTexture, Point.Origin)
  END PaintDormant;

BEGIN
END GuardedBtnVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
