<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/Image.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/Image.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                        </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman                                                      
<PRE>&lt;* PRAGMA LL *&gt;
</PRE> An <CODE>Image.T</CODE> is a screen-independent specification of an {\it
   image}.  An image is a pixmap that includes specifications for
   both color and resolution. It is rendered consistently across
   screen types in terms of its colors and size. 

<P><PRE>INTERFACE <interface><A HREF="Image.m3">Image</A></interface>;

IMPORT <A HREF="../../ui/src/vbt/Pixmap.i3">Pixmap</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../ui/src/vbt/ScrnPixmap.i3">ScrnPixmap</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../ui/src/vbt/TrestleComm.i3">TrestleComm</A>,
  <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../word/src/Word.i3">Word</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>;

TYPE T = Pixmap.T;

EXCEPTION Error;
</PRE> An <CODE>Image.Raw</CODE> is an array of pixels, with both resolution and
   color information.  It is like a <CODE>Pixmap.Raw</CODE>, with the
   addition of resolution and color information. An <CODE>Image.T</CODE> is
   built from an <CODE>Image.Raw</CODE> pixmap using procedures in this interface.
<P>
   There are three types of <CODE>Image.Raw</CODE> pixmaps: The <CODE>RawBitmap</CODE>
   represents bitmaps (1-bit deep pixmaps); the <CODE>RawPixmap</CODE>
   represents pixmaps that do not have a color table; and the
   <CODE>RawPixmapCMap</CODE> represents pixmaps that use a color table. 

<P><PRE>TYPE
  Pixel = Word.T;
  Mode = {Stable, Normal, Accurate};
  RGB = RECORD r, g, b: REAL END;

TYPE
  Raw = OBJECT
      width, height: INTEGER;
      xres, yres: REAL := 75.0; (* in pixels per inch *)
    METHODS
      get (h, v: INTEGER): Pixel;
      set (h, v: INTEGER; pixel: Pixel);
    END;

  RawBitmap = Raw BRANDED OBJECT END;

  RawPixmap = Raw OBJECT
      needsGamma := TRUE;
      colorMode  := Mode.Normal;
    END;

  RawPixmapCMap = RawPixmap OBJECT
      colors: REF ARRAY OF RGB;
    END;
</PRE> If <CODE>pm</CODE> is a <CODE>Raw</CODE> pixmap, then <CODE>pm</CODE> contains <CODE>pm.height</CODE>
   rows, and each row contains <CODE>pm.width</CODE> elements.  These fields
   are read-only after they are initialized.  The pixels are
   accessed with (0,0) in the northwest corner and
   <CODE>(width-1,height-1)</CODE> in the southeast corner.  The <CODE>pm.xres</CODE>
   and <CODE>pm.yres</CODE> fields specify the resolution at which <CODE>pm</CODE> was 
   designed. The <CODE>get</CODE> and <CODE>set</CODE> methods retrieve and store
   individual elements of the pixmap. 
<P>
   Each subtype of <CODE>Raw</CODE> can interpret a ``pixel'' in whatever way it
   chooses. The three subtypes defined here do the following:
<P>
   \begin{itemize}
<P>
   \item If <CODE>pm</CODE> is a <CODE>RawBitmap</CODE> pixmap, then it is guaranteed that
   the method <CODE>pm.get</CODE> will return a 0 or 1.  In the call
   <CODE>pm.set(h,v,pixel)</CODE>, only the least significant bit of <CODE>pixel</CODE>
   is used.
<P>
   \item
   If <CODE>pm</CODE> is a <CODE>RawPixmap</CODE>, the pixels in <CODE>pm</CODE> encode an RGB
   value each of whose components is 8 bits.  An <CODE>(r,g,b)</CODE> triple
   is stored as
<P>
<PRE>
       r * 256 * 256 + g * 256 + b
</PRE>
   and each of <CODE>r</CODE>, <CODE>g</CODE>, and <CODE>b</CODE> is between 0 and 255.  The field
   <CODE>pm.needsGamma</CODE> indicates whether to let Trestle gamma-correct
   the colors.  The <CODE>pm.colorMode</CODE> field determines how each RGB
   value in the pixmap should be displayed on color-mapped
   display.  
<P>
   \item
   If <CODE>pm</CODE> is a <CODE>RawPixmapCMap</CODE>, the pixels in <CODE>pm</CODE> are used as
   an index into the color table stored in the field
   <CODE>pm.colors</CODE>.
<P>
   \end{itemize}
<P>
   The colors used to display a colored pixmap <CODE>pm</CODE> depends 
   on a number of factors. The <CODE>pm.colorMode</CODE> field is 
   used to match colors in
   the pixmap with colors in the color table, as described in the
   <CODE>ScrnPixmap</CODE> interface.  The matching 
   depends on other applications running, on other pixmaps
   being displayed, and on the depth of the screen.
<P>
   The current implementation does not perform any dithering, except
   on monochrome screens.  On monochrome screen, a very crude
   ``thresholding'' is performed: if the brightness of the color
   is more than 50\% of the maximum brightness, the screen's
   foreground color is used.  Otherwise, the screen's background
   color is used. 

<P>
<P> \subsubsection{Retrieving and storing ``raw'' pixmaps}
<P>
   An <CODE>Image.Raw</CODE> can be built from a reader containing an image in
   Jef Poskanzer's ``portable anymap file'' (``pnm'') format, and a
   ``pnm'' description of an <CODE>Image.Raw</CODE> can be stored into a writer.
<P>
   There are many tools available in the public domain for
   manipulating images in ``pnm'' format and for converting
   between that format and other formats (e.g., GIF, X11,
   Macintosh PICT, HP PaintJet, and so on).
<P>
   There are three types of ``pnm'' files: \begin{itemize}
<P>
   \item ``pbm'' -- portable bitmap file
<P>
   \item ``pgm'' -- portable graymap file
<P>
   \item ``ppm'' -- portable pixmap file
<P>
   \end{itemize} Each of these format has two variants: ``raw''
   and ``ASCII.''  In the ``ASCII'' version, pixel values are
   stored as ASCII decimal numbers.  In the ``raw'' version,
   pixel values must be less than 256 and are stored as plain
   bytes. 

<P><PRE>PROCEDURE <A HREF="Image.m3#FromRd">FromRd</A> (rd: Rd.T): Raw
  RAISES {Thread.Alerted, Rd.Failure, Error};
&lt;* LL = arbitrary *&gt;
</PRE><BLOCKQUOTE><EM> Returns an <CODE>Image.Raw</CODE> from the reader <CODE>rd</CODE> containing an
   image in ``pnm'' format.  Pixels in ``ppm'' files are
   normalized to 8 bits per channel and intensity values of
   ``pgm'' files are normalized to 8 bits. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Image.m3#ToWr">ToWr</A> (raw: Raw; wr: Wr.T)
  RAISES {Thread.Alerted, Wr.Failure};
&lt;* LL = arbitrary *&gt;
</PRE><BLOCKQUOTE><EM> Store an ASCII description of <CODE>raw</CODE> into the writer <CODE>wr</CODE> using
   ``pnm'' format. </EM></BLOCKQUOTE><PRE>
</PRE> Procedures <CODE>FromRd</CODE> and <CODE>ToWr</CODE> are not guaranteed to be
   idempotent because pixel values are normalized by <CODE>FromRd</CODE> to
   be 8 bits.  Also, the ``pnm'' format produced by <CODE>ToWr</CODE> is
   either ASCII ``pbm'' for subtypes of <CODE>RawBitmap</CODE> or ASCII
   ``ppm'' for subtypes of <CODE>RawPixmap</CODE>, whereas procedure
   <CODE>FromRd</CODE> can accept these formats as well as the ``raw''
   variants and grayscale formats (``pgm'').
<P>
   The more serious limitation of using ``pnm'' format is that
   ``pnm'' does include any information about the pixmap
   resolution or color matching.  <CODE>FromRd</CODE> will use the default
   resolution of a <CODE>Raw</CODE> and the default color parameters of a
   <CODE>RawPixmap</CODE>; <CODE>ToWr</CODE> simply ignores the resolution and color
   fields. 

<P> \subsubsection{Creating ``raw'' pixmaps from a VBT}
<P>
   <CODE>FromVBT</CODE> captures the information in an arbitrary VBT into an
   <CODE>Image.Raw</CODE> of particular dimensions: 

<P><PRE>PROCEDURE <A HREF="Image.m3#FromVBT">FromVBT</A>(v : VBT.T; width, height: REAL): Raw
   RAISES {TrestleComm.Failure};
&lt;* LL = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return a screen-independent <CODE>Raw</CODE> that describes <CODE>v</CODE> when 
   <CODE>v</CODE> is scaled to be <CODE>width</CODE> by <CODE>height</CODE> millimeters. </EM></BLOCKQUOTE><PRE>
</PRE> The current implementation of <CODE>FromVBT</CODE> will cause <CODE>v</CODE> to be
   redisplayed multiple times: First <CODE>v</CODE> is detached from its parent
   <CODE>pm</CODE> (unless <CODE>pm = NIL</CODE>). Next, <CODE>v</CODE> is installed in an offscreen
   Trestle window, with an appropriate <CODE>ScaleFilter</CODE> inserted to make
   <CODE>v</CODE> the correct size. A call to <CODE>VBT.Capture</CODE> creates a
   screen-dependent version of the offscreen window. At this point,
   <CODE>v</CODE> is detached from the offscreen window, and reattached to <CODE>pm</CODE>
   (unless <CODE>pm = NIL</CODE>).  Each time that <CODE>v</CODE> changes its parent,
   various VBT methods (reshape, rescreen, redisplay, and so on) are
   called.
<P>
   The following procedure converts a 
   screen-dependent pixmap (such as that returned
   by <CODE>VBT.Capture</CODE>), into one that is screen-independent: 

<P><PRE>PROCEDURE <A HREF="Image.m3#FromScrnPixmap">FromScrnPixmap</A> (
    spm: ScrnPixmap.T;
    st: VBT.ScreenType): Raw RAISES {TrestleComm.Failure};
&lt;* LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Returns a screen-independent <CODE>Raw</CODE> that describes the pixmap
   <CODE>spm</CODE> when displayed on <CODE>st</CODE>. Any field of <CODE>Raw</CODE> that cannot be 
   computed from <CODE>spm</CODE> and <CODE>st</CODE> is given its default value. For example,
   the <CODE>needsGamma</CODE> and the <CODE>colorMode</CODE> fields of pixmaps that are
   deeper than 1-bit. </EM></BLOCKQUOTE><PRE>
</PRE> \subsubsection{Building an image from ``raw'' pixmaps}
<P>
   The remaining procedures in this interface create an <CODE>Image.T</CODE>
   from an <CODE>Image.Raw</CODE> pixmap: 

<P><PRE>PROCEDURE <A HREF="Image.m3#Unscaled">Unscaled</A> (raw: Raw): T;
&lt;* LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Returns a pixmap that will display as <CODE>raw</CODE>.  The pixels in
   <CODE>raw</CODE> will not be scaled regardless of the screen's
   resolution. </EM></BLOCKQUOTE><PRE>
</PRE> For example, consider a pixmap <CODE>pm</CODE> whose dimensions are 150 wide
   by 50 high.  On a 75dpi screen (a typical 1993-vintage monitor),
   the pixmap <CODE>pm</CODE> would appear 2 inches wide and 2/3 inches high.  On
   a high-resolution monitor of 300 dpi, <CODE>pm</CODE> would appear 1/2 inch
   wide and 1/6 inch high.  The <CODE>pm.xres</CODE> and <CODE>pm.yres</CODE> fields are
   ignored.
<P>
   If you want <CODE>pm</CODE> always to appear as 2 inches by 2/3 inches,
   regardless of the pixel density of the monitor, you'd use
   <CODE>Scaled</CODE> instead: 

<P><PRE>PROCEDURE <A HREF="Image.m3#Scaled">Scaled</A> (raw: Raw): T;
&lt;* LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return a pixmap that will display as <CODE>raw</CODE>, scaled for the
   screen's resolution.  The horizontal and vertical dimensions
   are scaled independently. </EM></BLOCKQUOTE><PRE>
</PRE> The current implementation scales pixmaps by non-negative
   integer amounts: horizontally by <CODE>ROUND(dpiX/pm.xres)</CODE> and
   vertically by <CODE>ROUND(dpiY/pm.yres)</CODE>, where <CODE>dpiX</CODE> and <CODE>dpiY</CODE>
   are the horizontal and vertical resolution of the screen,
   respectively, expressed in dots-per-inch.
<P>
   In the example above, suppose that <CODE>pm.xres</CODE> and <CODE>pm.yres</CODE> were
   both 75.  On a 300 dpi screen, <CODE>pm</CODE> would appear 2 inches wide and
   2/3 inches high.  Each pixel in <CODE>pm</CODE> would appear as a block of 4x4
   screen pixels.  If the screen were 250 dpi horizontally and 175 dpi
   vertically, then <CODE>pm</CODE> would appear $1\frac{1}{2}$ inches wide and
   $1\frac{1}{3}$ inches high.  Each pixel in <CODE>pm</CODE> would appear as a
   block of 3x2 screen pixels.
<P>
   Procedure <CODE>ScaledN</CODE> allows you to provide a collection of
   pixmaps, each at a different resolution, and scales the most
   appropriate pixmap: 

<P><PRE>PROCEDURE <A HREF="Image.m3#ScaledN">ScaledN</A> (READONLY raws: ARRAY OF Raw;
                   tolerance: REAL     := 0.25;
                   maxScale : CARDINAL := 4     ): T;
&lt;* LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return a pixmap which will scale and display pixmap
   <CODE>raws[i]</CODE>, where <CODE>i</CODE> is chosen so that <CODE>raws[i]</CODE> has the ``most
   appropriate'' resolution. </EM></BLOCKQUOTE><PRE>
</PRE> Specifically, <CODE>i</CODE> is chosen such to minimize the {\em scale factor}
   (the amount that a ``raw'' pixmap must be scaled) while remaining
   within the given error <CODE>tolerance</CODE>.
<P>
   The scale factor of pixmap <CODE>pm</CODE> is
<P>
<PRE>
       MAX (dpiX/pm.xres, dpiY/pm.yres)
</PRE>
   where <CODE>dpiX</CODE> and <CODE>dpiY</CODE> are the horizontal and vertical
   resolutions of the screen, respectively, expressed in
   dots-per-inch.
<P>
   For a given scale factor <CODE>s</CODE>, the error is
<P>
<PRE>
      ABS (MAX ((dpiX - MAX(s, maxScale) * pm.xres) / dpiX, 
                (dpiY - MAX(s, maxScale) * pm.yres) / dpiY))
</PRE>
   If none of the pixmaps in the <CODE>raws</CODE> array satisfies the
   tolerance, then the pixmap giving the smallest error is
   chosen.
<P>
   The purpose of <CODE>tolerance</CODE> and <CODE>maxScale</CODE> is to allow the user
   control over the interpretation of ``most appropriate'' when
   chosing the pixmap.
<P>
   \begin{itemize}
<P>
   \item A small <CODE>tolerance</CODE> ensures a small error, which can
   mean a larger scale factor.
<P>
   For example, suppose the screen has a resolution of 300 dpi and
   pixmaps that are 150 and 250 dpi.  When <CODE>tolerance</CODE> \verb|&lt;| 1/6,
   then <CODE>ScaledN</CODE> chooses the 150 dpi pixmap with a scale factor equal
   to 2, rather than the 250 dpi pixmap with a scale factor equal to 1.
<P>
   \item A small <CODE>maxScale</CODE> makes it less likely that a very
   low-resolution pixmap (which happens to give very small error)
   is chosen over a higher-resolution pixmap (which gives a
   larger error).
<P>
<P>
   For example, suppose the screen has a resolution of 300 dpi and
   pixmaps that are 50 and 200 dpi.  If <CODE>tolerance</CODE> \verb|&gt;| 1/3, then
   <CODE>ScaledN</CODE> always chooses the 200 dpi pixmap, because the error,
   (300 - 200)/300=1/3, is within the tolerance and the scale factor
   for 200 dpi is less than the scale factor for the 50 dpi pixmap.
   However, when <CODE>tolerance</CODE> \verb|&lt;| 1/3, the 50 dpi pixmap is chosen
   unless <CODE>maxScale</CODE> \verb|&lt;=| 4.
<P>
   \end{itemize}
<P>


<P><PRE>END Image.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
