<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/ListVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/ListVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL                                                                 *&gt;
</PRE> A <CODE>ListVBT</CODE> defines a VBT class for displaying a list (or
   table) of items.  Each item is in a {\em cell}.  All cells are
   the same size.  They are displayed in a single vertical
   column, with a scrollbar.
<P>
   The <CODE>ListVBT</CODE> itself deals with the details of being a VBT,
   maintains a table that maps a cell-number to a cell-value, and
   maintains the {\em selection}, a distinguished subset of the
   cells.  It uses subsidiary objects to handle the details of
   what cells look like on the screen (<CODE>Painter</CODE>), and how the
   list responds to mouse clicks (<CODE>Selector</CODE>).
<P>
   This interface contains basic versions of each of the
   subsidiary objects:
<P>
   \begin{itemize}
<P>
   \item <CODE>TextPainter</CODE>, which treats cells' values as <CODE>TEXT</CODE> and
   paints them.
<P>
   \item <CODE>UniSelector</CODE>, which maintains at most one selected
   cell, adjusted by mouse clicks.
<P>
   \item <CODE>MultiSelector</CODE>, which uses mouse clicks for selection,
   but permits multiple cells to be selected.
<P>
   \end{itemize}
<P>
   The client can subclass these, or provide entirely different ones.
   A client that wishes to take actions in response to mouse clicks
   should subclass a <CODE>Selector</CODE>. Similarly, a client that wishes to
   display objects other than text strings should subclass <CODE>Painter</CODE>.
<P>
   \subsubsection{Locking levels}
<P>
   <CODE>ListVBT</CODE> is internally synchronized; it can safely be called
   from multiple threads.  All <CODE>ListVBT.T</CODE> methods have <CODE>LL.sup &lt;
   list</CODE>.  In addition, <CODE>VBT.mu &lt; list</CODE> for any <CODE>list</CODE> of type
   <CODE>ListVBT.T</CODE>.
<P>
   VBT methods call <CODE>Selector</CODE> methods with <CODE>LL.sup = VBT.mu</CODE>.
   <CODE>Selector</CODE> methods are permitted to call <CODE>ListVBT.T</CODE> methods.
<P>
   <CODE>ListVBT.T</CODE> methods call <CODE>Painter</CODE> methods with the <CODE>ListVBT.T</CODE>'s
   internal mutex held.  <CODE>Painter</CODE> methods must not call any of the
   <CODE>ListVBT.T</CODE> methods; their locking level is such that <CODE>LL.sup =
   list</CODE>.
   <P>
   The <CODE>TextPainter</CODE> class uses its own internal lock for font
   information; \linebreak <CODE>TextPainter.setFont(v,font)</CODE> has <CODE>LL.sup &lt; v</CODE>.
<P>
   \subsubsection{The type {ListVBT.T}}
   

<P>
<P><PRE>INTERFACE <interface><A HREF="ListVBT.m3">ListVBT</A></interface>;

IMPORT <A HREF="../../ui/src/vbt/Font.i3">Font</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

TYPE Cell = INTEGER;
</PRE><BLOCKQUOTE><EM> The number of a cell; the first cell-number is 0. </EM></BLOCKQUOTE><PRE>

TYPE
  <A HREF="ListVBT.m3#T">T</A> &lt;: Public;
  <A HREF="ListVBT.m3#Private">Private</A> &lt;: VBT.Split;
  Public = Private OBJECT
             painter : Painter  := NIL;
             selector: Selector := NIL;
           METHODS
             init             (colors: PaintOp.ColorQuad): T;
             setValue         (this: Cell; value: REFANY);
             getValue         (this: Cell): REFANY;
             count            (): CARDINAL;
             insertCells      (at: Cell; n: CARDINAL);
             removeCells      (at: Cell; n: CARDINAL);
             selectNone       ();
             selectOnly       (this: Cell);
             select           (this: Cell; selected: BOOLEAN);
             isSelected       (this: Cell): BOOLEAN;
             getAllSelected   (): REF ARRAY OF Cell;
             getFirstSelected (VAR this: Cell): BOOLEAN;
             scrollTo         (this: Cell);
             scrollToShow     (this: Cell);
             reportVisible    (first: Cell; num: CARDINAL);
           END;
</PRE> In the following descriptions, <CODE>v</CODE> is an object of type
   <CODE>ListVBT.T</CODE>, and a value <CODE>n</CODE> is said to be {\it in range} if
<P>
   \medskip {\display {\tt 0 $\leq$ n &lt; v.count() }}
<P>
   \medskip <CODE>v.painter</CODE> is the list's painter; the client may read but not
   assign to this field, although the client may provide a value
   at allocation time.  If the actual painter has methods
   allowing it to be modified, the client is welcome to call
   them, although the client and painter are then responsible for
   provoking any necessary repaints.
<P>
   <CODE>v.selector</CODE> is the list's selector; client may read but not
   assign to this field, although the client may provide a value
   at allocation time.  If the actual selector has methods
   allowing it to be modified, the client is welcome to call
   them, although the client and selector are then responsible
   for any necessary adjustments to the set of selected cells.
<P>
   The call <CODE>v.init(colors)</CODE> initializes <CODE>v</CODE> as a <CODE>ListVBT</CODE> and
   returns <CODE>v</CODE>.  It must be called before any other method.  <CODE>colors</CODE>
   is passed intact to the scroller; <CODE>colors.fg</CODE> is used for a bar
   that separates the cells from the scroller.  If <CODE>v.painter = NIL</CODE>
   when this method is called, <CODE>init</CODE> will allocate and initialize a
   <CODE>TextPainter</CODE>.  If <CODE>v.selector = NIL</CODE>, <CODE>init</CODE> will allocate and
   initialize a <CODE>UniSelector</CODE>.  Neither the painter nor the selector
   need have been initialized before this method is called.  The list
   initially has no cells (and no selection).
<P>
   In the call <CODE>v.setValue(this,value)</CODE>, if <CODE>this</CODE> is in range,
   then record <CODE>value</CODE> as the value of the cell <CODE>this</CODE>; otherwise
   do nothing.
<P>
   In the call <CODE>v.getValue(this)</CODE>, if <CODE>this</CODE> is in range,
   then return the previously recorded value of the cell <CODE>this</CODE>;
   otherwise return <CODE>NIL</CODE>.
<P>
   The call <CODE>v.count()</CODE> returns the number of cells.
<P>
   The call <CODE>v.insertCells(at,n)</CODE> inserts <CODE>n</CODE> cells, starting at
<PRE>
      MAX (0, MIN (at, v.count()))
   </PRE>
Previously existing cells at and beyond <CODE>at</CODE> are renumbered
   appropriately, and selections are relocated appropriately.
   The VBT will be repainted in due course.  The new cells'
   values are all <CODE>NIL</CODE>, and they are not selected.
<P>
   The call <CODE>v.removeCells(at, n)</CODE> removes all cells in the range
<PRE>
      [MAX (0, MIN (at, v.count ())) ..
        -1 + MIN (at + n, v.count ())]
   </PRE>
Subsequent cells are renumbered appropriately.  The VBT will
   be repainted in due course.
<P>
   The call <CODE>v.selectNone()</CODE> makes the set of selected cells be
   empty.
<P>
   In the call <CODE>v.selectOnly(this)</CODE>, if <CODE>this</CODE> is in range, make
   the set of selected cells be exactly <CODE>this</CODE>; otherwise make
   the list of selected cells be empty.  Equivalent to
<PRE>
      v.selectNone(); v.select(this,TRUE)
</PRE>
   In the call <CODE>v.select(this,selected)</CODE>, if <CODE>this</CODE> is in range
   and <CODE>selected</CODE> is <CODE>TRUE</CODE>, add <CODE>this</CODE> to the set of selected
   cells (without complaint if it's already selected); otherwise
   if <CODE>this</CODE> is in range and <CODE>selected</CODE> is <CODE>FALSE</CODE>, remove it
   from the set of selected cells (again without complaint).
   The VBT will be repainted as necessary in due course.
<P>
   The call <CODE>v.isSelected(this)</CODE> returns <CODE>TRUE</CODE> if <CODE>this</CODE> is
   in range and is a selected cell; otherwise it returns <CODE>FALSE</CODE>.
<P>
   The call <CODE>v.getAllSelected()</CODE> returns the set of selected cells.
   If there are none, it returns a non-<CODE>NIL</CODE> <CODE>REF</CODE> to an array of length
   0.
<P>
   The call <CODE>v.getFirstSelected(this)</CODE> assigns to <CODE>this</CODE> the
   lowest-numbered selected cell and returns <CODE>TRUE</CODE>; if there are
   no selected cells, it returns <CODE>FALSE</CODE>.
<P>
   The call <CODE>v.scrollTo(this)</CODE> adjusts the list's scrolling
   position to place
<PRE>
      MAX (0, MIN (this, v.count () - 1) )
   </PRE>
at the top of <CODE>v</CODE>'s domain.
<P>
   The call <CODE>v.scrollToShow(this)</CODE> adjusts the list's scrolling
   position to make <CODE>this</CODE> visible. 
   <P>
   The <CODE>ListVBT</CODE> will call <CODE>v.reportVisible(first, num)</CODE> whenever
   the set of visible cells changes (either because of scrolling
   or because of reshaping).  (A cell is ``visible'' if it
   is within the domain of the <CODE>ListVBT</CODE>; it may not be visible
   to the user if other windows obscure the <CODE>ListVBT</CODE>.)  The
   argument <CODE>first</CODE> is the index of the first visible cell, and
   <CODE>num</CODE> is the number of visible cells.  The default for this
   method is a no-op; override it if you need the information
   it provides.  The locking level of the method is <CODE>LL.sup = v</CODE>
   (that is, the <CODE>ListVBT</CODE> itself is locked when the method is called,
   so the method mustn't operate on <CODE>v</CODE>).


<P> \subsubsection{The Painter} 

<P> Here is the definition of a <CODE>Painter</CODE>.  In the comments about
   its methods, <CODE>v</CODE> is the VBT in which the painting is to take
   place; it is the <CODE>ListVBT.T</CODE> or a subtype of it.  Recall
   that <CODE>LL.sup = list</CODE> for all methods, other than <CODE>init</CODE>. 

<P><PRE>TYPE
  Painter = OBJECT
            METHODS
              init   (): Painter;
              height (v: VBT.T): INTEGER;
              paint (v       : VBT.T;
                     r       : Rect.T;
                     value   : REFANY;
                     index    : CARDINAL;
                     selected: BOOLEAN;
                     bad     : Rect.T   );
              select (v       : VBT.T;
                      r       : Rect.T;
                      value   : REFANY;
                      index   : CARDINAL;
                      selected: BOOLEAN );
              erase (v: VBT.T; r: Rect.T);
            END;
</PRE> The call <CODE>p.init()</CODE> initializes <CODE>p</CODE> as a <CODE>Painter</CODE> and returns
   <CODE>p</CODE>.
<P>
   The call <CODE>p.height(v)</CODE> returns the pixel height of each cell
   if painted in <CODE>v</CODE>.  The list caches the result of this call,
   so it needn't be very efficient.  It is called only when the
   list has a non-empty domain.  It gets re-evaluated whenever
   the list's screen changes.
<P>
   The call <CODE>p.paint(v, r, value, index, select, bad)</CODE> paints the cell
   with the given index and value in the given rectangle (whose height 
   will equal that returned  by <CODE>p.height()</CODE>, and some part of which will be 
   visible).  If <CODE>selected</CODE> is <CODE>TRUE</CODE>, highlight the painted cell to indicate
   that it is in the set of selected cells.  <CODE>bad</CODE> is the subset
   of <CODE>r</CODE> that actually needs to be painted; <CODE>bad</CODE> is wholly
   contained in <CODE>r</CODE>.
<P>
   The call <CODE>p.select(v, r, value, index, selected)</CODE> changes the 
   highlight of the cell with the given index and value,
   according to <CODE>selected</CODE>, to show whether it is
   in the set of selected cells.  The cell has previously been
   painted; its selection state has indeed changed.  It's OK for
   this method to be identical to <CODE>paint</CODE>, but it might be more
   efficient or cause less flicker, e.g.  by just inverting <CODE>r</CODE>.
<P>
   The call <CODE>p.erase(v, r)</CODE> paints the given rectangle to show
   that it contains no cells.  Typically, this just fills it with
   the background color used when painting cells. 

<P> \subsubsection{TextPainter} 

<P> Perhaps the most common type of <CODE>Painter</CODE> is a <CODE>TextPainter</CODE>.
   It displays cells whose values are text strings.  Here is its
   public definition: 

<P><PRE>TYPE
  <A HREF="ListVBT.m3#TextPainter">TextPainter</A> &lt;: TextPainterPublic;

  TextPainterPublic =
    Painter OBJECT
    METHODS
      init (bg       := PaintOp.Bg;
            fg       := PaintOp.Fg;
            hiliteBg := PaintOp.Fg;
            hiliteFg := PaintOp.Bg;
            font     := Font.BuiltIn): TextPainter;
      setFont (v: VBT.T; font: Font.T); &lt;* LL.sup &lt; v *&gt;
    END;
</PRE> The call <CODE>p.init(...)</CODE> initializes <CODE>p</CODE> as a <CODE>TextPainter</CODE> and
   returns <CODE>p</CODE>.  Unselected cells are painted with <CODE>fg</CODE> text on
   <CODE>bg</CODE>; selected cells are painted with <CODE>hiliteFg</CODE> text on
   <CODE>hiliteBg</CODE>; erased areas are painted with <CODE>bg</CODE>.  Text is drawn
   using <CODE>font</CODE>.
<P>
   After the call <CODE>p.setFont(v, font)</CODE>, the <CODE>TextPainter</CODE> uses
   <CODE>font</CODE> for subsequent painting of values; the call also marks
   <CODE>v</CODE> for redisplay.  <CODE>v</CODE> should be the relevant <CODE>ListVBT.T</CODE>. 

<P>
<P> \subsubsection{The Selector} 

<P> Here is the definition of <CODE>Selector</CODE>.  Recall that <CODE>LL.sup =
   VBT.mu</CODE> for all methods other than <CODE>init</CODE>. 

<P><PRE>TYPE
  Selector =
    OBJECT
    METHODS
      init         (v: T): Selector;
      insideClick  (READONLY cd: VBT.MouseRec; this: Cell);
      outsideClick (READONLY cd: VBT.MouseRec);
      insideDrag   (READONLY cd: VBT.PositionRec; this: Cell);
      outsideDrag  (READONLY cd: VBT.PositionRec);
    END;
</PRE> The call <CODE>s.init(v)</CODE> initializes <CODE>s</CODE> as a <CODE>Selector</CODE> and
   returns <CODE>s</CODE>.  The <CODE>ListVBT</CODE> <CODE>v</CODE> need not have been initialized
   before this method is called.
<P>
   The call <CODE>s.insideClick(cd, this)</CODE> is called on a <CODE>FirstDown</CODE> mouse
   click inside the cell, or on any mouse click inside the cell while
   we have the mouse focus.  On any click other than <CODE>LastUp</CODE>, the
   list itself has set a cage so that it receives position reports
   during subsequent drags.
<P>
   The call <CODE>s.outsideClick(cd)</CODE> is called when there is a <CODE>FirstDown</CODE>
   click in the <CODE>ListVBT</CODE> that is not in a cell, or on any mouse click
   not in a cell while we have the mouse focus.  On any click other
   than <CODE>LastUp</CODE>, the list itself has set a cage so that it receives
   position reports during subsequent drags.
<P>
   The call <CODE>s.insideDrag(cd)</CODE> is called if the list has received a
   <CODE>FirstDown</CODE> click and a subsequent position report with the mouse
   not in any cell.  The list itself has set a cage so that it
   receives further position reports.
<P>
   The call <CODE>s.outsideDrag(cd)</CODE> is called if the list has the mouse
   focus and receives a subsequent position report with the mouse in
   this cell.  The list itself has set a cage so that it receives
   further position reports. 

<P> \subsubsection{UniSelector and MultiSelector} 

<P> One common class of <CODE>Selector</CODE> is a <CODE>UniSelector</CODE>.  It
   maintains the invariant that there is at most one selected
   cell.  On an <CODE>insideClick</CODE> firstDown, or an <CODE>insideDrag</CODE>, it
   removes any previous selection and then selects this cell.  Its
   other methods do nothing.  Here is its declaration: 

<P><PRE>TYPE
  <A HREF="ListVBT.m3#UniSelector">UniSelector</A> &lt;: Selector;
</PRE> The other common class of <CODE>Selector</CODE> is <CODE>MultiSelector</CODE>.  It
   permits multiple cells to be selected.  On an <CODE>insideClick</CODE>
   firstDown, it remembers this cell as the {\em anchor}; if this is
   not a shift-click, it calls <CODE>selectNone</CODE> and inverts the
   selection state of this cell.  On an <CODE>insideDrag</CODE>, it makes the
   selection state of all cells between this cell and the anchor
   be the same as that of the anchor.  Here is its
   declaration: 

<P><PRE>TYPE
  <A HREF="ListVBT.m3#MultiSelector">MultiSelector</A> &lt;: Selector;

END ListVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
