<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/MarginFeedbackVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/MarginFeedbackVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="MarginFeedbackVBT.i3">MarginFeedbackVBT</A></implements></module>;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="FeedbackVBT.i3">FeedbackVBT</A>, <A HREF="../../ui/src/split/Filter.i3">Filter</A>, <A HREF="../../ui/src/split/HVSplit.i3">HVSplit</A>, <A HREF="MultiClass.i3">MultiClass</A>,
         <A HREF="../../ui/src/vbt/Pixmap.i3">Pixmap</A>, <A HREF="PixmapVBT.i3">PixmapVBT</A>, <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../geometry/src/Region.i3">Region</A>, <A HREF="Shadow.i3">Shadow</A>,
         <A HREF="ShadowPaint.i3">ShadowPaint</A>, <A HREF="../../ui/src/split/Split.i3">Split</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="VBTKitResources.i3">VBTKitResources</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        marginVBT: VBT.T
      OVERRIDES
        init := Init
      END;

TYPE
  MC = MultiClass.T OBJECT
       OVERRIDES
         replace := Replace;
         succ    := Succ;
         pred    := Succ;
       END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v: T; ch, marginVBT: VBT.T): T =
  VAR hv := HVSplit.New(Axis.T.Hor, FALSE, -1, FALSE);
  BEGIN
    EVAL FeedbackVBT.T.init(v, hv);
    MultiClass.Be(v, NEW(MC));
    Split.AddChild(hv, marginVBT);
    IF ch # NIL THEN
      Split.AddChild(hv, ch);
      MultiClass.BeChild(v, ch);
    END;
    v.marginVBT := marginVBT;
    FeedbackVBT.Normal(v);
    RETURN v
  END Init;

TYPE
  Flavor = {Check, Box, Bullet};
  OnOff = BOOLEAN;
  NE = {Normal, Excited};

VAR
  mu := NEW(MUTEX);
  inited := ARRAY Flavor OF BOOLEAN {FALSE, FALSE, FALSE};

  pixmaps  : ARRAY Flavor, OnOff, NE OF Pixmap.T;
  styles   : ARRAY Flavor, OnOff, NE OF Shadow.Style;
  textures : ARRAY Flavor, OnOff, NE OF Pixmap.T;

TYPE
  TWithPixmaps = T OBJECT
                   flavor: Flavor;
                 OVERRIDES
                   normal  := Normal;
                   excited := Excited;
                 END;

PROCEDURE <A NAME="NewWithPixmaps"><procedure>NewWithPixmaps</procedure></A> (ch     : VBT.T;
                          blotVBT: BlotVBT;
                          flavor : Flavor   ): T =
  BEGIN
    RETURN NEW(TWithPixmaps, flavor := flavor).init(ch, blotVBT)
  END NewWithPixmaps;

PROCEDURE <A NAME="Show"><procedure>Show</procedure></A> (v: TWithPixmaps; normalExcited: NE) =
  VAR onOff := FeedbackVBT.GetState(v);
  BEGIN
    LOCK mu DO
      BlotVBTPut(
        v.marginVBT, pixmaps[v.flavor, onOff, normalExcited],
        styles[v.flavor, onOff, normalExcited],
        textures[v.flavor, onOff, normalExcited])
    END
  END Show;

PROCEDURE <A NAME="Normal"><procedure>Normal</procedure></A> (v: T) =
  BEGIN
   Show(v, NE.Normal);
  END Normal;

PROCEDURE <A NAME="Excited"><procedure>Excited</procedure></A> (v: T) =
  BEGIN
   Show(v, NE.Excited);
  END Excited;
</PRE>************************* Check Mark  ***************************

<P><PRE>PROCEDURE <A NAME="NewCheck"><procedure>NewCheck</procedure></A> (ch: VBT.T; shadow: Shadow.T := NIL): T =
  BEGIN
    GetCheckResources();
    RETURN NewWithPixmaps(ch, NewBlotVBT(shadow), Flavor.Check);
  END NewCheck;

PROCEDURE <A NAME="GetCheckResources"><procedure>GetCheckResources</procedure></A> () =
  BEGIN
    LOCK mu DO
      IF inited [Flavor.Check] THEN RETURN END;
      pixmaps [Flavor.Check, FALSE, NE.Normal] :=
        VBTKitResources.GetPixmap (&quot;checkMarkOff&quot;);
      pixmaps [Flavor.Check, TRUE, NE.Normal] :=
        VBTKitResources.GetPixmap (&quot;checkMarkOn&quot;);
      pixmaps [Flavor.Check, FALSE, NE.Excited] :=
        VBTKitResources.GetPixmap (&quot;checkMarkOffExcited&quot;);
      pixmaps [Flavor.Check, TRUE, NE.Excited] :=
        VBTKitResources.GetPixmap (&quot;checkMarkOnExcited&quot;);
      inited [Flavor.Check] := TRUE;
    END
  END GetCheckResources;
</PRE>*************************  Box  ***************************

<P><PRE>PROCEDURE <A NAME="NewBox"><procedure>NewBox</procedure></A> (ch: VBT.T; shadow: Shadow.T := NIL): T =
  BEGIN
    GetBoxResources();
    RETURN
      NewWithPixmaps(
        ch, NewBlotVBT(shadow, Looks.Square, 0.5), Flavor.Box);
  END NewBox;

PROCEDURE <A NAME="GetBoxResources"><procedure>GetBoxResources</procedure></A> () =
  BEGIN
    LOCK mu DO
      IF inited[Flavor.Box] THEN RETURN END;
      pixmaps[Flavor.Box, FALSE, NE.Normal] :=
        VBTKitResources.GetPixmap(&quot;checkOff&quot;);
      styles[Flavor.Box, FALSE, NE.Normal] :=
        Shadow.Style.Raised;
      textures[Flavor.Box, FALSE, NE.Normal] := Pixmap.Empty;
      pixmaps[Flavor.Box, TRUE, NE.Normal] :=
        VBTKitResources.GetPixmap(&quot;checkOn&quot;);
      styles[Flavor.Box, TRUE, NE.Normal] :=
        Shadow.Style.Lowered;
      textures[Flavor.Box, TRUE, NE.Normal] := Pixmap.Solid;
      pixmaps[Flavor.Box, FALSE, NE.Excited] :=
        VBTKitResources.GetPixmap(&quot;checkOffExcited&quot;);
      styles[Flavor.Box, FALSE, NE.Excited] :=
        Shadow.Style.Raised;
      textures[Flavor.Box, FALSE, NE.Excited] := Pixmap.Gray;
      pixmaps[Flavor.Box, TRUE, NE.Excited] :=
        VBTKitResources.GetPixmap(&quot;checkOnExcited&quot;);
      styles[Flavor.Box, TRUE, NE.Excited] :=
        Shadow.Style.Lowered;
      textures[Flavor.Box, TRUE, NE.Excited] := Pixmap.Gray;
      inited[Flavor.Box] := TRUE;
    END
  END GetBoxResources;
</PRE>*************************  Radio  ***************************

<P><PRE>PROCEDURE <A NAME="NewBullet"><procedure>NewBullet</procedure></A> (ch: VBT.T; shadow: Shadow.T := NIL): T =
  BEGIN
    GetBulletResources ();
    RETURN NewWithPixmaps (
             ch, NewBlotVBT (shadow, Looks.Diamond, 0.25),
             Flavor.Bullet);
  END NewBullet;

PROCEDURE <A NAME="GetBulletResources"><procedure>GetBulletResources</procedure></A> () =
  BEGIN
    LOCK mu DO
      IF inited[Flavor.Bullet] THEN RETURN END;
      pixmaps[Flavor.Bullet, FALSE, NE.Normal] :=
        VBTKitResources.GetPixmap(&quot;radioOff&quot;);
      styles[Flavor.Bullet, FALSE, NE.Normal] :=
        Shadow.Style.Raised;
      textures[Flavor.Bullet, FALSE, NE.Normal] := Pixmap.Empty;
      pixmaps[Flavor.Bullet, TRUE, NE.Normal] :=
        VBTKitResources.GetPixmap(&quot;radioOn&quot;);
      styles[Flavor.Bullet, TRUE, NE.Normal] :=
        Shadow.Style.Lowered;
      textures[Flavor.Bullet, TRUE, NE.Normal] := Pixmap.Solid;
      pixmaps[Flavor.Bullet, FALSE, NE.Excited] :=
        VBTKitResources.GetPixmap(&quot;radioOffExcited&quot;);
      styles[Flavor.Bullet, FALSE, NE.Excited] :=
        Shadow.Style.Raised;
      textures[Flavor.Bullet, FALSE, NE.Excited] := Pixmap.Gray;
      pixmaps[Flavor.Bullet, TRUE, NE.Excited] :=
        VBTKitResources.GetPixmap(&quot;radioOnExcited&quot;);
      styles[Flavor.Bullet, TRUE, NE.Excited] :=
        Shadow.Style.Lowered;
      textures[Flavor.Bullet, TRUE, NE.Excited] := Pixmap.Gray;
      inited[Flavor.Bullet] := TRUE;
    END
  END GetBulletResources;
</PRE>************************* BlotVBT:  ***************************

<P> When the 2-1/2d look is supported, a BlotVBT displays as a
   2-1/2d square or diamond, whose interior color and style
   (e.g., lowered or raised) can be set dynamically.  Otherwise,
   when the 2-1/2d look is not supported, a pixmap is displayed.
   The shape of VBT is the shape of the pixmap (even when 2-1/2d
   is supported), with all stretch removed. 

<P><PRE>TYPE
  Looks = {Same, Square, Diamond};

TYPE
  BlotVBT = PixmapVBT.T BRANDED OBJECT
        shadow  : Shadow.T;
        looks   : Looks;
        inset   : REAL;
        pm      : Pixmap.T;
        style   : Shadow.Style;
        interior: Pixmap.T
      OVERRIDES
        shape   := BlotVBTShape;
        repaint := BlotVBTRepaint;
      END;

PROCEDURE <A NAME="NewBlotVBT"><procedure>NewBlotVBT</procedure></A> (shadow: Shadow.T := NIL;
                      looks : Looks    := Looks.Same;
                      inset : REAL     := 0.0         ): BlotVBT =
  VAR v := NEW(BlotVBT);
  BEGIN
    IF shadow = NIL THEN shadow := Shadow.None END;
    v.shadow := shadow;
    v.looks := looks;
    v.inset := inset;
    v.pm := Pixmap.Empty;
    v.style := Shadow.Style.Flat;
    v.interior := Pixmap.Empty;
    EVAL PixmapVBT.T.init(v, v.pm, v.shadow.bgFg, v.shadow.bg);
    RETURN v;
  END NewBlotVBT;

PROCEDURE <A NAME="BlotVBTPut"><procedure>BlotVBTPut</procedure></A> (v       : BlotVBT;
                      pm      : Pixmap.T;
                      style   : Shadow.Style;
                      interior: Pixmap.T      ) =
  BEGIN
    v.pm := pm;
    v.style := style;
    v.interior := interior;
    PixmapVBT.Put(v, v.pm);
    VBT.Mark(v);
  END BlotVBTPut;

PROCEDURE <A NAME="BlotVBTShape"><procedure>BlotVBTShape</procedure></A> (v: BlotVBT; ax: Axis.T; n: CARDINAL): VBT.SizeRange =
  VAR sr := PixmapVBT.T.shape(v, ax, n);
  BEGIN
    sr.hi := sr.lo + 1;
    RETURN sr;
  END BlotVBTShape;

PROCEDURE <A NAME="BlotVBTRepaint"><procedure>BlotVBTRepaint</procedure></A> (v: BlotVBT; READONLY rgn: Region.T) =
  BEGIN
    IF (v.looks = Looks.Same) OR NOT Shadow.Supported(v.shadow, v) THEN
      PixmapVBT.T.repaint(v, rgn)
    ELSE
      BlotVBTRepaint2 (v, rgn)
    END
  END BlotVBTRepaint;

PROCEDURE <A NAME="BlotVBTRepaint2"><procedure>BlotVBTRepaint2</procedure></A> (v: BlotVBT; READONLY clip: Region.T) =
  VAR dom, inner, outer: Rect.T; a: Rect.Partition;
  BEGIN
    dom := VBT.Domain(v);
    WITH
      dh = ROUND(VBT.MMToPixels(v, v.inset, Axis.T.Hor)),
      dv = ROUND(VBT.MMToPixels(v, v.inset, Axis.T.Ver)),
      bounds = Rect.Change(VBT.PixmapDomain(v, v.pm), dh, -dh, dv, -dv),
      delta = Point.Sub(Rect.Middle(dom), Rect.Middle(bounds))
    DO
      (* Now midpoint(v.pm) + delta = midpoint(dom) *)
      outer := Rect.Move(bounds, delta)
    END;
    Rect.Factor(Rect.Meet(dom, clip.r), outer, a, 0, 0);
    FOR i := 0 TO 4 DO
      IF i # 2 THEN
        VBT.PaintTexture(v, a[i], v.shadow.bg, Pixmap.Solid, Point.Origin);
      ELSE (* i = 2 *)
        WITH
          dh = ROUND(VBT.MMToPixels(v, ABS(v.shadow.size), Axis.T.Hor)),
          dv = ROUND(VBT.MMToPixels(v, ABS(v.shadow.size), Axis.T.Ver))
        DO
          inner := Rect.Change(outer, dh, -dh, dv, -dv)
        END;
        CASE v.looks OF
        | Looks.Same =&gt; &lt;* ASSERT FALSE *&gt;
        | Looks.Square =&gt;
            ShadowPaint.Border(v, clip, v.shadow, v.style, inner, outer);
            VBT.PaintTexture(v, Rect.Meet(clip.r, inner), v.shadow.bgFg,
                             v.interior, Point.Origin);
        | Looks.Diamond =&gt;
            ShadowPaint.Diamond(v, clip, v.shadow, v.style, inner, outer,
                                v.shadow.bgFg, v.interior);
        END
      END
    END
  END BlotVBTRepaint2;
</PRE>************************* Multi methods:  ***************************

<P><PRE>PROCEDURE <A NAME="Replace"><procedure>Replace</procedure></A> (m: MC; ch, new: VBT.T) =
  &lt;* FATAL Split.NotAChild *&gt;
  VAR hv := Filter.Child(m.vbt);
  BEGIN
    IF ch = NIL THEN
      Split.AddChild(hv, new)
    ELSE
      Split.Replace(hv, ch, new)
    END
  END Replace;

PROCEDURE <A NAME="Succ"><procedure>Succ</procedure></A> (m: MC; ch: VBT.T): VBT.T =
  VAR hv := Filter.Child(m.vbt);
  BEGIN
    IF ch = NIL THEN RETURN Split.Nth(hv, 1) ELSE RETURN NIL END
  END Succ;

BEGIN
END MarginFeedbackVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
