<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/MultiClass.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/MultiClass.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                          </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;
</PRE> An arbitrary VBT is made into a multi by providing a set of
   methods for maintaining the logical structure. The methods are used
   for replacing, inserting, traversing, and performing other common
   operations on the children.
<P>
   In a language with multiple inheritance, multis would simply
   inherit different methods from different parent-types.  In
   Modula-3, however, we achieve this effect by creating an instance
   <CODE>mc</CODE> of type <CODE>MultiClass.T</CODE>, and attaching <CODE>mc</CODE> to a VBT <CODE>v</CODE> by way
   of <CODE>v</CODE>'s property set.  The object <CODE>mc</CODE> points back to <CODE>v</CODE> via the
   field <CODE>mc.vbt</CODE>.
<P>
   Clients defining their own multis can make a VBT <CODE>v</CODE> ``into'' a
   multi by calling <CODE>Be(v,mc)</CODE> during the initialization of the VBT.
   They must call <CODE>BeChild</CODE> on each new child when it is inserted, and
   <CODE>UnChild</CODE> when a child of a multi is deleted.
   <CODE>MultiFilter.Replace</CODE>, <CODE>MultiSplit.Replace</CODE>, and
   <CODE>MultiSplit.Insert</CODE> all do this automatically, and
   <CODE>MultiSplit.Insert</CODE> calls <CODE>BeChild</CODE>. 

<P><PRE>INTERFACE <interface><A HREF="MultiClass.m3">MultiClass</A></interface>;

IMPORT <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

TYPE
  T = ROOT OBJECT
        vbt: VBT.T;              (* READONLY *)
      METHODS
        &lt;* LL = VBT.mu *&gt;
        replace (ch, new: VBT.T);
        insert  (pred, new: VBT.T);
        move    (pred, ch: VBT.T);
        succ    (ch: VBT.T): VBT.T;
        pred    (ch: VBT.T): VBT.T;
        nth     (n: CARDINAL): VBT.T;
        index   (ch: VBT.T): CARDINAL;
      END;
</PRE> \subsubsection{The MultiSplit methods} 

<P> The methods implement the behavior in the <CODE>MultiSplit</CODE>
   interface.
<P>
   The method call <CODE>mc.replace(ch,new)</CODE> implements the operation
<PRE>
      MultiSplit.Replace(mc.vbt, ch, new)
   </PRE>
and the call <CODE>mc.replace(ch,NIL)</CODE> implements
<PRE>
      MultiSplit.Delete(mc.vbt, ch)
   </PRE>
Before calling the method, the generic code in the <CODE>MultiSplit</CODE>
   interface checks that <CODE>ch</CODE> is a multi-child of <CODE>mc.vbt</CODE>, and, if
   <CODE>new</CODE> is not <CODE>NIL</CODE>, calls <CODE>BeChild(mc.vbt, new)</CODE>.  After calling
   the method, the generic code calls <CODE>UnChild(mc.vbt, ch)</CODE>, if <CODE>ch</CODE>
   was not <CODE>NIL</CODE>.
<P>
   Similarly, the method call <CODE>mc.insert(pred,new)</CODE> implements the
   operation 
<PRE>
      MultiSplit.Insert(mc.vbt, pred, new) 
   </PRE>
Before calling the method, the generic code in <CODE>MultiSplit</CODE> checks
   that <CODE>pred</CODE> is a multi-child of <CODE>mc.vbt</CODE> and calls <CODE>BeChild(mc.vbt,
   new)</CODE>.  If <CODE>new</CODE> is <CODE>NIL</CODE>, <CODE>MultiSplit.Insert</CODE> raises a runtime
   exception.
<P>
   The default methods for <CODE>replace</CODE> and <CODE>insert</CODE> are both equal
   to <CODE>NIL</CODE>, so every multi-split needs to override these
   methods.
<P>
   The method call <CODE>mc.move(pred, ch)</CODE> implements
<PRE>
      MultiSplit.Move(mc.vbt, pred, ch)
   </PRE>
Before calling the method, the generic code in <CODE>MultiSplit</CODE>
   verifies that <CODE>ch</CODE> and <CODE>pred</CODE> are both multi-children of <CODE>mc.vbt</CODE>
   (or <CODE>NIL</CODE>, in the case of <CODE>pred</CODE>).  The call to <CODE>mc.move</CODE> is
   avoided if <CODE>pred=ch</CODE> or <CODE>mc.succ(pred)=ch</CODE>.
<P>
   The default <CODE>move</CODE> method for a <CODE>MultiClass.T</CODE> object <CODE>mc</CODE> is
   simply a call to <CODE>mc.replace(ch, NIL)</CODE> followed by a call to
   <CODE>mc.insert(pred, ch)</CODE>.
<P>
   This default method is naive on two fronts. One, it is not
   particularly efficient since the tree of VBTs is typically being
   manipulated twice. Two, and more importantly, some multi-splits
   will take action as part of the <CODE>replace</CODE> method (e.g.,
   reallocating the screen layout of its children) that is not
   ``undone'' by the subsequent call to the <CODE>insert</CODE> method.
<P>
   The method calls 
<P>
<PRE>
      mc.succ(ch)
      mc.pred(ch)
      mc.nth(n)
      mc.index(ch)
</PRE>
   all implement the corresponding operations in the <CODE>MultiSplit</CODE>
   interface.  The default <CODE>pred</CODE>, <CODE>nth</CODE> and <CODE>index</CODE> methods are
   implemented by repeatedly calling the <CODE>succ</CODE> method.  The default
   <CODE>succ</CODE> method finds the successor of <CODE>ch</CODE> for the <CODE>MultiClass.T</CODE>
   object <CODE>mc</CODE> by a depth-first walk of <CODE>mc.vbt</CODE>'s descendants,
   starting after <CODE>ch</CODE>, and stopping at the first VBT <CODE>w</CODE> for which
   <CODE>IsChild(mc.vbt, w)</CODE> returns <CODE>TRUE</CODE>, or when all of <CODE>mc.vbt</CODE>'s
   descendants have been visited, in which case, <CODE>ch</CODE> has no successor
   so <CODE>NIL</CODE> is returned.  In practice, the default <CODE>succ</CODE> method seems
   to work nearly all of the time; however, there is often a more
   efficient way to implement a <CODE>succ</CODE> method for any particular
   multi-split. 

<P> \subsubsection{The MultiFilter methods} 

<P><PRE>TYPE
  <A HREF="MultiClass.m3#Split">Split</A> &lt;: T;
  <A HREF="MultiClass.m3#Filter">Filter</A> &lt;: Split;
</PRE> The default methods for a <CODE>Filter</CODE> are the same as for a
   <CODE>Split</CODE>, except that the <CODE>insert</CODE> method has a default.  Thus,
   you only need to override the <CODE>replace</CODE> method of a
   multi-filter.
<P>
   The default method call <CODE>mc.insert(pred, new)</CODE> is
<P>
<PRE>
      mc.replace (mc.succ(pred), new)
</PRE>
   Also, the <CODE>move</CODE> method is never run; the generic code in
   <CODE>Split.Move</CODE> ensures this. 

<P> \subsubsection{Procedures for creating multis} 

<P><PRE>PROCEDURE <A HREF="MultiClass.m3#Be">Be</A> (v: VBT.T; mc: T);
&lt;* LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Make <CODE>v</CODE> into a multi by storing <CODE>mc</CODE> on <CODE>v</CODE>'s property set
   and setting <CODE>mc.vbt</CODE> to <CODE>v</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MultiClass.m3#Resolve">Resolve</A> (v: VBT.T): T;
&lt;* LL.sup &lt; v *&gt;
</PRE><BLOCKQUOTE><EM> Return the multiclass of <CODE>v</CODE>, that is, the <CODE>mc</CODE> for which
   <CODE>Be(v,mc)</CODE> was previously called.  Return <CODE>NIL</CODE> if there is no
   such <CODE>mc</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MultiClass.m3#BeChild">BeChild</A> (v: VBT.T; ch: VBT.T);
&lt;* LL.sup &lt; ch *&gt;
</PRE><BLOCKQUOTE><EM> Make <CODE>ch</CODE> into one of <CODE>v</CODE>'s children that is exposed to the
   client via the <CODE>MultiSplit</CODE> or <CODE>MultiFilter</CODE> interfaces.  
   It is possible for <CODE>ch</CODE> to
   be a child of more than one multi, and it is possible that
   <CODE>ch</CODE> is not related to <CODE>v</CODE> in the VBT hierarchy. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MultiClass.m3#UnChild">UnChild</A> (v: VBT.T; ch: VBT.T);
&lt;* LL.sup &lt; ch *&gt;
</PRE><BLOCKQUOTE><EM> Unmark <CODE>ch</CODE> as one of <CODE>v</CODE>'s children that is exposed to the
   client via the <CODE>MultiSplit</CODE> or <CODE>MultiFilter</CODE> interfaces. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MultiClass.m3#IsChild">IsChild</A> (v: VBT.T; ch: VBT.T): BOOLEAN;
&lt;* LL.sup &lt; ch *&gt;
</PRE><BLOCKQUOTE><EM> Return <CODE>TRUE</CODE> iff <CODE>BeChild(v,ch)</CODE> was previously invoked and
   <CODE>UnChild(v,ch)</CODE> has not been subsequently called. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MultiClass.m3#Parents">Parents</A> (ch: VBT.T): RefList.T (* of VBT.T *);
&lt;* LL.sup &lt; ch *&gt;
</PRE><BLOCKQUOTE><EM> Return a list of VBTs for which <CODE>IsChild(v,ch)</CODE> is <CODE>TRUE</CODE>.
   The list may be <CODE>NIL</CODE>. </EM></BLOCKQUOTE><PRE>

END MultiClass.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
