<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/MultiClass.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/MultiClass.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="MultiClass.i3">MultiClass</A></implements></module>;

IMPORT <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="MultiSplit.i3">MultiSplit</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;
IMPORT <A HREF="../../ui/src/split/Split.i3">Split</A> AS TrestleSplit;

EXCEPTION FatalError; &lt;* FATAL FatalError *&gt;

REVEAL
  <A NAME="Split">Split</A> = T BRANDED OBJECT
      OVERRIDES
</PRE><BLOCKQUOTE><EM><P>
        replace := NIL;
        insert  := NIL;
</EM></BLOCKQUOTE><PRE>
        move    := MoveDefault;
        succ    := SuccDefault;
        pred    := PredDefault;
        nth     := NthDefault;
        index   := IndexDefault;
      END;

TYPE
  Prop = REF RECORD t: T END;
  ChProp = REF RECORD parents: RefList.T (* of VBT.T *) END;

PROCEDURE <A NAME="Be"><procedure>Be</procedure></A> (vbt: VBT.T; t: T) =
  BEGIN
    t.vbt := vbt;
    VBT.PutProp (vbt, NEW (Prop, t := t))
  END Be;

PROCEDURE <A NAME="Resolve"><procedure>Resolve</procedure></A> (vbt: VBT.T): T =
  VAR prop: Prop := VBT.GetProp (vbt, TYPECODE (Prop));
  BEGIN
    IF prop = NIL THEN RETURN NIL ELSE RETURN prop.t END
  END Resolve;

PROCEDURE <A NAME="BeChild"><procedure>BeChild</procedure></A> (vbt: VBT.T; ch: VBT.T) =
  VAR chProp: ChProp := VBT.GetProp (ch, TYPECODE (ChProp));
  BEGIN
    IF chProp = NIL THEN
      chProp := NEW (ChProp);
      VBT.PutProp (ch, chProp);
    END;
    chProp.parents := RefList.Cons (vbt, chProp.parents);
  END BeChild;

PROCEDURE <A NAME="UnChild"><procedure>UnChild</procedure></A> (vbt: VBT.T; ch: VBT.T) =
  VAR chProp: ChProp := VBT.GetProp (ch, TYPECODE (ChProp));
  PROCEDURE remove (VAR list: RefList.T) =
    BEGIN
      IF list = NIL THEN         (* skip *)
      ELSIF list.head = vbt THEN
        list := list.tail
      ELSE
        remove (list.tail)
      END
    END remove;
  BEGIN
    remove (chProp.parents)
  END UnChild;

PROCEDURE <A NAME="IsChild"><procedure>IsChild</procedure></A> (vbt: VBT.T; ch: VBT.T): BOOLEAN =
  BEGIN
    RETURN RefList.Member(Parents(ch), vbt)
  END IsChild;

PROCEDURE <A NAME="Parents"><procedure>Parents</procedure></A> (ch: VBT.T): RefList.T =
  VAR chProp: ChProp := VBT.GetProp (ch, TYPECODE (ChProp));
  BEGIN
      IF chProp = NIL THEN RETURN NIL ELSE RETURN chProp.parents END
  END Parents;

PROCEDURE <A NAME="MoveDefault"><procedure>MoveDefault</procedure></A> (t: Split; pred, ch: VBT.T) =
  &lt;* FATAL MultiSplit.NotAChild *&gt;
  BEGIN
    MultiSplit.Delete (t.vbt, ch);
    MultiSplit.Insert (t.vbt, pred, ch);
  END MoveDefault;

PROCEDURE <A NAME="SuccDefault"><procedure>SuccDefault</procedure></A> (t: Split; ch: VBT.T): VBT.T =
  &lt;* FATAL TrestleSplit.NotAChild *&gt;
  VAR chP, oldP, p: VBT.T;
  BEGIN
    chP := ch;
    IF chP = NIL THEN p := t.vbt ELSE p := VBT.Parent(chP) END;
    REPEAT
      chP := TrestleSplit.Succ(p, chP);
      WHILE (chP = NIL) AND (p # t.vbt) DO
        oldP := p;
        p := VBT.Parent(p);
        chP := TrestleSplit.Succ(p, oldP);
      END;
      WHILE (chP # NIL) AND (NOT IsChild(t.vbt, chP))
              AND HasChild(chP) DO
        p := chP;
        chP := TrestleSplit.Succ(p, NIL);
      END;
    UNTIL (chP = NIL) OR IsChild(t.vbt, chP);
    RETURN chP
  END SuccDefault;

PROCEDURE <A NAME="HasChild"><procedure>HasChild</procedure></A> (v: VBT.T): BOOLEAN =
  &lt;* FATAL TrestleSplit.NotAChild *&gt;
  BEGIN
    RETURN ISTYPE (v, VBT.Split) AND TrestleSplit.Succ(v, NIL) # NIL
</PRE><BLOCKQUOTE><EM><P>
     WITH t = Resolve(v) DO
      RETURN (t # NIL) AND (t.succ(NIL) # NIL)
    END
</EM></BLOCKQUOTE><PRE>
  END HasChild;

PROCEDURE <A NAME="PredDefault"><procedure>PredDefault</procedure></A> (t: Split; ch: VBT.T): VBT.T =
  VAR next, res: VBT.T;
  BEGIN
    next := t.succ(NIL);
    WHILE next # NIL AND next # ch DO
      res := next;
      next := t.succ(res)
    END;
    IF next = ch THEN RETURN res ELSE RAISE FatalError END
  END PredDefault;

PROCEDURE <A NAME="NthDefault"><procedure>NthDefault</procedure></A> (t: Split; n: CARDINAL): VBT.T =
  VAR ch: VBT.T;
  BEGIN
    ch := t.succ(NIL);
    WHILE ch # NIL AND n # 0 DO DEC(n); ch := t.succ(ch) END;
    RETURN ch
  END NthDefault;

PROCEDURE <A NAME="IndexDefault"><procedure>IndexDefault</procedure></A> (t: Split; ch: VBT.T): CARDINAL =
  VAR res := 0; chP := t.succ (NIL);
  BEGIN
    WHILE chP # ch AND chP # NIL DO INC (res); chP := t.succ (chP) END;
    IF chP = ch THEN RETURN res ELSE RAISE FatalError END
  END IndexDefault;

REVEAL <A NAME="Filter">Filter</A> =
    Split BRANDED OBJECT OVERRIDES insert := FilterInsert; END;

PROCEDURE <A NAME="FilterInsert"><procedure>FilterInsert</procedure></A> (t: Filter; pred, new: VBT.T) =
  BEGIN
    t.replace(t.succ(pred), new);
  END FilterInsert;

BEGIN
END MultiClass.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
