<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/MultiFilter.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/MultiFilter.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;
</PRE> The <CODE>MultiFilter</CODE> interface defines the functionality that is common 
   to all clients of multi-filters; namely, retrieving and changing a 
   multi-filter's multi-child. 
<P>
   A multi-filter is a multi-split with at most one child. Thus,
   you can use the procedures in the <CODE>MultiSplit</CODE> interface on a VBT
   that is a multi-filter. The semantics of the <CODE>MultiSplit</CODE> procedures
   on a multi-filter should be obvious, with the following exceptions: 
   <CODE>MultiSplit.Move</CODE> on a multi-filter is a no-op, and <CODE>MultiSplit.Insert</CODE> 
   on a multi-filter replaces the child, if any. 

<P><PRE>INTERFACE <interface><A HREF="MultiFilter.m3">MultiFilter</A></interface>;

IMPORT <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

TYPE T = VBT.T;
</PRE><BLOCKQUOTE><EM> A <CODE>MultiFilter.T</CODE> is a <CODE>VBT.T</CODE> with a <CODE>MultiClass.Filter</CODE> in its
   property set. </EM></BLOCKQUOTE><PRE>
</PRE> The following procedures can accept either a <CODE>MultiFilter.T</CODE>
   or a <CODE>Filter.T</CODE> as the first argument.  If the first argument
   is not a <CODE>MultiFilter.T</CODE>, the procedure just calls the corresponding
   procedure in the <CODE>Filter</CODE> interface. 

<P><PRE>PROCEDURE <A HREF="MultiFilter.m3#Child">Child</A> (v: VBT.T): VBT.T;
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the child of <CODE>v</CODE>, or <CODE>NIL</CODE> if there is no child. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MultiFilter.m3#Replace">Replace</A> (v, ch: VBT.T): VBT.T;
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Replace <CODE>v</CODE>'s child by <CODE>ch</CODE> and return <CODE>v</CODE>'s  old child. </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>MultiFilter.Replace</CODE> is similar to <CODE>MultiSplit.Replace</CODE>,
   except that it returns the old multi-child instead of taking
   the old multi-child as an argument, and if <CODE>ch</CODE> is <CODE>NIL</CODE> it is
   similar to <CODE>MultiSplit.Delete</CODE>. 

<P><PRE>END MultiFilter.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
