<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/MultiSplit.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/MultiSplit.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;
</PRE> The <CODE>MultiSplit</CODE> interface defines operations that are common to
   all multi-splits, such as enumerating and deleting children. 

<P><PRE>INTERFACE <interface><A HREF="MultiSplit.m3">MultiSplit</A></interface>;

IMPORT <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

EXCEPTION NotAChild;

TYPE T = VBT.T;
</PRE><BLOCKQUOTE><EM> A <CODE>MultiSplit.T</CODE> is a <CODE>VBT.T</CODE> with a <CODE>MultiClass.Split</CODE> in its
   property set. </EM></BLOCKQUOTE><PRE>
</PRE> All of the procedures in this interface can accept either a
   <CODE>MultiSplit.T</CODE> or a <CODE>Split.T</CODE> as the first argument.  If the first
   argument is not a <CODE>MultiSplit.T</CODE>, the procedure just calls the
   corresponding procedure in the <CODE>Split</CODE> interface, re-raising any
   <CODE>Split.NotAChild</CODE> exceptions as <CODE>NotAChild</CODE> exceptions.
<P>
   Unlike the procedures in the <CODE>Split</CODE> interface, the procedures here
   do not perform any VBT operations.  For example, <CODE>Split.Delete(v, ch)</CODE>
   deletes the child <CODE>ch</CODE> of split <CODE>v</CODE>, detaches <CODE>ch</CODE>, and marks
   <CODE>v</CODE> for redisplay, whereas <CODE>MultiSplit.Delete</CODE> just deletes the
   multi-child <CODE>ch</CODE> of multi-split <CODE>v</CODE>, without detaching <CODE>ch</CODE> or
   marking <CODE>v</CODE> for redisplay.  The <CODE>MultiClass</CODE> methods of <CODE>v</CODE> that
   implement the <CODE>Delete</CODE> functionality will most likely manipulate
   the VBT tree using <CODE>Split.Delete</CODE> (or other calls to <CODE>Split</CODE> and
   <CODE>Filter</CODE> as appropriate), so that <CODE>v</CODE> will be marked and <CODE>ch</CODE> will
   be detached, as one would expect. 

<P>
<P><PRE>PROCEDURE <A HREF="MultiSplit.m3#Succ">Succ</A> (v: VBT.T; ch: VBT.T): VBT.T
  RAISES {NotAChild};
&lt;* LL &gt;= {VBT.mu} *&gt;
</PRE><BLOCKQUOTE><EM> Return the child of <CODE>v</CODE> that follows the child <CODE>ch</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> The successor of <CODE>NIL</CODE> is the first child; the successor of 
   the last child is <CODE>NIL</CODE>; the successor of <CODE>NIL</CODE> is <CODE>NIL</CODE> if there 
   are no children. 

<P><PRE>PROCEDURE <A HREF="MultiSplit.m3#Pred">Pred</A> (v: VBT.T; ch: VBT.T): VBT.T
  RAISES {NotAChild};
&lt;* LL &gt;= {VBT.mu} *&gt;
</PRE><BLOCKQUOTE><EM> Return the child of <CODE>v</CODE> that precedes the child <CODE>ch</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> More precisely, <CODE>Pred(v,ch) = x</CODE> iff <CODE>Succ(v,x) = ch</CODE>. 

<P><PRE>PROCEDURE <A HREF="MultiSplit.m3#NumChildren">NumChildren</A> (v: VBT.T): CARDINAL
  RAISES {NotAChild};
&lt;* LL &gt;= {VBT.mu} *&gt;
</PRE><BLOCKQUOTE><EM> Return the number of children of <CODE>v</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MultiSplit.m3#Nth">Nth</A> (v: VBT.T; n: CARDINAL): VBT.T;
&lt;* LL &gt;= {VBT.mu} *&gt;
</PRE><BLOCKQUOTE><EM> Return the child of <CODE>v</CODE> with index <CODE>n</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> More precisely, <CODE>Nth(v, n)</CODE> is the child of <CODE>v</CODE> with <CODE>n</CODE> predecessors,
   or <CODE>NIL</CODE> if <CODE>v</CODE> has at most <CODE>n</CODE> children. 

<P><PRE>PROCEDURE <A HREF="MultiSplit.m3#Index">Index</A> (v: VBT.T; ch: VBT.T): CARDINAL
  RAISES {NotAChild};
&lt;* LL &gt;= {VBT.mu} *&gt;
</PRE><BLOCKQUOTE><EM> Return the index of <CODE>v</CODE>'s child <CODE>ch</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> In other words, <CODE>Index(v, ch)</CODE> is the value <CODE>n</CODE> such that <CODE>Nth(v, n) = ch</CODE>.
   It is always true that <CODE>Index(v, NIL)</CODE> equals <CODE>NumChildren(v)</CODE>. 

<P><PRE>PROCEDURE <A HREF="MultiSplit.m3#Locate">Locate</A> (v: VBT.T; READONLY pt: Point.T): VBT.T;
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the child of <CODE>v</CODE> that would receive a mouse click at
   point <CODE>pt</CODE>, or <CODE>NIL</CODE> if there is no such child. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MultiSplit.m3#Delete">Delete</A>(v: T; ch: VBT.T)
  RAISES {NotAChild};
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Delete the child <CODE>ch</CODE> of <CODE>v</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MultiSplit.m3#Replace">Replace</A> (v: VBT.T; ch, new: VBT.T)
  RAISES {NotAChild};
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Replace child <CODE>ch</CODE> of <CODE>v</CODE> with <CODE>new</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MultiSplit.m3#Insert">Insert</A> (v: VBT.T; pred, new: VBT.T)
  RAISES {NotAChild};
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Add <CODE>new</CODE> as a child of <CODE>v</CODE> following <CODE>pred</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> \sloppy Some multi-splits can accommodate only a bounded number of
   children.  Whenever <CODE>Insert(v,pred,new)</CODE> is applied to a multi-split
   <CODE>v</CODE> that cannot accommodate an additional child, then <CODE>pred</CODE>
   (or the original first child, if <CODE>pred=NIL</CODE>) is deleted from
   the multi-split.  The precise semantics are defined by the
   individual multi-splits. 

<P>
<P><PRE>PROCEDURE <A HREF="MultiSplit.m3#Move">Move</A> (v: VBT.T; pred, ch: VBT.T)
  RAISES {NotAChild};
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Move child <CODE>ch</CODE> of <CODE>v</CODE> to follow <CODE>pred</CODE>.  <CODE>ch</CODE> and, if
   non-<CODE>NIL</CODE>, <CODE>pred</CODE>, must be children of <CODE>v</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MultiSplit.m3#AddChildArray">AddChildArray</A> (
    v: VBT.T;
    READONLY new: ARRAY OF VBT.T);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Insert the non-<CODE>NIL</CODE> elements of <CODE>new</CODE> at the end of <CODE>v</CODE>'s 
   list of children. </EM></BLOCKQUOTE><PRE>
</PRE> Procedure <CODE>AddChildArray</CODE> is equivalent to 
<PRE>
       pred := Pred(v, NIL);
       FOR i := FIRST(new) TO LAST(new) DO
         IF new[i] # NIL THEN
           Insert(v, pred, new[i]);
           pred := new[i]
         END
       END
   

<P><PRE>PROCEDURE <A HREF="MultiSplit.m3#AddChild">AddChild</A> (
    v: VBT.T;
    n0, n1, n2, n3, n4, n5, n6, n7, n8, n9: VBT.T := NIL);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Insert the non-<CODE>NIL</CODE> parameters as children to <CODE>v</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> Procedure <CODE>AddChild</CODE> is equivalent to 
<PRE>
       AddChildArray(v,
         ARRAY OF VBT.T{n0, n1, n2, n3, n4, n5, n6, n7, n8, n9})
   

<P><PRE>END MultiSplit.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
