<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/MultiSplit.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/MultiSplit.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="MultiSplit.i3">MultiSplit</A></implements></module>;

IMPORT <A HREF="MultiClass.i3">MultiClass</A>, <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="../../ui/src/split/Split.i3">Split</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

EXCEPTION FatalError; &lt;* FATAL FatalError *&gt;

PROCEDURE <A NAME="Delete"><procedure>Delete</procedure></A> (v: VBT.T; ch: VBT.T) RAISES {NotAChild} =
  BEGIN
    Replace(v, ch, NIL)
  END Delete;

PROCEDURE <A NAME="Replace"><procedure>Replace</procedure></A> (v: T; ch, new: VBT.T) RAISES {NotAChild} =
  BEGIN
    WITH m = MultiClass.Resolve(v) DO
      IF m = NIL THEN
        TRY
          Split.Replace(v, ch, new)
        EXCEPT
        | Split.NotAChild =&gt; RAISE NotAChild
        END
      ELSE
        IF (ch # NIL) AND (NOT MultiClass.IsChild(v, ch)) THEN
          RAISE NotAChild
        END;
        IF new # NIL THEN MultiClass.BeChild(v, new); END;
        m.replace(ch, new);
        IF ch # NIL THEN MultiClass.UnChild(v, ch) END;
      END
    END
  END Replace;

PROCEDURE <A NAME="Succ"><procedure>Succ</procedure></A> (v: VBT.T; ch: VBT.T): VBT.T RAISES {NotAChild} =
  BEGIN
    WITH m = MultiClass.Resolve(v) DO
      IF m = NIL THEN
        TRY
          RETURN Split.Succ(v, ch)
        EXCEPT
        | Split.NotAChild =&gt; RAISE NotAChild
        END
      ELSE
        IF (ch # NIL) AND (NOT MultiClass.IsChild(v, ch)) THEN
          RAISE NotAChild
        END;
        RETURN m.succ(ch);
      END
    END
  END Succ;

PROCEDURE <A NAME="Pred"><procedure>Pred</procedure></A> (v: VBT.T; ch: VBT.T): VBT.T RAISES {NotAChild} =
  BEGIN
    WITH m = MultiClass.Resolve(v) DO
      IF m = NIL THEN
        TRY
          RETURN Split.Pred(v, ch)
        EXCEPT
        | Split.NotAChild =&gt; RAISE NotAChild
        END
      ELSE
        IF (ch # NIL) AND (NOT MultiClass.IsChild(v, ch)) THEN
          RAISE NotAChild
        END;
        RETURN m.pred(ch);
      END
    END
  END Pred;

PROCEDURE <A NAME="Nth"><procedure>Nth</procedure></A> (v: VBT.T; n: CARDINAL): VBT.T =
  BEGIN
    WITH m = MultiClass.Resolve(v) DO
      IF m = NIL THEN RETURN Split.Nth(v, n) ELSE RETURN m.nth(n) END
    END
  END Nth;

PROCEDURE <A NAME="NumChildren"><procedure>NumChildren</procedure></A> (v: VBT.T): CARDINAL RAISES {NotAChild} =
  BEGIN
    RETURN Index (v, NIL)
  END NumChildren;

PROCEDURE <A NAME="Index"><procedure>Index</procedure></A> (v: VBT.T; ch: VBT.T): CARDINAL RAISES {NotAChild} =
  BEGIN
    WITH m = MultiClass.Resolve(v) DO
      IF m = NIL THEN
        TRY
          RETURN Split.Index(v, ch)
        EXCEPT
        | Split.NotAChild =&gt; RAISE NotAChild
        END
      ELSE
        IF (ch # NIL) AND (NOT MultiClass.IsChild(v, ch)) THEN
          RAISE NotAChild
        END;
        RETURN m.index(ch);
      END
    END
  END Index;

PROCEDURE <A NAME="Locate"><procedure>Locate</procedure></A> (v: VBT.T; READONLY pt: Point.T): VBT.T =
  VAR ch: VBT.T;
  BEGIN
    WITH m = MultiClass.Resolve(v) DO
      ch := Split.Locate(v, pt);
      WHILE ch # NIL DO
        IF MultiClass.IsChild(v, ch) THEN RETURN ch END;
        ch := Split.Locate(ch, pt);
      END;
      RETURN NIL;
    END
  END Locate;

PROCEDURE <A NAME="Move"><procedure>Move</procedure></A> (v: T; pred, ch: VBT.T) RAISES {NotAChild} =
  BEGIN
    WITH m = MultiClass.Resolve(v) DO
      IF m = NIL THEN
        TRY
          Split.Move(v, pred, ch)
        EXCEPT
        | Split.NotAChild =&gt; RAISE NotAChild
        END
      ELSE
        IF ch = NIL THEN RAISE FatalError END;
        IF NOT MultiClass.IsChild(v, ch) THEN RAISE NotAChild END;
        IF (pred # NIL) AND (NOT MultiClass.IsChild(v, pred)) THEN
          RAISE NotAChild
        END;
        IF pred # ch AND m.succ(pred) # ch THEN m.move(pred, ch) END
      END
    END
  END Move;

PROCEDURE <A NAME="Insert"><procedure>Insert</procedure></A> (v: T; pred, new: VBT.T) RAISES {NotAChild} =
  BEGIN
    IF new = NIL THEN RAISE FatalError END;
    WITH m = MultiClass.Resolve(v) DO
      IF m = NIL THEN
        TRY
          Split.Insert(v, pred, new)
        EXCEPT
        | Split.NotAChild =&gt; RAISE NotAChild
        END
      ELSIF pred # NIL AND NOT MultiClass.IsChild(v, pred) THEN
        RAISE NotAChild
      ELSE
        MultiClass.BeChild(v, new);
        m.insert(pred, new);
      END
    END
  END Insert;

PROCEDURE <A NAME="AddChildArray"><procedure>AddChildArray</procedure></A> (v: T; READONLY new: ARRAY OF VBT.T) =
  &lt;* FATAL NotAChild *&gt; (* Can't happen, since we start at the top. *)
  VAR pred: VBT.T;
  BEGIN
    pred := Pred (v, NIL);
    FOR i := 0 TO LAST (new) DO
      IF new [i] # NIL THEN Insert (v, pred, new [i]); pred := new [i] END
    END
  END AddChildArray;

PROCEDURE <A NAME="AddChild"><procedure>AddChild</procedure></A> (v: T;
                    new0, new1, new2, new3, new4, new5, new6, new7, new8,
                      new9: VBT.T := NIL) =
  VAR a: ARRAY [0 .. 9] OF VBT.T;
  BEGIN
    a[0] := new0;
    a[1] := new1;
    a[2] := new2;
    a[3] := new3;
    a[4] := new4;
    a[5] := new5;
    a[6] := new6;
    a[7] := new7;
    a[8] := new8;
    a[9] := new9;
    AddChildArray(v, a)
  END AddChild;

BEGIN
END MultiSplit.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
