<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/NumericVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/NumericVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;
</PRE> A <CODE>NumericVBT</CODE> is a VBT class for displaying and changing an
   integer within some range.  A <CODE>NumericVBT</CODE> has three parts (from
   left to right): a minus button, a type-in field, and a plus button.
   The type-in field is restricted to contain an integer within a
   specified range; it can be changed by editing (it uses the default
   editing model), or by typing Return, or by clicking on the plus or
   minus buttons.  The plus/minus buttons are trill buttons, so
   clicking and holding will cause the value of the <CODE>NumericVBT</CODE> to
   continuously increment/decrement.
<P>
   The <CODE>NumericVBT</CODE> has a <CODE>callback</CODE> method that is called each time
   the user types Return or click the plus or minus button.  The
   default callback method is a no-op. 

<P><PRE>INTERFACE <interface><A HREF="NumericVBT.m3">NumericVBT</A></interface>;

IMPORT <A HREF="../../vbtkitutils/src/AnyEvent.i3">AnyEvent</A>, <A HREF="../../ui/src/split/Filter.i3">Filter</A>, <A HREF="../../ui/src/vbt/Font.i3">Font</A>, <A HREF="Shadow.i3">Shadow</A>, <A HREF="../../etext/src/TypeinVBT.i3">TypeinVBT</A>,  <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

TYPE
  <A HREF="NumericVBT.m3#T">T</A> &lt;: Public;
  Public = Filter.T OBJECT
             typein: Typein := NIL; (* READONLY after init *)
           METHODS
             &lt;* LL.sup &lt;= VBT.mu *&gt;
             init (min       : INTEGER  := FIRST (INTEGER);
                   max       : INTEGER  := LAST (INTEGER);
                   allowEmpty: BOOLEAN  := FALSE;
                   naked     : BOOLEAN  := FALSE;
                   font      : Font.T   := Font.BuiltIn;
                   shadow    : Shadow.T := NIL              ):
               T;
             callback (event: AnyEvent.T);
           END;
  <A HREF="NumericVBT.m3#Typein">Typein</A> &lt;: TypeinVBT.T;
</PRE> The call to <CODE>v.init(...)</CODE> initializes <CODE>v</CODE> as a <CODE>NumericVBT</CODE>
   and returns <CODE>v</CODE>.  The integer stored with <CODE>v</CODE>, referred to as
   ``the value in'' <CODE>v</CODE>, is constrained to be in the range
<PRE>
      [min .. MAX (min, max)]
   </PRE>
The initial value in <CODE>v</CODE> is equal to <CODE>min</CODE>.
<P>
   If <CODE>allowEmpty</CODE> is <CODE>TRUE</CODE>, then ``empty'' (no text in the type-in
   area) is a distinct and valid state, and can be tested by the
   procedure <CODE>IsEmpty</CODE>.  The call <CODE>Get(v)</CODE> in the empty state will
   return <CODE>FIRST(INTEGER)</CODE>, regardless of whether this is in the valid
   range. Clicking the plus/minus buttons has no effect when <CODE>v</CODE> is in
   the empty state.
<P>
   If <CODE>naked</CODE> is <CODE>TRUE</CODE>, then the numeric interactor appears as just a
   type-in field, without plus or minus buttons.
<P>
   IF <CODE>v.typein</CODE> is <CODE>NIL</CODE> when <CODE>v.init(...)</CODE> is called, then a new
   <CODE>Typein</CODE> will be allocated and assigned to <CODE>v.typein</CODE>.  Whether or
   not it was <CODE>NIL</CODE> at the time of the call, it will be initialized via
<PRE>
      v.typein(FALSE, 1.5, 1.5, font, shadow)
   </PRE>
That is, it will not be expandable, its margins will be 1.5 mm,
   and <CODE>font</CODE> and <CODE>shadow</CODE> will determine its appearance.
<P>
   The implementation calls
<PRE>
      v.callback(event)
   </PRE>
when the user clicks the plus/minus buttons, or types Return in the
   type-in area.  The <CODE>event</CODE> parameter reports the details of the
   event as either an <CODE>AnyEvent.Mouse</CODE> (clicking on the plus/minus
   buttons) or an <CODE>AnyEvent.Key</CODE> (typing Return in the type-in area).
   The value in <CODE>v</CODE> is changed before <CODE>v.callback</CODE> is invoked.
<P>
   The value in <CODE>v</CODE> is range-checked before the callback is called, and
   in every call to <CODE>Get</CODE>.  If the number is out of range, the nearest number
   in range will be written into the type-in area, and that value will
   be returned to the caller of <CODE>Get</CODE>.
<P>
 

<P><PRE>PROCEDURE <A HREF="NumericVBT.m3#Put">Put</A> (v: T; n: INTEGER);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Change the value in <CODE>v</CODE> to be
<PRE>
       MIN(GetMax(v), MAX(GetMin(v), n))
   </PRE>
and display this value in the type-in area.  Note that
   <CODE>v.callback</CODE> is not invoked. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="NumericVBT.m3#PutBounds">PutBounds</A> (v: T; min, max: INTEGER);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Change <CODE>v.min</CODE> to be <CODE>min</CODE> and <CODE>v.max</CODE> to be <CODE>MAX(min, max)</CODE>,
   and then call <CODE>Put(v, Get(v))</CODE>.  The call to <CODE>Put</CODE> has the
   effect of projecting the value of <CODE>v</CODE> into the new bounds. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="NumericVBT.m3#Get">Get</A> (v: T)   : INTEGER; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the current value in <CODE>v</CODE>.  This value is range-checked, in case
   the user typed an out-of-range value without typing Return. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="NumericVBT.m3#GetMin">GetMin</A> (v: T): INTEGER; &lt;* LL.sup = VBT.mu *&gt;
PROCEDURE <A HREF="NumericVBT.m3#GetMax">GetMax</A> (v: T): INTEGER; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the indicated value associated with <CODE>v</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="NumericVBT.m3#SetEmpty">SetEmpty</A> (v: T);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Set <CODE>v</CODE> to the empty state.  This is a no-op unless <CODE>allowEmpty</CODE> was
   <CODE>TRUE</CODE> when <CODE>v</CODE> was initialized. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="NumericVBT.m3#IsEmpty">IsEmpty</A> (v: T): BOOLEAN;
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Test whether <CODE>v</CODE> is in the empty state.  If <CODE>allowEmpty</CODE> was
   not <CODE>TRUE</CODE> when <CODE>v</CODE> was initialized, this procedure will always
   return <CODE>FALSE</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="NumericVBT.m3#TakeFocus">TakeFocus</A> (v          : T;
                     time       : VBT.TimeStamp;
                     alsoSelect : BOOLEAN       := TRUE):
  BOOLEAN;
&lt;* LL = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Cause the type-in area to grab the keyboard focus.  If the
   focus could be grabbed and if <CODE>alsoSelect</CODE> is set, the type-in
   area will make its entire text the primary selection.  Returns
   whether the keyboard focus could be acquired. </EM></BLOCKQUOTE><PRE>

END NumericVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
