<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/NumericVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/NumericVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;

MODULE <module><implements><A HREF="NumericVBT.i3">NumericVBT</A></implements></module>;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../vbtkitutils/src/AnyEvent.i3">AnyEvent</A>, <A HREF="../../ui/src/split/Filter.i3">Filter</A>, <A HREF="../../ui/src/vbt/Font.i3">Font</A>, <A HREF="FlexVBT.i3">FlexVBT</A>, <A HREF="#x1">FloatMode</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../ui/src/split/HVSplit.i3">HVSplit</A>, <A HREF="../../fmtlex/src/Lex.i3">Lex</A>,
       <A HREF="../../ui/src/vbt/Pixmap.i3">Pixmap</A>, <A HREF="PixmapVBT.i3">PixmapVBT</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="Shadow.i3">Shadow</A>, <A HREF="ShadowedFeedbackVBT.i3">ShadowedFeedbackVBT</A>, <A HREF="ShadowedVBT.i3">ShadowedVBT</A>,
       <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../etext/src/TextPort.i3">TextPort</A>, <A HREF="../../etext/src/TextPortClass.i3">TextPortClass</A>, <A HREF="../../rw/src/Common/TextRd.i3">TextRd</A>, <A HREF="../../ui/src/split/TextureVBT.i3">TextureVBT</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>,
       <A HREF="TrillSwitchVBT.i3">TrillSwitchVBT</A>, <A HREF="../../etext/src/TypeinVBT.i3">TypeinVBT</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="VBTKitResources.i3">VBTKitResources</A>, <A HREF="../../vtext/src/VText.i3">VText</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        (* create-time options: *)
        allowEmpty: BOOLEAN;
        (* changable options: *)
        min, max: INTEGER;
        (* current state: *)
        val   : INTEGER;
        digits: CARDINAL := 0;
        empty : BOOLEAN;
      OVERRIDES
        init     := Init;
        callback := Callback;
      END;
  <A NAME="Typein">Typein</A> = TypeinVBT.T BRANDED OBJECT
             v: T
           OVERRIDES
             returnAction := ReturnAction;
             reshape      := Reshape
           END;

TYPE
  State = RECORD
            num  : INTEGER;
            empty: BOOLEAN
          END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v         : T;
                min       : INTEGER  := FIRST (INTEGER);
                max       : INTEGER  := LAST (INTEGER);
                allowEmpty: BOOLEAN  := FALSE;
                naked     : BOOLEAN  := FALSE;
                font      : Font.T   := Font.BuiltIn;
                shadow    : Shadow.T := NIL              ): T =
  VAR hsplit, minus, plus: VBT.T;
  BEGIN
    IF shadow = NIL THEN shadow := Shadow.None END;
    GetResources ();
    max := MAX (min, max);
    v.allowEmpty := allowEmpty;
    v.min := min;
    v.max := max;
    IF v.typein = NIL THEN v.typein := NEW (Typein) END;
    v.typein := v.typein.init (FALSE, 0.5, 0.5, font, shadow, wrap := FALSE);
    v.typein.v := v;
    IF min &lt;= 0 AND 0 &lt;= max THEN
      PutCl (v, State {0, allowEmpty})
    ELSE
      PutCl (v, State {min, allowEmpty})
    END;
    IF naked THEN
      EVAL Filter.T.init (v, NEW (ShadowedVBT.T).init (
                               v.typein, shadow, Shadow.Style.Lowered));
    ELSE
      minus := NewPlusMinusVBT (v, -1, shadow, minusOff);
      plus := NewPlusMinusVBT (v, 1, shadow, plusOff);
      hsplit :=
        FlexVBT.FromAxis (
          HVSplit.Cons (
            Axis.T.Hor, minus, VBar (shadow),
            NEW (ShadowedVBT.T).init (v.typein, shadow, Shadow.Style.Raised),
            VBar (shadow), plus),
          Axis.T.Hor, FlexVBT.RigidRange (25.0));
      EVAL Filter.T.init (v, hsplit);
    END;
    RETURN v;
  END Init;

PROCEDURE <A NAME="Callback"><procedure>Callback</procedure></A> (&lt;* UNUSED *&gt; v: T; &lt;* UNUSED *&gt; event: AnyEvent.T) =
  BEGIN
  END Callback;

PROCEDURE <A NAME="VBar"><procedure>VBar</procedure></A> (shadow: Shadow.T): VBT.T =
  BEGIN
    IF shadow.size # 0.0 THEN
      RETURN NIL
    ELSE
      RETURN FlexVBT.FromAxis(TextureVBT.New(shadow.bgFg),
                                Axis.T.Hor, FlexVBT.RigidRange(1.0))
    END
  END VBar;

PROCEDURE <A NAME="ReturnAction"><procedure>ReturnAction</procedure></A> (typein: Typein; READONLY cd: VBT.KeyRec) =
  VAR v := typein.v;
  BEGIN
    PutCl (v, ReadState (v));
    v.callback (AnyEvent.FromKey (cd))
  END ReturnAction;

PROCEDURE <A NAME="Reshape"><procedure>Reshape</procedure></A> (typein: Typein; READONLY cd: VBT.ReshapeRec) =
  TYPE Pixels = CARDINAL;

  BEGIN
    TypeinVBT.T.reshape (typein, cd);
    IF cd.new = Rect.Empty THEN RETURN END;
    LOCK typein.mu DO
      VAR
        width: Pixels  := Rect.HorSize (VBT.Domain (typein));
        vtext: VText.T := typein.vtext;
        marginSlack: Pixels := vtext.leftMargin + vtext.rightMargin
                                 + 2 * vtext.turnMargin;
      BEGIN
        IF typein.charWidth &gt; 0 AND width &gt; marginSlack THEN
          typein.v.digits := (width - marginSlack) DIV typein.charWidth
        ELSE
          typein.v.digits := 0
        END
      END
    END;
    PutCl (typein.v, ReadState (typein.v))
  END Reshape;

PROCEDURE <A NAME="CheckAndFixValue"><procedure>CheckAndFixValue</procedure></A> (v: T) =
  VAR s := ReadState (v);
  BEGIN
    IF s.empty THEN
      IF v.allowEmpty THEN
        v.val := FIRST (INTEGER);
        v.empty := TRUE
      ELSE
        PutCl (v, s)
      END
    ELSIF s.num &lt; v.min OR s.num &gt; v.max THEN
      PutCl (v, s)
    ELSE
      v.val := s.num;
      v.empty := FALSE
    END
  END CheckAndFixValue;

PROCEDURE <A NAME="ReadState"><procedure>ReadState</procedure></A> (v: T): State =
  VAR contents := TextPort.GetText (v.typein);
  BEGIN
    IF Text.Empty (contents) THEN
      IF v.allowEmpty THEN
        RETURN State {FIRST (INTEGER), TRUE}
      ELSE
        RETURN State {0, FALSE}
      END
    ELSE
      TRY
        (* RETURN State {Scan.Int (StripLeadingBlanks (contents)), FALSE} *)
        RETURN State {Lex.Int (TextRd.New (contents)), FALSE}
      EXCEPT
      | Lex.Error, FloatMode.Trap, Rd.Failure, Thread.Alerted =&gt;
          (* We may have all kinds of illegal characters -- through the
             primary/secondary replacement mechanism, for example.  So we must
             be careful. *)
          RETURN State {v.val, FALSE}
      END
    END
  END ReadState;
</PRE>*******
PROCEDURE StripLeadingBlanks (t: TEXT): TEXT =
  BEGIN
    FOR i := 0 TO Text.Length (t) - 1 DO
      IF Text.GetChar (t, i) = ' ' THEN (* skip 
      <PRE>ELSIF i = 0 THEN
        RETURN t
      ELSE
        RETURN Text.Sub (t, i, LAST (CARDINAL))
      END
    END;
    RETURN &quot;&quot;
  END StripLeadingBlanks;
*************)

TYPE
  PlusMinusVBT = TrillSwitchVBT.T BRANDED OBJECT
                   v    : T;
                   delta: INTEGER;
                 OVERRIDES
                   callback := PlusMinus
                 END;

PROCEDURE <A NAME="NewPlusMinusVBT"><procedure>NewPlusMinusVBT</procedure></A> (v       : T;
                           delta   : INTEGER;
                           shadow  : Shadow.T;
                           contents: Pixmap.T  ): PlusMinusVBT =
  VAR
    p := NEW (PixmapVBT.T).init (contents, shadow.bgFg, shadow.bg);
    f := NEW (ShadowedFeedbackVBT.T).init (p, shadow);
    pm: PlusMinusVBT := NEW (PlusMinusVBT).init (f);
  BEGIN
    pm.v := v;
    pm.delta := delta;
    RETURN pm;
  END NewPlusMinusVBT;

PROCEDURE <A NAME="PlusMinus"><procedure>PlusMinus</procedure></A> (pm: PlusMinusVBT; READONLY cd: VBT.MouseRec) =
  VAR v := pm.v;
  BEGIN
    CheckAndFixValue (v);
    IF v.empty THEN RETURN END;
    PutCl (v, State {v.val + pm.delta, FALSE});
    v.callback (AnyEvent.FromMouse (cd))
  END PlusMinus;

PROCEDURE <A NAME="Put"><procedure>Put</procedure></A> (v: T; n: INTEGER) =
  BEGIN
    PutCl (v, State {n, FALSE});
  END Put;

PROCEDURE <A NAME="PutBounds"><procedure>PutBounds</procedure></A> (v: T; min, max: INTEGER) =
  BEGIN
    v.min := min;
    v.max := max;
    PutCl (v, State {v.val, FALSE});
  END PutBounds;

PROCEDURE <A NAME="SetEmpty"><procedure>SetEmpty</procedure></A> (v: T) =
  BEGIN
    IF v.allowEmpty THEN PutCl (v, State {0, TRUE}) END;
  END SetEmpty;

PROCEDURE <A NAME="PutCl"><procedure>PutCl</procedure></A> (v: T; READONLY s: State) =
  BEGIN
    IF s.empty AND v.allowEmpty THEN
      v.empty := TRUE;
      v.val := FIRST (INTEGER);
      TextPort.SetText (v.typein, &quot;&quot;)
    ELSE
      v.empty := FALSE;
      v.val := MIN (v.max, MAX (v.min, s.num));
      TextPort.SetText (v.typein, Fmt.Pad (Fmt.Int (v.val), v.digits))
    END
  END PutCl;

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A> (v: T): INTEGER =
  BEGIN
    CheckAndFixValue(v);
    RETURN v.val;
  END Get;

PROCEDURE <A NAME="GetMin"><procedure>GetMin</procedure></A> (v: T): INTEGER =
  BEGIN
    CheckAndFixValue(v);
    RETURN v.min;
  END GetMin;

PROCEDURE <A NAME="GetMax"><procedure>GetMax</procedure></A> (v: T): INTEGER =
  BEGIN
    CheckAndFixValue(v);
    RETURN v.max;
  END GetMax;

PROCEDURE <A NAME="IsEmpty"><procedure>IsEmpty</procedure></A> (v: T): BOOLEAN =
  BEGIN
    CheckAndFixValue(v);
    RETURN v.empty;
  END IsEmpty;

PROCEDURE <A NAME="TakeFocus"><procedure>TakeFocus</procedure></A> (v: T; time: VBT.TimeStamp; alsoSelect: BOOLEAN := TRUE):
  BOOLEAN =
  BEGIN
    IF NOT TextPort.TryFocus (v.typein, time) THEN RETURN FALSE END;
    IF alsoSelect THEN
      TextPort.Select (
        v.typein, time, 0, LAST (CARDINAL), replaceMode := TRUE);
    END;
    RETURN TRUE
  END TakeFocus;

VAR
  rsrcMu := NEW (MUTEX);
  &lt;* LL = rsrcMu *&gt;
  rsrcInit                    := FALSE;

VAR minusOff, plusOff: Pixmap.T;

PROCEDURE <A NAME="GetResources"><procedure>GetResources</procedure></A> () =
  BEGIN
    LOCK rsrcMu DO
      IF rsrcInit THEN RETURN END;
      minusOff := VBTKitResources.GetPixmap (&quot;minusOff&quot;);
      plusOff := VBTKitResources.GetPixmap (&quot;plusOff&quot;);
      rsrcInit := TRUE;
    END
  END GetResources;

BEGIN
END NumericVBT.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface FloatMode is in:
</A><UL>
<LI><A HREF="../../float/src/DS3100/FloatMode.i3#0TOP0">float/src/DS3100/FloatMode.i3</A>
<LI><A HREF="../../float/src/IEEE-default/FloatMode.i3#0TOP0">float/src/IEEE-default/FloatMode.i3</A>
<LI><A HREF="../../float/src/IRIX5/FloatMode.i3#0TOP0">float/src/IRIX5/FloatMode.i3</A>
<LI><A HREF="../../float/src/SOLsun/FloatMode.i3#0TOP0">float/src/SOLsun/FloatMode.i3</A>
<LI><A HREF="../../float/src/SPARC/FloatMode.i3#0TOP0">float/src/SPARC/FloatMode.i3</A>
<LI><A HREF="../../float/src/SUN386/FloatMode.i3#0TOP0">float/src/SUN386/FloatMode.i3</A>
<LI><A HREF="../../float/src/VAX/FloatMode.i3#0TOP0">float/src/VAX/FloatMode.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
