<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/OffsetVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/OffsetVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;*PRAGMA LL*&gt;
</PRE> An <CODE>OffsetVBT.T</CODE> is a filter that maintains a translation
   between the coordinate systems of the child and parent such
   that the child's coordinate system has its origin at the
   northwest corner of the child domain.
<P>
   The child's domain has its northwest corner at (0, 0) and its
   width and height correspond to the child's preferred size.
<P>
   The parent's domain has its northwest corner at an arbitrary
   offset from the child's.
<P>
   The parent's domain may be a different size than the child's.
   Any portion of the child's domain that isn't visible is
   clipped and any portion of the parent's domain that doesn't
   show a portion of the child, displays in the background color.
<P>
   The child can be <CODE>NIL</CODE>, in which case the <CODE>OffsetVBT</CODE> ignores
   all events. 

<P><PRE>INTERFACE <interface><A HREF="OffsetVBT.m3">OffsetVBT</A></interface>;

IMPORT <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../ui/src/split/Filter.i3">Filter</A>;

TYPE
  <A HREF="OffsetVBT.m3#T">T</A> &lt;: TPublic;
  TPublic =
    Filter.T OBJECT
    METHODS
      init (ch: VBT.T; north, west: REAL := 0.0): T;
      move (north, west: REAL);  &lt;* LL = VBT.mu *&gt;
    END;
</PRE> The call <CODE>v.init(ch)</CODE> initializes <CODE>v</CODE> as an <CODE>OffsetVBT</CODE> with
   child <CODE>ch</CODE>.  And the northwest corner of the parent is aligned
   at co-ordinate (north, west) mm in the child domain.
<P>
   The call <CODE>v.move(north, west)</CODE> adjusts the co-ordinate system
   so that the <CODE>v</CODE>s northwest corner is positioned at co-ordinate
   (<CODE>north</CODE>, <CODE>west</CODE>) millimeters in the child domain.  This
   offset will be maintained as <CODE>v</CODE> is reshaped or rescreened. 

<P>
<P><PRE>END OffsetVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
