<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/OffsetVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/OffsetVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="OffsetVBT.i3">OffsetVBT</A></implements></module>;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../ui/src/split/Filter.i3">Filter</A>, <A HREF="../../ui/src/split/FilterClass.i3">FilterClass</A>, <A HREF="../../ui/src/vbt/MouseSplit.i3">MouseSplit</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../ui/src/vbt/Pixmap.i3">Pixmap</A>, <A HREF="../../geometry/src/Point.i3">Point</A>,
       <A HREF="../../ui/src/vbt/VBTClass.i3">VBTClass</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../geometry/src/Region.i3">Region</A>, <A HREF="../../ui/src/vbt/Trestle.i3">Trestle</A>, <A HREF="../../ui/src/vbt/Batch.i3">Batch</A>, <A HREF="../../ui/src/vbt/BatchUtil.i3">BatchUtil</A>, <A HREF="../../ui/src/vbt/ScrnCursor.i3">ScrnCursor</A>,
       <A HREF="../../ui/src/vbt/ScrnPixmap.i3">ScrnPixmap</A>, <A HREF="../../ui/src/vbt/VBTRep.i3">VBTRep</A>;

REVEAL
  <A NAME="T">T</A> = TPublic BRANDED OBJECT
    delta: Point.T;
    (* child coord + delta = parent coord. *)
    (* v.delta is protected both by v and by VBT.mu.
       (If v is disconnected, these locks are not necessary). *)
    screen: VBT.ScreenID := -1;
    north, west: REAL;

    (* from MouseSplit.MouseRef *)
    (* All fields protected by VBT.mu; mouseFocus, current, cache, and
      tracking are also protected by self *)
    mouseFocus: VBT.T := NIL;
    current: VBT.T := NIL;
    (* the child containing the last reported position of the
       cursor, or NIL if this position was not over any child. *)
    cache: VBT.Cage := VBT.GoneCage;
    (* If meth is the mouseRef of the VBT c and meth.cache.inOut =
       {FALSE} then for all points p in meth.cache.rect, Locate(c, p,
       ...)  returns meth.current.  Otherwise meth.cache.inOut = {TRUE},
       and the last position received by the parent was gone.  In any
       case, if meth.cache is non-empty then it contains the last
       position received by the parent.  *)
    tracking: BOOLEAN := FALSE;
    (* TRUE if some child other than current or the mouseFocus
       has a cage that does not contain GoneCage. *)
  OVERRIDES
    (* VBT down methods *)
    reshape := Reshape;
    repaint := Repaint;
    rescreen := Rescreen;
    mouse := Mouse;
    position := Position;
    redisplay := Redisplay;
    shape := Shape;
    locate := Locate;

    (* VBT up methods *)
    setcage := Setcage;
    setcursor := Setcursor;
    paintbatch := PaintBatch;
    capture := Capture;
    screenOf := ScreenOf;
    newShape := NewShape;

    (* split methods *)
    beChild := BeChild;
    init := Init;

    (* ScrollVBT methods *)
    move := Move;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v: T; ch: VBT.T; north, west: REAL): T =
  BEGIN
    LOCK v DO
      v.north := north;
      v.west := west;
      v.delta := Rect.NorthWest(v.domain);
      IF v.st # NIL THEN
        v.delta :=
          Point.Sub(
            v.delta, Point.T{ROUND(VBT.MMToPixels(v, west, Axis.T.Hor)),
                             ROUND(VBT.MMToPixels(v, north, Axis.T.Ver))});
      END;
    END;
    EVAL Filter.Replace(v, ch);
    RETURN v
  END Init;

PROCEDURE <A NAME="BeChild"><procedure>BeChild</procedure></A>(v: T; ch: VBT.T) RAISES {} =
  BEGIN
    Filter.T.beChild(v, ch);
    VBTClass.ClearShortCircuit(ch)
  END BeChild;

PROCEDURE <A NAME="Repaint"><procedure>Repaint</procedure></A> (prnt: T; READONLY rgn: Region.T) RAISES {} =
  VAR a: Rect.Partition;
  BEGIN                          (* LL = VBT.mu *)
    IF prnt.ch # NIL THEN
      VBTClass.Repaint(prnt.ch, Region.Sub(rgn, prnt.delta));
      Rect.Factor(rgn.r, Rect.Move(prnt.ch.domain, prnt.delta), a, 0, 0);
      a[2] := a[4];
      VBT.PolyTexture(
        prnt, SUBARRAY(a, 0, 4), PaintOp.BgFg, Pixmap.Empty, Point.Origin);
    END
  END Repaint;

PROCEDURE <A NAME="Rescreen"><procedure>Rescreen</procedure></A> (prnt: T; READONLY cd: VBT.RescreenRec) =
  VAR screen := Trestle.ScreenOf(prnt, Point.Origin).id;
  BEGIN
    LOCK prnt DO prnt.screen := screen END;
    VBT.Split.rescreen(prnt, cd);
    VBT.Mark(prnt);
  END Rescreen;

PROCEDURE <A NAME="Redisplay"><procedure>Redisplay</procedure></A> (prnt: T) =
  BEGIN
    IF prnt.ch # NIL THEN
      (* reshape child to preferred size *)
      WITH szs = VBTClass.GetShapes(prnt.ch),
           dom = Rect.FromSize(szs[Axis.T.Hor].pref, szs[Axis.T.Ver].pref) DO
        IF NOT Rect.Equal(prnt.ch.domain, dom) THEN
          VBTClass.Reshape(prnt.ch, dom, Rect.Empty);
          InvalidateCache(prnt);
        END;
      END;
    END;
  END Redisplay;

PROCEDURE <A NAME="Reshape"><procedure>Reshape</procedure></A> (prnt: T; READONLY cd: VBT.ReshapeRec) RAISES {} =
  VAR
    delta, deltaP: Point.T;
    chbad        : Region.T;
    saved        : Rect.T;
  BEGIN
    IF prnt.ch # NIL THEN
      IF cd.marked OR Rect.IsEmpty(cd.prev) THEN Redisplay(prnt); END;
      delta :=
        Point.Sub(
          Rect.NorthWest(cd.new),
          Point.T{ROUND(VBT.MMToPixels(prnt, prnt.west, Axis.T.Hor)),
                  ROUND(VBT.MMToPixels(prnt, prnt.north, Axis.T.Ver))});
      deltaP := Point.Sub(delta, prnt.delta);
      saved := Rect.Meet(Rect.Move(cd.saved, deltaP), cd.new);
      LOCK prnt.ch DO
        VBT.Scroll(prnt, saved, deltaP);
        prnt.delta := delta;
      END;
      chbad := Region.Difference(
                 Region.FromRect(prnt.domain), Region.FromRect(saved));
      Repaint(prnt, chbad);
    END;
  END Reshape;

PROCEDURE <A NAME="Shape"><procedure>Shape</procedure></A> (&lt;* UNUSED *&gt; prnt: T;
                 &lt;* UNUSED *&gt; ax  : Axis.T;
                 &lt;* UNUSED *&gt; n   : CARDINAL): VBT.SizeRange =
  BEGIN
    RETURN VBT.DefaultShape;
  END Shape;

PROCEDURE <A NAME="ScreenOf"><procedure>ScreenOf</procedure></A>(
    prnt: T;
    &lt;*UNUSED*&gt; ch: VBT.T;
    READONLY pt: Point.T):
    Trestle.ScreenOfRec
    RAISES {} =
  BEGIN (* LL=ch *)
    RETURN Trestle.ScreenOf(prnt, Point.Add(pt, prnt.delta));
  END ScreenOf;

PROCEDURE <A NAME="Capture"><procedure>Capture</procedure></A>(
    prnt: T;
    &lt;*UNUSED*&gt; ch: VBT.T;
    READONLY rect: Rect.T;
    VAR (*out*) br: Region.T)
    : ScrnPixmap.T RAISES {} =
  VAR res: ScrnPixmap.T;
  BEGIN (* LL = ch *)
    res := VBT.Capture(prnt, Rect.Add(rect, prnt.delta), br);
    br := Region.Sub(br, prnt.delta);
    RETURN res
  END Capture;

PROCEDURE <A NAME="PaintBatch"><procedure>PaintBatch</procedure></A>(prnt: T; &lt;*UNUSED*&gt; ch: VBT.T; ba: Batch.T) RAISES {} =
  BEGIN
    BatchUtil.Clip(ba);
    BatchUtil.Translate(ba, prnt.delta);
    VBTClass.PaintBatch(prnt, ba)
  END PaintBatch;

PROCEDURE <A NAME="NewShape"><procedure>NewShape</procedure></A>(prnt: T; &lt;* UNUSED *&gt; ch: VBT.T) =
  BEGIN
    VBTRep.Mark(prnt);
  END NewShape;

PROCEDURE <A NAME="Move"><procedure>Move</procedure></A> (prnt: T; north, west: REAL) =
  VAR
    delta, deltaP: Point.T;
    chbad        : Region.T;
  BEGIN
    LOCK prnt DO prnt.north := north; prnt.west := west; END;
    IF prnt.ch # NIL THEN
      delta := Point.Sub(
                 Rect.NorthWest(prnt.domain),
                 Point.T{ROUND(VBT.MMToPixels(prnt, west, Axis.T.Hor)),
                         ROUND(VBT.MMToPixels(prnt, north, Axis.T.Ver))});
      deltaP := Point.Sub(delta, prnt.delta);
      LOCK prnt.ch DO
        VBT.Scroll(prnt, prnt.domain, deltaP);
        prnt.delta := delta;
      END;
      chbad :=
        Region.Difference(Region.FromRect(prnt.domain),
                          Region.FromRect(Rect.Add(prnt.domain, deltaP)));
      Repaint(prnt, chbad);
    END
  END Move;
</PRE> FROM MouseSplit 

<P><PRE>PROCEDURE <A NAME="Setcursor"><procedure>Setcursor</procedure></A>(v: T; ch: VBT.T) RAISES {} =
  VAR cs: ScrnCursor.T; BEGIN (* LL=ch *)
    LOCK v DO
      WITH r = v DO
        IF ch # r.mouseFocus AND
            (ch # r.current OR r.mouseFocus # NIL)
        THEN
          RETURN
        END
      END
    END;
    cs := ch.getcursor();
    LOCK v DO
      WITH r = v DO
        IF (ch = r.mouseFocus OR
            ch = r.current AND r.mouseFocus = NIL)
        THEN
          SetCursor2(v, cs)
        END
      END
    END
  END Setcursor;

&lt;*INLINE*&gt; PROCEDURE <A NAME="SetCursor2"><procedure>SetCursor2</procedure></A>(v: T; cs: ScrnCursor.T) RAISES {} =
  BEGIN (* LL=v *)
    IF cs # v.effectiveCursor THEN
      v.effectiveCursor := cs;
      IF v.parent # NIL THEN v.parent.setcursor(v) END
    END
  END SetCursor2;

&lt;*INLINE*&gt; PROCEDURE <A NAME="SetCursor3"><procedure>SetCursor3</procedure></A>(v: T; ch: VBT.T) RAISES {} =
  BEGIN
    IF ch # NIL THEN
      LOCK ch DO
        VAR cs := ch.getcursor(); BEGIN
          LOCK v DO SetCursor2(v, cs) END
        END
      END
    ELSE
      LOCK v DO SetCursor2(v, ScrnCursor.DontCare) END
    END
  END SetCursor3;
</PRE> Cage setting depends on the following invariants:
<P>
   (R1) v's cage is contained in the intersection of its children's 
        cages.  This guarantees that v will get a position whenever 
        any child is owed one.
<P>
   (R2) v's cage is contained in v.cache.  This guarantees that v will 
        get a position whenever <CODE>current</CODE> should be changed.
<P>
   (R3) v.tracking OR for each ch # v.mouseFocus AND ch # v.current,
        ch.cage contains GoneCage.  
<P>
    When the parent receives a position its cage is set arbitrarily,
    so the invariants are destroyed.  It sets its cage to satisfy R2,
    and then delivers positions to its children.  The SetCages which
    they do in response to the positions reestablish R1 and R3 before
    the parent Position returns.  

<P><PRE>PROCEDURE <A NAME="Setcage"><procedure>Setcage</procedure></A> (v: T; ch: VBT.T) RAISES {} =
  VAR cg := VBTClass.Cage(ch);
  BEGIN                          (*LL=ch*)
    LOCK v DO
      IF cg.rect # Rect.Full AND v.screen = cg.screen THEN
        cg.rect := Rect.Move(cg.rect, v.delta)
      END;
      WITH r          = v,
           notCurrent = (ch # r.current) DO
        IF NOT (notCurrent IN cg.inOut) THEN cg := VBT.EmptyCage END;
        cg.inOut := VBT.InOut{FALSE, TRUE};
        IF notCurrent AND (ch # r.mouseFocus)
             AND ((NOT Rect.Equal(cg.rect, Rect.Full))
                    OR (cg.screen # VBT.AllScreens)) THEN
          r.tracking := TRUE
        END;
        VBTClass.SetCage(v, cg);
      END
    END
  END Setcage;

PROCEDURE <A NAME="Position"><procedure>Position</procedure></A>(v: T; READONLY cdIn: VBT.PositionRec)
  RAISES {} =
  VAR
    current, mouseFocus, newCurrent: VBT.T := NIL;
    cd := cdIn;
    goneCd: VBT.PositionRec;
    changed := TRUE;
    newCache: VBT.Cage;
    tracking := FALSE;
  BEGIN (* LL = VBT.mu *)
    WITH r = v DO
        current := r.current;
        mouseFocus := r.mouseFocus;
        tracking := r.tracking;
      IF cd.cp.gone THEN
        changed := (current # NIL) OR (FALSE IN r.cache.inOut);
        newCurrent := NIL;
        newCache := VBT.GoneCage;
        VBT.SetCage(v, newCache)
      ELSIF  NOT VBT.Outside(cd.cp, r.cache) THEN
        changed := FALSE;
        newCurrent := current;
        VBT.SetCage(v, r.cache)
      ELSE
        newCurrent := v.locate(cd.cp.pt, newCache.rect);
        IF newCurrent # NIL THEN
          newCache.rect := Rect.Meet(newCache.rect, newCurrent.domain)
        ELSE
          newCache.rect := Rect.Meet(newCache.rect, v.domain)
        END;
        newCache.inOut := VBT.InOut{FALSE};
        newCache.screen := cd.cp.screen;
        VBT.SetCage(v, newCache)
      END;
      IF changed OR tracking THEN
        LOCK v DO
          r.current := newCurrent;
          r.cache := newCache;
          r.tracking := FALSE;
        END
      END
    END;
    IF NOT cd.cp.offScreen THEN
      cd.cp.pt := Point.Sub(cd.cp.pt, v.delta);
    END;
    goneCd := cd;
    goneCd.cp.gone := TRUE;
    IF current # newCurrent THEN
      (* possibly deliver &quot;gone&quot; to old current;
         possibly change cursors. *)
      IF current # NIL AND current # mouseFocus THEN
        VBTClass.Position(current, goneCd)
      END;
      IF mouseFocus = NIL THEN SetCursor3(v, newCurrent) END
    END;
    IF mouseFocus # NIL AND mouseFocus # newCurrent THEN
      VBTClass.Position(mouseFocus, goneCd)
    END;
    IF tracking THEN
      VAR ch := v.succ(NIL); BEGIN
        WHILE ch # NIL DO
          IF ch # mouseFocus AND ch # current AND ch # newCurrent THEN
            VBTClass.Position(ch, goneCd)
          END;
          ch := v.succ(ch)
        END
      END
    END;
    IF newCurrent # NIL THEN
      VBTClass.Position(newCurrent, cd)
    END
  END Position;

PROCEDURE <A NAME="BecomeMF"><procedure>BecomeMF</procedure></A>(v: T; mf: VBT.T) =
  BEGIN
    LOCK v DO
      v.mouseFocus := mf
    END;
    IF mf # NIL THEN
      SetCursor3(v, mf)
    ELSE
      SetCursor3(v, v.current)
    END
  END BecomeMF;

PROCEDURE <A NAME="Mouse"><procedure>Mouse</procedure></A> (v: T; READONLY cdIn: VBT.MouseRec) RAISES {} =
  VAR
    ch    : VBT.T;
    junk  : Rect.T;
    goneCd: VBT.MouseRec;
    cd                   := cdIn;
  BEGIN
    (* Set ch to the child containing the position of cd. *)
    WITH r = v DO
      IF cd.cp.gone THEN
        ch := NIL
      ELSIF (FALSE IN r.cache.inOut)
              AND Rect.Member(cd.cp.pt, r.cache.rect) THEN
        ch := r.current
      ELSE
        ch := v.locate(cd.cp.pt, junk)
      END;
      IF NOT cd.cp.offScreen THEN
        cd.cp.pt := Point.Sub(cd.cp.pt, v.delta)
      END;
      (* Deliver the mouse code. *)
      IF ch # NIL THEN VBTClass.Mouse(ch, cd) END;
      (* Possibly deliver cd to the mouseFocus *)
      IF r.mouseFocus # NIL AND r.mouseFocus # ch THEN
        goneCd := cd;
        goneCd.cp.gone := TRUE;
        VBTClass.Mouse(r.mouseFocus, goneCd)
      END
    END;
    (* reset the mouseFocus *)
    IF cd.clickType = VBT.ClickType.FirstDown THEN
      BecomeMF(v, ch)
    ELSIF cd.clickType = VBT.ClickType.LastUp THEN
      BecomeMF(v, NIL)
    END
  END Mouse;

PROCEDURE <A NAME="InvalidateCache"><procedure>InvalidateCache</procedure></A>(v: T) =
  BEGIN
    LOCK v DO
      WITH r = v DO
        IF (FALSE IN r.cache.inOut) THEN
           r.cache.rect := Rect.Empty;
           VBTClass.SetCage(v, r.cache)
        END
      END
    END
  END InvalidateCache;

PROCEDURE <A NAME="Locate"><procedure>Locate</procedure></A> (v: T; READONLY pt: Point.T; VAR (*OUT*) rect: Rect.T):
  VBT.T RAISES {} =
  VAR ch := v.succ(NIL);
  BEGIN
    rect := Rect.Full;
    WHILE ch # NIL DO
      (* (pt IN rect), rect doesn't intersect the domain of any predecessor
         of ch *)
      WITH r = Rect.Add(ch.domain, v.delta) DO
        IF r.west &gt;= r.east THEN (* skip *)
        ELSIF pt.v &lt; r.north THEN
          IF rect.south &gt; r.north THEN rect.south := r.north END
        ELSIF pt.v &gt;= r.south THEN
          IF rect.north &lt; r.south THEN rect.north := r.south END
        ELSIF pt.h &lt; r.west THEN
          IF rect.east &gt; r.west THEN rect.east := r.west END
        ELSIF pt.h &gt;= r.east THEN
          IF rect.west &lt; r.east THEN rect.west := r.east END
        ELSE
          rect := Rect.Meet(rect, r);
          RETURN ch
        END;
        ch := v.succ(ch)
      END
    END;
    RETURN NIL
  END Locate;

BEGIN
END OffsetVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
